#ifndef _TASK_H_
#define _TASK_H_

enum {
  MAX_NUM_POINTER = 3,
};

typedef void task_func;

struct _task {
  task_func (*fp)(struct _task *task);
  guint count;
  gboolean alive;
  gpointer pointer[MAX_NUM_POINTER];
  struct _task *prev;
  struct _task *next;
};

void task_init();
void task_free();
struct _task *task_add(task_func (*fp)(struct _task *task), ...);
void task_schedular();
#endif

