#include "stdafx.h"
#include "CModelPlugin.h"

//	OO[o
extern CScene *g_Scene;

//	O[o
CHeadlight g_TempHeadlight;
CParticle g_TempParticle;
CSoundEffector g_TempSoundEffector;

/*
 *	RXgN^
 */
CEffectorContainer::CEffectorContainer(){
	m_Effector = NULL;
}

/*
 *	Rs[RXgN^
 */
CEffectorContainer::CEffectorContainer(
	const CEffectorContainer &src	//	Rs[
){
	m_Effector = src.m_Effector->Duplicate();
}

/*
 *	fXgN^
 */
CEffectorContainer::~CEffectorContainer(){
	DELETE_V(m_Effector);
}

/*
 *	Ǎ
 */
char *CEffectorContainer::Read(
	char *str,			//	Ώە
	CModelPlugin *mpi	//	fvOC
){
	char *tmp;
	DELETE_V(m_Effector);
	CHeadlightApplier headlightapplier;
	CParticleApplier particleapplier;
	CSoundApplier soundapplier;
	CEffectorSwitchApplier effectorswitchapplier;
	if(tmp = headlightapplier.Read(str, mpi)){
		str = tmp;
		m_Effector = new CHeadlightApplier(headlightapplier);
	}else if(tmp = particleapplier.Read(str, mpi)){
		str = tmp;
		m_Effector = new CParticleApplier(particleapplier);
	}else if(tmp = soundapplier.Read(str, mpi)){
		str = tmp;
		m_Effector = new CSoundApplier(soundapplier);
	}else if(tmp = effectorswitchapplier.Read(str, mpi)){
		str = tmp;
		m_Effector = new CEffectorSwitchApplier(effectorswitchapplier);
	}else{
		str = NULL;
	}
	return str;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ǎ
 */
char *CHeadlightApplier::Read(
	char *str,			//	Ώە
	CModelPlugin *mpi	//	fvOC
){
	if(!(str = g_TempHeadlight.Read(str, mpi))) return NULL;
	m_Headlight = mpi->AddHeadlight(g_TempHeadlight);
	return str;
}

/*
 *	f[^Ǎ
 */
void CHeadlightApplier::LoadDataEffector(
	CModelPlugin *mpi	//	Ăяo
){
	m_Headlight->LoadData();
}

/*
 *	ύXqKp
 */
void CHeadlightApplier::ApplyEffector(
	CScene *scene	//	V[
){
	if(!g_PreSimulationFlag && (!scene || scene==g_Scene)) m_Headlight->Register();
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ǎ
 */
char *CParticleApplier::Read(
	char *str,			//	Ώە
	CModelPlugin *mpi	//	fvOC
){
	if(!(str = g_TempParticle.Read(str, mpi))) return NULL;
	m_Particle = mpi->AddParticle(g_TempParticle);
	return str;
}

/*
 *	f[^Ǎ
 */
void CParticleApplier::LoadDataEffector(
	CModelPlugin *mpi	//	Ăяo
){
	m_Particle->LoadData();
}

/*
 *	ύXqKp
 */
void CParticleApplier::ApplyEffector(
	CScene *scene	//	V[
){
	if(g_PreSimulationFlag) m_Particle->Register(scene);
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ǎ
 */
char *CSoundApplier::Read(
	char *str,			//	Ώە
	CModelPlugin *mpi	//	fvOC
){
	if(!(str = g_TempSoundEffector.Read(str, mpi))) return NULL;
	m_SoundEffector = mpi->AddSoundEffector(g_TempSoundEffector);
	return str;
}

/*
 *	ύXqKp
 */
void CSoundApplier::ApplyEffector(
	CScene *scene	//	V[
){
	if(!g_PreSimulationFlag) m_SoundEffector->Register(scene);
}
