#ifndef CGAMEMODE_H_INCLUDED
#define CGAMEMODE_H_INCLUDED

#include "CCursor.h"
#include "CCamera.h"
#include "CInterface.h"

class CToggleIcon;

/*
 *	Q[[h
 */
class CGameMode{
protected:
	static int ms_TopPanelTime;					//	pl\
	static int ms_RightPanelTime;				//	Epl\
	static float ms_TopPanelShow;				//	pl\x
	static float ms_RightPanelShow;				//	Epl\x
	static float ms_WindDirTemp;				//	͌vϐ
	static string ms_ModeLabel;					//	[hx
	static CGameMode *ms_ActiveMode;			//	݂̃[h
	static CToggleIcon *ms_MenuIcon[MODE_NUM];	//	[hACR
	CInterface m_Interface;	//	C^[tFCX
public:
	static void WakeUp();
	static void InitMenu();
	static void MainLoop();
	static void LoadModeSettings();
	static void SaveModeSettings(FILE *);
	static void SetNeutral();
	static void Exit(){ ms_ActiveMode = NULL; }
	bool ScanInputFrame(int);
	void RenderFrame(int);
	void RenderCompass();
	bool RenderDialog();
	CGameMode();
	virtual ~CGameMode(){}
	bool IsModeActive(){ return ms_ActiveMode==this; }
	virtual char *LoadSetting(char *str){ return str; }
	virtual void SaveSetting(FILE *){}
	void Enter();
	virtual void EnterGame() = 0;
	void Spin();
	void SpinSound();
	virtual void SpinGame() = 0;
	virtual bool IsPaused(){ return false; }
	int GetEffectSpeed();
};

#endif
