#ifndef CLISTVIEW_H_INCLUDED
#define CLISTVIEW_H_INCLUDED

#include "CInterface.h"
#include "CPushButton.h"
#include "CScrollBarV.h"
#include "CDragContainer.h"
#include "CPopMenu.h"

/*
 *	Xgvf
 */
class CListElement{
	friend class CListView;
protected:
	bool m_Selected;			//	ItO
	DWORD m_Data;				//	֘Af[^
	vector<string> m_String;	//	
	CListElement *m_Next;		//	
	CListView *m_Owner;			//	Xgr[
	CEditBox *m_EditBox;		//	̕ύXpGfBbg{bNX
public:
	CListElement(int, char *, CListView *);
	virtual ~CListElement(){}
	DWORD GetData(){ return m_Data; }
	void SetData(DWORD d){ m_Data = d; }
	bool IsSelected(){ return m_Selected; }
	char *GetString(int i){ return (char *)m_String[i].c_str(); }
	void SetString(int i, char *s){ m_String[i] = s; }
	void BeginRename();
	void EndRename(bool);
	virtual void RenderDragItem(int, int, bool);
	virtual bool Render(int, int, int, int, bool, bool);
};

/*
 *	ACRtXgvf
 */
class CIconListElement: public CListElement{
private:
	LPTEX8 m_IconTex;		//	ACReNX`
	float m_IconRect[4];	//	ACRʒu
public:
	CIconListElement(int, char *, CListView *, LPTEX8, float *);
	void RenderDragItem(int, int, bool);
	bool Render(int, int, int, int, bool, bool);
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

//	IvVtO
const int LISTVIEW_MULTISELECTABLE = 1;
const int LISTVIEW_INSERTABLE = 2;
const int LISTVIEW_RENAMABLE = 4;
const int LISTVIEW_SORTABLE = 8;

/*
 *	Xgr[
 */
class CListView: public CInterface, public CDragInterface{
	friend class CListElement;
	friend class CIconListElement;
protected:
	int m_State;					//	
	int m_Cols;						//	
	int m_Rows;						//	\\s
	int m_RowHeight;				//	
	int m_ColResize;				//	TCY
	int m_ColOldSize;				//	TCY
	int m_GrabPosX;					//	݈ʒu
	int m_FocusIndex;				//	tH[JXʒu
	int m_LastSel;					//	ŌɑIACe
	int m_ItemNum;					//	f[^
	int m_InsertRow;				//	}ʒu
	int m_DownScrollV;				//	NbNXN[ʒu
	DRAGTYPE m_DragType;			//	hbO\ /*CP932Ή*/
	bool m_MultiSelect;				//	I\ /*CP932Ή*/
	bool m_Insertable;				//	}\ /*CP932Ή*/
	bool m_Renamable;				//	l[\ /*CP932Ή*/
	bool m_RenameWait;				//	l[҂
	bool m_Sortable;				//	\[g\ /*CP932Ή*/
	DWORD m_ClickTime;				//	NbN
	POINT m_DownPos;				//	NbNW
	CListElement *m_FocusItem;		//	tH[JXACe
	CListElement *m_DropItem;		//	hbvACe
	CListElement *m_Data;			//	f[^
	CPushButton *m_ColHeader;		//	wb_
	CScrollBarV m_ScrollV;			//	XN[o[
	CMenuCommander *m_Commander;	//	R}_
	CMDTYPE m_CmdType;				//	R}h^Cv
public:
	CListView();
	virtual ~CListView();
	void Init(int, int, int, int, CInterface *, int, char **,
		DRAGTYPE, DWORD, CMenuCommander *cmd = NULL, CMDTYPE ctype = CMD_NONE);
	void SetSize(int, int);
	void ResizeCol(int, int);
	CListElement *InsertItem(int, CListElement *);
	CListElement *InsertItem(int, char *);
	int GetItemNum(){ return m_ItemNum; }
	CListElement *GetElement(int);
	void DeleteAllItems();
	void DeleteItem(int);
	int GetSelectionMark();
	void SetSelectionMark(int, int);
	void SetSelectionArea(int, int, int);
	CListElement *GetFocusItem(){ return m_FocusItem; }
	void EnsureVisible(int);
	void SetScroll();
	int CalcInsertRow(int);
	int GetInsertRow(){ return m_InsertRow; }
	bool IsInsideList(int, int);
	int HitTest(int, int);
	virtual bool IsRenamable(CListElement *){ return true; }
	virtual bool IsDroppable(CListElement *){ return false; }
	virtual bool ConfirmRename(CListElement *, string &){ return true; }
	virtual void EndRename(CListElement *){}
	virtual void Drop(){}
	virtual void DoubleClick(){}
	void PrepareDrag();
	void RenderDragItem();
	bool CheckDrop();
	bool ScanInput();
	void Render();
};

/*
 *	ACRtXgr[
 */
class CIconListView: public CListView{
protected:
public:
	virtual ~CIconListView(){}
	void Init(int, int, int, int, CInterface *, int, char **,
		DRAGTYPE, DWORD, CMenuCommander *cmd = NULL, CMDTYPE ctype = CMD_NONE);
	CListElement *InsertItem(int, char *, LPTEX8, float *);
};

#endif
