#include "stdafx.h"
#include "CListView.h"
#include "CModelInst.h"
#include "CTrainGroup.h"
#include "CEnvPlugin.h"
#include "CConfigMode.h"

//	OO[o
extern CHeadlight g_TempHeadlight;
extern CParticle g_TempParticle;
extern CSoundEffector g_TempSoundEffector;

/*
 *	RXgN^
 */
CModelPlugin::CModelPlugin(
	char *id	//	vOC ID
):
	CPlugin(id)	//	{NX
{
	m_SelectSwitchID = 0;
	m_PartsNum = 0;
}

/*
 *	XCb`Ǎ
 */
char *CModelPlugin::ReadModelSwitch(
	char *str	//	Ώە
){
	char *tmp;
	while(true){
		CModelSwitch msw(m_ModelSwitch.size());
		CTextureAnimation anim;
		if(tmp = msw.Read(str, this)){
			str = tmp;
			m_ModelSwitch.push_back(msw);
		}else if(tmp = anim.Read(str, this)){
			str = tmp;
			m_Animation.push_back(anim);
		}else{
			break;
		}
	}
	if(m_ModelSwitch.size()){
		m_TempSwitch.resize(m_ModelSwitch.size());
		int i;
		for(i = 0; i<m_TempSwitch.size(); i++) m_TempSwitch[i] = 0;
	}
	return str;
}

/*
 *	GtFNgǍ
 */
char *CModelPlugin::ReadEffect(
	char *str	//	Ώە
){
	g_TempHeadlight = CHeadlight();
	g_TempParticle = CParticle();
	char *tmp;
	if(tmp = m_Effector.Read(str, this, 1)) str = tmp;
	return str;
}

/*
 *	f[^ǂݍ
 */
void CModelPlugin::LoadData(){
	ChDir();
	ITextureAnimation ia = m_Animation.begin();
	for(; ia!=m_Animation.end(); ia++) ia->LoadData();
	m_Effector.LoadData(this);
}

/*
 *	XCb`
 */
CModelSwitch *CModelPlugin::FindModelSwitch(
	const string &name	//	XCb`
){
	CModelSwitch *ret;
	IModelSwitch is = m_ModelSwitch.begin();
	for(; is!=m_ModelSwitch.end(); is++) if(ret = is->Check(name)) return ret;
	return NULL;
}

/*
 *	XCb`擾
 */
CModelSwitch *CModelPlugin::GetModelSwitch(
	int index	//	ԍ
){
	int i = 0;
	IModelSwitch is = m_ModelSwitch.begin();
	for(; is!=m_ModelSwitch.end(); is++) if(i++==index) return &*is;
	return NULL;
}

/*
 *	Aj[V
 */
CTextureAnimation *CModelPlugin::FindAnimation(
	const string &name	//	Aj[V
){
	CTextureAnimation *ret;
	ITextureAnimation ia = m_Animation.begin();
	for(; ia!=m_Animation.end(); ia++) if(ret = ia->Check(name)) return ret;
	return NULL;
}

/*
 *	XCb`Xg쐬
 */
void CModelPlugin::ListSwitch(
	CListView *slv,		//	XCb`Xgr[
	CListView *olv,		//	IvVXgr[
	CModelInst *minst	//	NCX^X
){
	slv->DeleteAllItems();
	olv->DeleteAllItems();
	m_LinkInst = minst;
	if(!m_ModelSwitch.size()) return;
	IModelSwitch im = m_ModelSwitch.begin();
	for(; im!=m_ModelSwitch.end(); im++){
		CListElement *sle = slv->InsertItem(-1, (char *)im->m_SwitchName.c_str());
		sle->SetString(1, im->GetCurrentOptionName());
		sle->SetData((DWORD)&*im);
		im->SetListElement(sle);
	}
	slv->SetSelectionMark(m_SelectSwitchID, 0);
	slv->EnsureVisible(m_SelectSwitchID);
	m_SelectSwitch = NULL;
}

/*
 *	XCb`ҏW
 */
void CModelPlugin::EditSwitch(
	CListView *slv,	//	XCb`Xgr[
	CListView *olv	//	IvVXgr[
){
	if(!m_ModelSwitch.size()) return;
	if(m_LinkInst){
		SetSwitch(m_LinkInst);
		CNamedObjectAfterRenderer::SetCurrentInst(NULL);
	}
	CListElement *sle = slv->GetFocusItem();
	if(sle && sle->IsSelected()){
		m_SelectSwitchID = slv->GetSelectionMark();
		CModelSwitch *sw = (CModelSwitch *)sle->GetData();
		if(sw!=m_SelectSwitch){
			m_SelectSwitch = sw;
			sw->ListEntry(olv);
		}
	}else if(m_SelectSwitch){
		m_SelectSwitch = NULL;
		olv->DeleteAllItems();
	}
	if(m_SelectSwitch){
		if(m_LinkInst){
			int *pval = &m_LinkInst->m_SwitchOption[m_SelectSwitch->m_ID], before = *pval;
			int switch_id = m_SelectSwitch->m_ID<m_LinkInst->m_StaticSwitchID.size()
				? m_LinkInst->m_StaticSwitchID[m_SelectSwitch->m_ID] : -1;
			m_SelectSwitch->EditSwitch(olv, pval, switch_id);
			if(m_SelectSwitch->IsGroupCommon()){
				CTrainGroup *group = m_LinkInst->GetTrainGroup();
				if(group && before!=*pval) group->SetGroupCommonSwitch(m_SelectSwitch, *pval);
			}
		}else{
			m_SelectSwitch->EditSwitch(olv, NULL, -1);
		}
	}
}

/*
 *	XCb`ݒZbg
 */
bool CModelPlugin::SetSwitch(
	vector<int> &sopt	//	XCb`ݒl
){
	LoadAndGet();
	IModelSwitch im = m_ModelSwitch.begin();
	int i = 0;
	for(; im!=m_ModelSwitch.end() && i<sopt.size(); im++, i++) im->m_Value = sopt[i];
	for(; im!=m_ModelSwitch.end(); im++) im->m_Value = 0;
	return sopt.size()==m_ModelSwitch.size();
}

/*
 *	XCb`ݒZbg
 */
void CModelPlugin::SetSwitch(
	CModelInst *minst	//	CX^X
){
	LoadAndGet();
	CNamedObjectAfterRenderer::SetCurrentInst(minst);
	CNamedObjectAfterRenderer::SetCurrentPlugin(this);
	IModelSwitch im = m_ModelSwitch.begin();
	if(minst->m_SwitchOption.size()!=m_ModelSwitch.size()) minst->AttachPlugin(this);
	vector<int>::iterator ptr = minst->m_SwitchOption.begin();
	for(; im!=m_ModelSwitch.end(); im++, ptr++) im->m_Value = *ptr;
}

/*
 *	XCb`ݒRs[
 */
void CModelPlugin::CopySwitch(
	vector<int> &sopt	//	XCb`ݒl
){
	sopt.resize(m_ModelSwitch.size());
	vector<int>::iterator ptr = sopt.begin();
	IModelSwitch im = m_ModelSwitch.begin();
	for(; im!=m_ModelSwitch.end(); im++, ptr++) *ptr = im->m_Value;
}

/*
 *	ҐʃXCb`̃`FbN
 */
void CModelPlugin::CheckGroupCommonSwitch(
	CModelInst *minst,	//	CX^X (ύX)
	CModelSwitch *sw,	//	ΏۃXCb` (Œ葤)
	int val				//	Ώےl (Œ葤)
){
	vector<int>::iterator ptr = minst->m_SwitchOption.begin();
	IModelSwitch im = m_ModelSwitch.begin();
	for(; im!=m_ModelSwitch.end(); im++, ptr++) if(im->CheckGroupCommon(sw)) *ptr = val;
}

/*
 *	ҐʃXCb`̃`FbN
 */
void CModelPlugin::CheckGroupCommonSwitchAll(
	CModelInst *minst1,	//	CX^X (ύX)
	CModelInst *minst2	//	CX^X (Œ葤)
){
	CModelPlugin *mpi = minst2->GetModelPlugin();
	vector<int>::iterator ptr = minst2->m_SwitchOption.begin();
	IModelSwitch im = mpi->m_ModelSwitch.begin();
	for(; im!=mpi->m_ModelSwitch.end(); im++, ptr++)
		if(im->IsGroupCommon()) CheckGroupCommonSwitch(minst1, &*im, *ptr);
}

/*
 *	p[cCX^XZbg
 */
void CModelPlugin::SetPartsInst(
	CModelInst *minst	//	CX^X
){
	if(minst){
		if(minst->m_PartsInst.size()!=GetPartsNum()) minst->AttachPlugin(this);
		CNamedObject::SetPartsInst(&minst->m_PartsInst);
	}else{
		CNamedObject::SetPartsInst(NULL);
	}
}

/*
 *	Aj[VԃZbg
 */
void CModelPlugin::SetAnimation(
	CModelInst *minst	//	CX^X
){
	ITextureAnimation ia = m_Animation.begin();
	if(minst){
		if(minst->m_AnimationState.size()!=m_Animation.size()) minst->AttachPlugin(this);
		ITexAnimState itas = minst->m_AnimationState.begin();
		for(; ia!=m_Animation.end(); ia++, itas++) ia->SetState(&*itas);;
	}else{
		for(; ia!=m_Animation.end(); ia++) ia->SetState(NULL);
	}
}

/*
 *	[o[ԃZbg
 */
void CModelPlugin::SetMoverState(
	CModelInst *minst	//	CX^X
){
	IPMoverState ipms = m_MoverState.begin();
	if(minst){
		if(minst->m_MoverState.size()!=m_MoverState.size()) minst->AttachPlugin(this);
		IMoverState ims = minst->m_MoverState.begin();
		for(; ipms!=m_MoverState.end(); ipms++, ims++) *ipms = &*ims;
	}else{
		for(; ipms!=m_MoverState.end(); ipms++) *ipms = NULL;
	}
}

/*
 *	TEh̃[h
 */
void CModelPlugin::LoadSoundWave(
	CModelInst *minst	//	CX^X
){
	ChDir();
	if(minst){
		minst->m_SoundState.clear();
		minst->m_SoundState.insert(minst->m_SoundState.begin(), GetSoundNum(), CSoundState());
		ISoundEffector is = m_SoundEffector.begin();
		ISoundState iss = minst->m_SoundState.begin();
		for(; is!=m_SoundEffector.end(); is++, iss++) is->LoadData(&*iss);
	}
}

/*
 *	GtFNg`
 */
void CModelPlugin::SimulateEffect(
	CModelInst *minst	//	CX^X
){
	if(minst){
		if(minst->IsWarping()) return;
		if(g_PreSimulationFlag){
			if(minst->m_ParticleState.size()!=m_Particle.size()) minst->AttachPlugin(this);
			IParticle ip = m_Particle.begin();
			IParticleState ips = minst->m_ParticleState.begin();
			for(; ip!=m_Particle.end(); ip++, ips++) ip->Link(&*ips);
		}else{
			if(minst->m_SoundState.size()!=m_SoundEffector.size()) minst->AttachPlugin(this);
			ISoundEffector is = m_SoundEffector.begin();
			ISoundState iss = minst->m_SoundState.begin();
			for(; is!=m_SoundEffector.end(); is++, iss++) is->Link(&*iss);
		}
	}
	m_Effector.Apply(minst ? minst->GetScene() : NULL);
	if(minst){
		if(g_PreSimulationFlag){
			IParticleState ips = minst->m_ParticleState.begin();
			for(; ips!=minst->m_ParticleState.end(); ips++) ips->Confirm();
		}else{
			ISoundEffector is = m_SoundEffector.begin();
			ISoundState iss = minst->m_SoundState.begin();
			for(; is!=m_SoundEffector.end(); is++, iss++)
				iss->Confirm(&*is, IsSoundEnabled());
		}
	}
}
