#include "stdafx.h"
#include "CListView.h"
#include "CExpression.h"
#include "CModelPlugin.h"

//	OO[o
extern float g_FovRatio;

//	O[o
CModelSwitch g_SystemSwitch[SYSTEM_SWITCH_NUM];

vector<CStaticSwitchID> g_StaticSwitchTable;

/*
 *	RXgN^
 */
CModelSwitch::CModelSwitch(){
	m_ListElement = NULL;
}

/*
 *	RXgN^
 */
CModelSwitch::CModelSwitch(
	int id	//	ԍ
){
	m_ID = id;
	m_Value = 0;
	m_ListElement = NULL;
}

/*
 *	
 */
void CModelSwitch::Init(
	int id,		//	ԍ
	char *name	//	XCb`
){
	m_ID = id;
	m_SwitchName = name;
}

/*
 *	Ǎ
 */
char *CModelSwitch::Read(
	char *str,			//	Ώە
	CModelPlugin *mpi	//	fvOC
){
	char *tmp, *eee;
	if(!(str = BeginNamedBlock(eee = str, "DefineSwitch", &m_SwitchName))) return NULL;

	int i;
	for(i = 0; i<SYSTEM_SWITCH_NUM; i++) if(g_SystemSwitch[i].Check(m_SwitchName))
		throw CSynErr(eee, "%s: \"%s\"", lang(ReservedSwitchName), m_SwitchName.c_str());
	if(mpi->FindModelSwitch(m_SwitchName))
		throw CSynErr(eee, "%s: \"%s\"", lang(OverlappedSwitchName), m_SwitchName.c_str());

	if(tmp = AsgnString(str, "GroupCommon", &m_GroupCommon)) str = tmp;
	else m_GroupCommon = "";

	string entry;
	m_Entry.clear();
	while(true){
		if(tmp = AsgnString(str, "Entry", &entry)){
			str = tmp;
			m_Entry.push_back(entry);
		}else{
			break;
		}
	}

	if(!(str = EndBlock(eee = str))) throw CSynErr(eee, ERR_ENDBLOCK);
	return str;
}

/*
 *	݂̐ݒ擾
 */
char *CModelSwitch::GetCurrentOptionName(){
	int i = 0;
	Istring is = m_Entry.begin();
	for(; is!=m_Entry.end(); is++, i++) if(i==m_Value) return (char *)is->c_str();
	return "";
}

/*
 *	GgXg쐬
 */
void CModelSwitch::ListEntry(
	CListView *olv	//	Xgr[
){
	olv->DeleteAllItems();
	int i = 0;
	Istring is = m_Entry.begin();
	for(; is!=m_Entry.end(); is++, i++){
		CListElement *ole = olv->InsertItem(-1, (char *)is->c_str());
		ole->SetData(i);
	}
	olv->SetSelectionMark(m_Value, 0);
}

/*
 *	XCb`Xg쐬
 */
void CModelSwitch::EditSwitch(
	CListView *olv,	//	IvVXgr[
	int *link,		//	Nϐ
	int switch_id	//	XCb` ID
){
	if(!m_Entry.size()) return;
	CListElement *ole = olv->GetFocusItem();
	bool force_reset = false;
	if(g_NetworkInitialized && switch_id>=0){
		if(g_StaticSwitchTable[switch_id].net_sync){
			force_reset = true;
			g_StaticSwitchTable[switch_id].tmp_opt = m_Value;
			g_StaticSwitchTable[switch_id].net_sync = false;
		}else{
			link = &g_StaticSwitchTable[switch_id].tmp_opt;
		}
	}
	if(ole && ole->IsSelected() && !force_reset){
		int opt = ole->GetData();
		if(opt!=m_Value){
			m_Value = opt;
			bool async = false;
			if(link && *link!=m_Value){
				async = true;
				*link = m_Value;
			}
			m_ListElement->SetString(1, GetCurrentOptionName());
			if(switch_id>=0 && g_NetworkInitialized && async){
				//Dialog("set switch [%d] <= %d", switch_id, m_Value);
				void EnqueueSwitchControl(int, int);
				EnqueueSwitchControl(switch_id, m_Value);
			}
		}
	}else{
		olv->SetSelectionMark(m_Value, 0);
	}
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ǎ
 */
char *CSwitchEntry::Read(
	char *str,			//	Ώە
	CModelPlugin *mpi,	//	fvOC
	int condtype		//	^Cv
){
	char *tmp, *eee;
	int value;
	m_TypeFlag = 0;
	m_ConditionType = condtype;
	m_Value.clear();
	if(!m_ConditionType){
		if(!(str = Identifier2(str, "Case"))) return NULL;
		if(!(str = ConstInteger(eee = str, &value))) throw CSynErr(eee);
		m_Value.push_back(value);
		while(tmp = Character2(str, ',')){
			str = tmp;
			if(!(str = ConstInteger(eee = str, &value))) throw CSynErr(eee);
			m_Value.push_back(value);
		}
		if(!(str = Character2(eee = str, ':'))) throw CSynErr(eee);
	}
	if(!(str = Read2(eee = str, mpi))) throw CSynErr(eee);
	return str;
}

/*
 *	XCb`l`FbN
 */
bool CSwitchEntry::CheckValue(
	int value,	//	l
	bool def	//	ftHg
){
	switch(m_ConditionType){
	case 0: {
		int i, vn = m_Value.size();
		if(!vn) return true;
		for(i = 0; i<vn; i++) if(m_Value[i]==value) return true;
		return false; }
	case 1:
		return true;
	case 2:
		return !!value;
	case 3:
		return !value;
	case 4:
		return def;
	}
	return false;
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	RXgN^
 */
CSwitchApplier::CSwitchApplier(
	const CSwitchApplier *src	//	Rs[
){
	m_TypeFlag = src->m_TypeFlag;
	m_Expression = src->m_Expression->Duplicate();
}

/*
 *	fXgN^
 */
CSwitchApplier::~CSwitchApplier(){
	DELETE_V(m_Expression);
}

/*
 *	Ǎ
 */
char *CSwitchApplier::Read(
	char *str,			//	Ώە
	CModelPlugin *mpi	//	fvOC
){
	char *eee, *tmp;
	m_TypeFlag = 0;
	if(tmp = Identifier2(eee = str, "ApplySwitch")){
		str = tmp;
		g_SwitchOwner = mpi;
		if(!(str = Expression(eee = str, &m_Expression))) throw CSynErr(eee, lang(InvalidExpression));
		g_SwitchOwner = NULL;
		if(!(str = Character2(eee = str, '{'))) return NULL;
		while(true){
			if(!(tmp = Read2(eee = str, mpi, 0))) throw CSynErr(eee);
			if(tmp==str) break;
			str = tmp;
		}
		if(tmp = Identifier2(str, "Default")){
			str = tmp;
			if(!(str = Character2(eee = str, ':'))) throw CSynErr(eee);
			if(!(str = Read2(eee = str, mpi, 4))) throw CSynErr(eee);
		}
		if(!(str = EndBlock(eee = str))) throw CSynErr(eee, ERR_ENDBLOCK);
		return str;
	}else if(tmp = Identifier2(eee = str, "If")){
		str = tmp;
		g_SwitchOwner = mpi;
		if(!(str = Expression(eee = str, &m_Expression))) throw CSynErr(eee, lang(InvalidExpression));
		g_SwitchOwner = NULL;
		if(!(str = Character2(eee = str, '{'))) return NULL;
		if(!(str = Read2(eee = str, mpi, 2))) throw CSynErr(eee);
		if(!(str = EndBlock(eee = str))) throw CSynErr(eee, ERR_ENDBLOCK);
		if(tmp = BeginBlock(str, "Else")){
			str = tmp;
			if(!(str = Read2(eee = str, mpi, 3))) throw CSynErr(eee);
			if(!(str = EndBlock(eee = str))) throw CSynErr(eee, ERR_ENDBLOCK);
		}
		return str;
	}else{
		return NULL;
	}
}

/*
 *	vZ
 */
int CSwitchApplier::GetSwitchValue(){
	return m_Expression->CalcInt();
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ǎ
 */
char *CCustomizerSwitchEntry::Read2(
	char *str,			//	Ώە
	CModelPlugin *mpi	//	fvOC
){
	char *tmp;
	m_Customizer.clear();
	CCustomizerContainer cont;
	while(tmp = cont.Read(str, mpi)){
		str = tmp;
		m_Customizer.push_back(cont);
		m_TypeFlag |= cont.GetTypeFlag();
	}
	return str;
}

/*
 *	f[^Ǎ
 */
void CCustomizerSwitchEntry::LoadData(
	CModelPlugin *mpi	//	Ăяo
){
	ICustomizerContainer icc = m_Customizer.begin();
	for(; icc!=m_Customizer.end(); icc++) icc->LoadData(mpi);
}

/*
 *	펞KpXg쐬
 */
void CCustomizerSwitchEntry::SetOffList(
	CNamedObject *nobj	//	Ăяo
){
	ICustomizerContainer icc = m_Customizer.begin();
	for(; icc!=m_Customizer.end(); icc++) icc->SetOffList(nobj);
}

/*
 *	փf擾
 */
CMesh *CCustomizerSwitchEntry::GetMesh(
	float *asc	//	XP[i[
){
	if(!(m_TypeFlag&CSTM_MODELCHANGER)) return NULL;
	ICustomizerContainer icc = m_Customizer.begin();
	for(; icc!=m_Customizer.end(); icc++){
		CMesh *tm = icc->GetMesh(asc);
		if(*asc>=0.0f) return tm;
	}
	return NULL;
}

/*
 *	pKp
 */
void CCustomizerSwitchEntry::SetPosture(
	CObject *obj	//	IuWFNg
){
	if(!(m_TypeFlag&CSTM_MODELMOVER)) return;
	ICustomizerContainer icc = m_Customizer.begin();
	for(; icc!=m_Customizer.end(); icc++) icc->SetPosture(obj);
}

/*
 *	ύXqKp
 */
void CCustomizerSwitchEntry::Apply(
	CMesh *mesh	//	bV
){
	if(!(m_TypeFlag&CSTM_MISCELLANEOUS)) return;
	ICustomizerContainer icc = m_Customizer.begin();
	for(; icc!=m_Customizer.end(); icc++) icc->Apply(mesh);
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ǎ
 */
char *CCustomizerSwitchApplier::Read2(
	char *str,			//	Ώە
	CModelPlugin *mpi,	//	fvOC
	int condtype		//	^Cv
){
	char *tmp;
	CCustomizerSwitchEntry swent;
	if(tmp = swent.Read(str, mpi, condtype)){
		str = tmp;
		m_Entry.push_back(swent);
		m_TypeFlag |= swent.GetTypeFlag();
	}
	return str;
}

/*
 *	f[^Ǎ
 */
void CCustomizerSwitchApplier::LoadDataCustomizer(
	CModelPlugin *mpi	//	Ăяo
){
	ICustomizerSwitchEntry ise = m_Entry.begin();
	for(; ise!=m_Entry.end(); ise++) ise->LoadData(mpi);
}

/*
 *	펞KpXg쐬
 */
void CCustomizerSwitchApplier::SetOffListCustomizer(
	CNamedObject *nobj	//	Ăяo
){
	ICustomizerSwitchEntry ise = m_Entry.begin();
	for(; ise!=m_Entry.end(); ise++) ise->SetOffList(nobj);
}

/*
 *	փf擾
 */
CMesh *CCustomizerSwitchApplier::GetMeshCustomizer(
	float *asc	//	XP[i[
){
	if(!(m_TypeFlag&CSTM_MODELCHANGER)) return NULL;
	ICustomizerSwitchEntry ise = m_Entry.begin();
	int eval = GetSwitchValue();
	bool def = true;
	for(; ise!=m_Entry.end(); ise++){
		if(ise->CheckValue(eval, def)){
			def = false;
			CMesh *tm = ise->GetMesh(asc);
			if(*asc>=0.0f) return tm;
		}
	}
	return NULL;
}

/*
 *	pKp
 */
void CCustomizerSwitchApplier::SetPostureCustomizer(
	CObject *obj	//	IuWFNg
){
	if(!(m_TypeFlag&CSTM_MODELMOVER)) return;
	ICustomizerSwitchEntry ise = m_Entry.begin();
	int eval = GetSwitchValue();
	bool def = true;
	for(; ise!=m_Entry.end(); ise++){
		if(ise->CheckValue(eval, def)){
			def = false;
			ise->SetPosture(obj);
		}
	}
}

/*
 *	ύXqKp
 */
void CCustomizerSwitchApplier::ApplyCustomizer(
	CMesh *mesh	//	bV
){
	if(!(m_TypeFlag&CSTM_MISCELLANEOUS)) return;
	ICustomizerSwitchEntry ise = m_Entry.begin();
	int eval = GetSwitchValue();
	bool def = true;
	for(; ise!=m_Entry.end(); ise++){
		if(ise->CheckValue(eval, def)){
			def = false;
			ise->Apply(mesh);
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ǎ
 */
char *CEffectorSwitchEntry::Read2(
	char *str,			//	Ώە
	CModelPlugin *mpi	//	fvOC
){
	char *tmp;
	m_Effector.clear();
	CEffectorContainer cont;
	while(tmp = cont.Read(str, mpi)){
		str = tmp;
		m_Effector.push_back(cont);
		m_TypeFlag |= cont.GetTypeFlag();
	}
	return str;
}

/*
 *	f[^Ǎ
 */
void CEffectorSwitchEntry::LoadData(
	CModelPlugin *mpi	//	Ăяo
){
	IEffectorContainer icc = m_Effector.begin();
	for(; icc!=m_Effector.end(); icc++) icc->LoadData(mpi);
}

/*
 *	ύXqKp
 */
void CEffectorSwitchEntry::Apply(
	CScene *scene	//	V[
){
	if(!(m_TypeFlag&(g_PreSimulationFlag
		? EFCT_PARTICLEAPPLIER : EFCT_MISCELLANEOUS))) return;
	IEffectorContainer icc = m_Effector.begin();
	for(; icc!=m_Effector.end(); icc++) icc->Apply(scene);
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	Ǎ
 */
char *CEffectorSwitchApplier::Read2(
	char *str,			//	Ώە
	CModelPlugin *mpi,	//	fvOC
	int condtype		//	^Cv
){
	char *tmp;
	CEffectorSwitchEntry swent;
	if(tmp = swent.Read(str, mpi, condtype)){
		str = tmp;
		m_Entry.push_back(swent);
		m_TypeFlag |= swent.GetTypeFlag();
	}
	return str;
}

/*
 *	f[^Ǎ
 */
void CEffectorSwitchApplier::LoadDataEffector(
	CModelPlugin *mpi	//	Ăяo
){
	IEffectorSwitchEntry ise = m_Entry.begin();
	for(; ise!=m_Entry.end(); ise++) ise->LoadData(mpi);
}

/*
 *	ύXqKp
 */
void CEffectorSwitchApplier::ApplyEffector(
	CScene *scene	//	V[
){
	if(!(m_TypeFlag&(g_PreSimulationFlag
		? EFCT_PARTICLEAPPLIER : EFCT_MISCELLANEOUS))) return;
	IEffectorSwitchEntry ise = m_Entry.begin();
	int eval = GetSwitchValue();
	bool def = true;
	for(; ise!=m_Entry.end(); ise++){
		if(ise->CheckValue(eval, def)){
			def = false;
			ise->Apply(scene);
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	VXeXCb`
 */
void InitSystemSwitch(){
	g_SystemSwitch[SYS_SW_FRONT].Init(-SYS_SW_FRONT-1, "_FRONT");
	g_SystemSwitch[SYS_SW_CONNECT1].Init(-SYS_SW_CONNECT1-1, "_CONNECT1");
	g_SystemSwitch[SYS_SW_CONNECT2].Init(-SYS_SW_CONNECT2-1, "_CONNECT2");
	g_SystemSwitch[SYS_SW_DOOR1].Init(-SYS_SW_DOOR1-1, "_DOOR1");
	g_SystemSwitch[SYS_SW_DOOR2].Init(-SYS_SW_DOOR2-1, "_DOOR2");
	g_SystemSwitch[SYS_SW_SERIAL].Init(-SYS_SW_SERIAL-1, "_SERIAL");
	g_SystemSwitch[SYS_SW_CAMDIST].Init(-SYS_SW_CAMDIST-1, "_CAMDIST");
	g_SystemSwitch[SYS_SW_VELOCITY].Init(-SYS_SW_VELOCITY-1, "_VELOCITY");
	g_SystemSwitch[SYS_SW_ACCEL].Init(-SYS_SW_ACCEL-1, "_ACCEL");
	g_SystemSwitch[SYS_SW_CABINVIEW].Init(-SYS_SW_CABINVIEW-1, "_CABINVIEW");
	g_SystemSwitch[SYS_SW_APPROACH1].Init(-SYS_SW_APPROACH1-1, "_APPROACH1");
	g_SystemSwitch[SYS_SW_APPROACH2].Init(-SYS_SW_APPROACH2-1, "_APPROACH2");
	g_SystemSwitch[SYS_SW_STOPPING].Init(-SYS_SW_STOPPING-1, "_STOPPING");
	g_SystemSwitch[SYS_SW_NIGHT].Init(-SYS_SW_NIGHT-1, "_NIGHT");
	g_SystemSwitch[SYS_SW_WEATHER].Init(-SYS_SW_WEATHER-1, "_WEATHER");
	g_SystemSwitch[SYS_SW_SEASON].Init(-SYS_SW_WEATHER-1, "_SEASON");
	g_SystemSwitch[SYS_SW_SHADOW].Init(-SYS_SW_SHADOW-1, "_SHADOW");
	g_SystemSwitch[SYS_SW_ENVMAP].Init(-SYS_SW_ENVMAP-1, "_ENVMAP");
	g_SystemSwitch[SYS_SW_YEAR].Init(-SYS_SW_YEAR-1, "_YEAR");
	g_SystemSwitch[SYS_SW_MONTH].Init(-SYS_SW_MONTH-1, "_MONTH");
	g_SystemSwitch[SYS_SW_DAY].Init(-SYS_SW_DAY-1, "_DAY");
	g_SystemSwitch[SYS_SW_DAYOFWEEK].Init(-SYS_SW_DAYOFWEEK-1, "_DAYOFWEEK");
	g_SystemSwitch[SYS_SW_HOUR].Init(-SYS_SW_HOUR-1, "_HOUR");
	g_SystemSwitch[SYS_SW_MINUTE].Init(-SYS_SW_MINUTE-1, "_MINUTE");
	g_SystemSwitch[SYS_SW_SECOND].Init(-SYS_SW_SECOND-1, "_SECOND");
}

/*
 *	JXCb`ݒ
 */
void SetCamDistSwitch(
	VEC3 pos	//	_W
){
	g_SystemSwitch[SYS_SW_CAMDIST].SetValue(Round(g_FovRatio*V3Len(&(pos-GetVPos()))));
}
