#ifndef CRAILWAYPLUGINSET_H_INCLUDED
#define CRAILWAYPLUGINSET_H_INCLUDED

#include "CPlugin.h"

class CPopMenu;
class CRailPlugin;
class CTiePlugin;
class CGirderPlugin;
class CPierPlugin;
class CLinePlugin;
class CPolePlugin;

/*
 *	[֘AvOCZbg
 */
class CRailwayPluginSet: public CPlugin{
private:
	string m_RailID;				//	[ ID
	string m_TieID;					//	 ID
	string m_GirderID;				//	 ID
	string m_PierID;				//	r ID
	string m_LineID;				//	ː ID
	string m_PoleID;				//	ː ID
	bool m_RailFlag;				//	[tO
	bool m_TieFlag;					//	؃tO
	bool m_GirderFlag;				//	tO
	bool m_PierFlag;				//	rtO
	bool m_LineFlag;				//	ːtO
	bool m_PoleFlag;				//	ːtO
	CRailPlugin *m_RailPlugin;		//	[vOC
	CTiePlugin *m_TiePlugin;		//	؃vOC
	CGirderPlugin *m_GirderPlugin;	//	vOC
	CPierPlugin *m_PierPlugin;		//	rvOC
	CLinePlugin *m_LinePlugin;		//	ːvOC
	CPolePlugin *m_PolePlugin;		//	ːvOC
	bool m_EnableCant;				//	JgtO
	bool m_LiftRailSurface;			//	グtO
	bool m_MultiTrack;				//	tO
	int m_TrackNum;					//	O
	float m_TrackInterval;			//	OԊu
public:
	CRailwayPluginSet(char *, bool);
	~CRailwayPluginSet();
	char *DirName(){ return "RailwayPluginSet"; }
	char *TextName2(){ return FlashIn("%s.txt", m_Name.c_str()); }
	bool PreLoadRPS(FILE *);
	bool Load();
	void Save(FILE *);
	bool DeleteFromDisk();
	bool Rename(string &);
	bool operator<(const CRailwayPluginSet &rhs){ return m_Name<rhs.m_Name; }
	string &GetNameRef(){ return m_Name; }
	char *GetName(){ return (char *)m_Name.c_str(); }
	void Apply();
};

//	q
typedef list<CRailwayPluginSet>::iterator IRailwayPluginSet;

//	֐錾
void LoadRailwayPluginSetList();
IRailwayPluginSet FindRailwayPluginSet(string);
void AddRailwayPluginSet(string, bool);
void ListRailwayPluginSet();
void ModalFuncRailwayPluginSet();

//	OO[o
extern CPopMenu *g_RailwayPluginSetMenu;
extern list<CRailwayPluginSet> g_RailwayPluginSetList;

#endif
