#ifndef CTEXTUREANIMATION_H_INCLUDED
#define CTEXTUREANIMATION_H_INCLUDED

class CModelPlugin;
class CTextureTransformer;

/*
 *	Aj[Vt[
 */
class CTexAnimFrame{
	friend class CTextureAnimation;
private:
	int m_FrameLength;					//	t[̒
	string m_TextureFileName;			//	eNX`t@C
	LPTEX8 m_FrameTexture;				//	t[eNX`
	CTextureTransformer *m_TexTrans;	//	UV ϊ
public:
	CTexAnimFrame();
	CTexAnimFrame(const CTexAnimFrame &);
	CTexAnimFrame(string, int);
	~CTexAnimFrame();
	char *Read(char *);
	void LoadData();
	void Apply(CMesh *, int);
};

/*
 *	eNX`Aj[V
 */
class CTexAnimState{
	friend class CTextureAnimation;
private:
	int m_Frame;	//	t[
	int m_Count;	//	JEg
public:
	CTexAnimState(){ Reset(); }
	void Reset(){ m_Frame = m_Count = 0; }
	void Step(){ m_Count++; }
	char *Read(char *);
	void Save(FILE *, char *);
};

//	q
typedef list<CTexAnimState>::iterator ITexAnimState;

/*
 *	eNX`Aj[V
 */
class CTextureAnimation{
private:
	int m_CurrentFrame;					//	݂̃t[
	CTexAnimState m_PreviewState;		//	vr[pԕϐ
	string m_AnimationName;				//	Aj[V
	vector<CTexAnimFrame> m_FrameList;	//	t[Xg
public:
	char *Read(char *, CModelPlugin *);
	void LoadData();
	CTextureAnimation *Check(const string &name){
		return m_AnimationName==name ? this : NULL;
	}
	void SetState(CTexAnimState *);
	void Apply(CMesh *, int);
	LPTEX8 GetFrameTexture(){
		return m_FrameList.size() ? m_FrameList[m_CurrentFrame].m_FrameTexture : NULL;
	}
};

//	q
typedef list<CTextureAnimation>::iterator ITextureAnimation;

#endif
