#ifndef CTRAINGROUP_H_INCLUDED
#define CTRAINGROUP_H_INCLUDED

#include "CTrainSetBuffer.h"
#include "CDiaInst.h"

class CRailConnector;
class CRailLinkTemp;
class CModelInst;
class CModelSwitch;
class CTrain;
class CPlatformInst;
class CTrainPlugin;
class CListView;
class CListElement;
class CPluginTree;
class CTrainGroupTemplate;

/*
 *	ҐCX^X
 */
class CTrainGroup{
private:
	void *m_OldAdr;						//	AhX
	int m_ControlState;					//	
	int m_Serial;						//	VAio[
	int m_State;						//	
	int m_DoorWait;						//	hA҂JE^
	float m_Length;						//	
	float m_MaxVelocity;				//	ōx
	float m_MaxAcceleration;			//	ōx
	float m_MaxDeceleration;			//	ōx
	float m_DoorClosingTime;			//	hAߏv
	float m_TargetSpeed;				//	ݒ葬x
	float m_EffectTargetSpeed;			//	ݒ葬x
	float m_CurrentSpeed;				//	ݑx
	float m_OldSpeed;					//	x
	int m_SpeedLimit;					//	x
	float m_StopTarget;					//	~ڕW
	float m_PreviewOffset;				//	vr[ItZbg
	double m_DepartureTime;				//	o
	bool m_OpenDoor[2];					//	hAJ
	bool m_Reverse;						//	ރ[h
	bool m_Enabled;						//	zutO
	bool m_NotifyFlag;					//	vbgtH[ʒmtO
	int m_SplitPos;						//	\ʒu
	VEC3 m_CabinPos[2];					//	^]ȈʒuItZbg
	VEC3 m_CabinDir[2];					//	^]Ȏ_
	string m_Name;						//	Ґ
	CListElement *m_ListElement;		//	Xgvf
	list<CTrainSetBuffer> m_SetBuffer;	//	zuobt@
	CGroupEndLocator m_Location[2];		//	I[ʒu
	CGroupEndLocator m_Seeker;			//	oHTq
	set<CRailConnector *> m_PointList;	//	ʉߒ|CgXg
	set<CRailConnector *> m_SeekList;	//	T|CgXg
	set<CRailConnector *> m_OldSeek;	//	T|CgXg
	CDiaElement m_DiaElement;			//	_Cvf
	CPlatformInst *m_Platform;			//	vbgtH[
	CTrain *m_TrainList;				//	qXg
	CTrain *m_SelectTrain;				//	I𒆎q
	CTrainGroup *m_Next;				//	
public:
	CTrainGroup(char *);
	~CTrainGroup();
	CTrainGroup *Next(){ return m_Next; }
	CTrainGroup **NextAdr(){ return &m_Next; }
	void *OldAdr(){ return m_OldAdr; }
	char *GetName(){ return (char *)m_Name.c_str(); }
	void SetName(char *name){ m_Name = name; }
	void SetListElement(CListElement *le){ m_ListElement = le; }
	CListElement *GetListElement(){ return m_ListElement; }
	CTrain *GetSelectedTrain(){ return m_SelectTrain; }
	void MakeTemplate(CTrainGroupTemplate *);
	bool IsSet(){ return m_Enabled; }
	int GetSerial(){ return m_Serial; }
	void SetSerial(int s){ m_Serial = s; }
	int GetTrainNum();
	void OnTrainNumChanged();
	vector<CTrain *> GetTrainByVector();
	void SetTrainByVector(vector<CTrain *>);
	int GetState(){ return m_State; }
	bool IsReverse(){ return m_Reverse; }
	void CalcSpec();
	void CheckTargetSpeed();
	void PrintInfo();
	CModelInst *Control(CTrain *);
	float GetTargetSpeed(){ return m_TargetSpeed; }
	void SetTargetSpeed(float ts){ m_TargetSpeed = ts; }
	float GetEffectTargetSpeed(){ return m_EffectTargetSpeed; }
	void SetEffectTargetSpeed(float ets){ m_EffectTargetSpeed = ets; }
	void SetSpeedLimit(int);
	float CalcSignedSpeedLimit();
	bool CalcViewAxis(CObject *);
	void SetCabinView();
	void AddTrain(CTrainPlugin *, bool);
	void DeleteTrain(CTrain *);
	void ListTrain(CListView *);
	CTrain *EditTrain(CListView *, CPluginTree *);
	void SetGroupCommonSwitch(CModelSwitch *, int);
	void Remove();
	void SetSetBuffer();
	void SetError(const char *);
	bool Set(CRailLinkTemp *, int);
	bool Trail(bool, bool);
	void NotifyWarp();
	void NotifyPlatform(CPlatformInst *, float, bool);
	void DeletePlatform(CPlatformInst *pf){ if(m_Platform==pf) m_Platform = NULL; }
	void ClearPoint();
	void ClearSeek();
	void AddPoint(CRailConnector *pcon){ m_PointList.insert(pcon); }
	bool AddSeek(CRailConnector *);
	void SetConnectSwitch(CTrain *);
	void ScanInput(int, VEC3 &, VEC3 &);
	void Preview();
	void Render();
	void Simulate();
	void MergeTrain(CTrainGroup *, int, int);
	void SplitTrain(int);
	void RestoreSet();
	void RestoreAddress();
	char *Read(char *, CTrainGroup ***);
	void Save(FILE *);
};

//	OO[o
extern CTrainGroup *g_TrainGroup;

CTrainGroup *GetTrainGroupBySerial(int);

#endif
