#ifndef CTRAINSETBUFFER_H_INCLUDED
#define CTRAINSETBUFFER_H_INCLUDED

class CRailWay;
class CAxleObject;

/*
 *	Ԏpobt@
 */
class CAxlePosture{
	friend class CTrain;
	friend class CTrainGroup;
private:
	float m_Rotation;		//	]
	float m_Distance;		//	s
	bool m_Terminate;		//	[tO
	VEC3 m_Pos;				//	W
	VEC3 m_Right;			//	right
	VEC3 m_Up;				//	up
	VEC3 m_Dir;				//	dir
	CRailWay *m_Rail;		//	[
	CAxleObject *m_Axle;	//	Ԏ
	CTrain *m_Train;		//	q
public:
	CAxlePosture(CAxleObject *, CTrain *, bool);
	void SetPosture(VEC3, VEC3, VEC3, CRailWay *);
	float GetZPos();
	void Apply();
	void Rotate(float, bool);
};

//	q
typedef list<CAxlePosture>::iterator IAxlePosture;

/*
 *	qzuobt@
 */
class CTrainSetBuffer{
	friend class CRailWay;
	friend class CTrainSetCurve;
	friend class CTrainGroup;
private:
	float m_SumLen;				//	ώZ
	bool m_Reverse;				//	]tO
	CAxlePosture *m_Posture;	//	pobt@
public:
	CTrainSetBuffer(float, bool, CAxlePosture *);
	bool operator<(const CTrainSetBuffer &rhs) const{ return m_SumLen<rhs.m_SumLen; }
	void SetPosture(VEC3 pos, VEC3 dir, VEC3 up, CRailWay *way){
		if(m_Posture) m_Posture->SetPosture(pos, m_Reverse ? -dir : dir, up, way);
	}
	void Rotate(float dist){
		if(m_Posture) m_Posture->Rotate(dist, m_Reverse);
	}
};

//	q
typedef list<CTrainSetBuffer>::iterator ITrainSetBuffer;

/*
 *	ҐI[
 */
class CGroupEndLocator{
public:
	int m_Side;				//	TCh
	int m_Type;				//	^Cv (0: front, 1: tail, 2: seeker)
	float m_Offset;			//	ItZbg
	CRailWay *m_SetRail;	//	ݒu[
	CTrainGroup *m_Group;	//	Ґ
public:
	CGroupEndLocator();
	CGroupEndLocator(int, float, CRailWay *, CTrainGroup *);
	void Attach(int);
	void Detach();
	int GetDirection();
	void RestoreAddress();
	char *Read(char *, char *);
	void Save(FILE *, char *, char *);
};

//	q
typedef list<CGroupEndLocator *>::iterator IPGroupEndLocator;

#endif
