#include "stdafx.h"
#include "CEditCtrl.h"
#include "CSkinPlugin.h"
#include "CInterfaceMode.h"

//	O[o
float g_SkinFileIconRect[4] = {0.875f, 0.75f, 0.125f, 0.125f};	//	t@CACR̈

/*
 *	RXgN^
 */
CTreeFileElement::CTreeFileElement(
	char *str,			//	
	CTreeDirElement *p,	//	e
	CPluginTree *ctrl,	//	c[Rg[
	CPlugin *pi			//	vOC
):
	CTreeElement(str, p, ctrl)	//	{NX
{
	m_CommandType = CMD_PITVELEM;
	m_Plugin = pi;
}

/*
 *	l[\
 */
bool CTreeFileElement::IsRenamable(){
	return m_Plugin && m_Plugin->IsRenamable();
}

/*
 *	l[mF
 */
bool CTreeFileElement::ConfirmRename(
	string &newname	//	VK
){
	return m_Plugin && m_Plugin->ConfirmRename(newname);
}

/*
 *	f[g\
 */
bool CTreeFileElement::IsDeletable(){
	return m_Plugin && m_Plugin->IsDeletable();
}

/*
 *	Xgr[ɗvfǉ
 */
void CTreeFileElement::PushListElement(
	CPluginListView *lv	//	Xgr[
){
	int index = lv->GetItemNum();
	LPTEX8 icon = m_Plugin->GetIconTexture();
	CListElement *le = lv->InsertItem(index, (char *)m_Plugin->m_Name.c_str(),
		icon, icon ? m_Plugin->GetIconRect() : g_SkinFileIconRect);
	le->SetData((DWORD)this);
	le->SetString(1, (char *)m_Plugin->m_ID.c_str());
	le->SetString(2, (char *)m_Plugin->m_Author.c_str());
}

/*
 *	ۑ
 */
void CTreeFileElement::Save(
	FILE *file,		//	t@C
	string indent	//	Cfg
){
	fprintf(file, "%sFile = %s, \"%s\";\n",
		indent.c_str(), m_Plugin->DirName(), m_Plugin->SaveString());
}

/*
 *	ACeJEg
 */
int CTreeFileElement::CountItem(
	int sum,	//	܂ł̍v
	int *fcp,	//	tH[JXACëʒu
	bool exflag	//	WJĂ̂̂
){
	if(fcp && m_Owner->GetFocusItem()==this) *fcp = sum;
	return 1;
}

/*
 *	̓`FbN
 */
int CTreeFileElement::ScanInput(
	int x, int y,	//	W
	int cnt,		//	\JEg
	int begin,		//	Jnʒu
	int end			//	Iʒu
){
	if(m_Owner->GetFocusItem()==this) ms_FocusNext = this;
	else if(!ms_FocusNext) ms_FocusPrev = this;
	else if(ms_FocusNext==m_Owner->GetFocusItem()) ms_FocusNext = this;
	POINT pos = g_Cursor.GetPos();
	if(m_EditBox && !IsInsideItem(x, y, pos.x, pos.y)
		&& GetButton(DIM_LEFT)==S_PUSH) EndRename(true);
	if(m_EditBox){
		switch(m_EditBox->ScanInput()){
		case EDIT_OK:
			EndRename(true);
			break;
		case EDIT_CANCEL:
			EndRename(false);
			break;
		}
	}
	if(cnt<begin || end<=cnt) return 1;
	if(m_RenameWait && GetFrameCount()-m_ClickTime==DBLCLK_FRAME && m_Parent
		&& m_Owner->IsFocus() && m_Owner->GetFocusItem()==this){
		m_ClickTime = 0;
		BeginRename();
	}else if(IsInsideItem(x, y, pos.x, pos.y)){
		switch(GetButton(DIM_LEFT)){
		case S_PUSH:
			m_RenameWait = false;
			if(m_Owner->IsFocus() && m_Owner->GetFocusItem()==this){
				if(m_EditBox){
					EndRename(true);
					m_State = 2;
				}else{
					m_State = 3;
				}
			}else{
				m_State = 2;
			}
			m_Owner->SetFocusItem(this);
			m_Owner->GiveFocus();
			m_Owner->m_PushedItem = this;
			m_DownPos = pos;
			break;
		case S_HOLD:
			if(CDragContainer::GetType()==DRAG_PLUGIN) m_Owner->SetDropItem(
				m_Owner->GetFocusItem()!=m_Parent ? m_Parent : NULL);
			if(m_Parent && m_State && Manhattan(pos, m_DownPos)>DRAG_THD
				&& !CDragContainer::IsDragging()) PrepareDrag();
			break;
		default:
			if(CDragContainer::GetType()==DRAG_PLUGIN
				&& (!m_Owner->IsFocus() || m_Owner->GetFocusItem()!=m_Parent)){
				m_Parent->Drop();
				return true;
			}
			switch(m_State){
			case 2:
				m_ClickTime = GetFrameCount();
				break;
			case 3:
				if(GetFrameCount()-m_ClickTime<DBLCLK_FRAME){
					m_ClickTime = 0;
					m_Owner->m_Commander->DoubleClick(m_CommandType, (DWORD)GetPlugin());
					g_Skin->MouseUp();
				}else{
					m_RenameWait = true;
					m_ClickTime = GetFrameCount();
				}
				break;
			}
			m_State = 0;
			break;
		}
		if(m_Owner->m_Commander && GetButton(DIM_RIGHT)==S_PUSH){
			CPopMenu *pop = m_Owner->m_Commander->Dispatch(m_CommandType, (DWORD)GetPlugin());
			if(pop){
				m_Owner->SetFocusItem(this);
				m_Owner->GiveFocus(false);
				pop->Popup(pos.x, pos.y);
			}
		}
	}else if(m_State){
		switch(GetButton(DIM_LEFT)){
		case S_HOLD:
			if(m_Parent && Manhattan(pos, m_DownPos)>DRAG_THD
				&& !CDragContainer::IsDragging()) PrepareDrag();
			break;
		default:
			m_State = 0;
			break;
		}
	}
	return 1;
}

/*
 *	_O
 */
int CTreeFileElement::Render(
	int x, int y,	//	W
	int cnt,		//	\JEg
	int begin,		//	Jnʒu
	int end			//	Iʒu
){
	if(m_EditBox && (!m_Owner->IsFocus() || m_Owner->GetFocusItem()!=this))
		EndRename(true);
	if(cnt<begin) return 1;
	CStringDrawer *sd = g_StrTex->DrawString(m_String.c_str(), 0);
	D3DCOLOR *bc = m_Owner->GetFocusItem()==this
		? g_Skin->m_PluginTreeData.m_SelectedBaseColor
		: g_Skin->m_PluginTreeData.m_DefaultBaseColor;
	if(m_Width<0) m_Width = sd->GetWidth();
	if(*bc){
		devSetTexture(0, NULL);
		Grad2DRect(x+TILE_UNIT+TREE_ICON_OFS, y, x+TILE_UNIT+TREE_ICON_OFS
			+TREE_ICON_MARGIN*2+m_Width, y+TILE_UNIT, bc);
	}
	if(m_Owner->IsFocus() && m_Owner->GetFocusItem()==this)
		Draw2DRect(x+TILE_UNIT+TREE_ICON_OFS, y, x+TILE_UNIT+TREE_ICON_OFS
			+TREE_ICON_MARGIN*2+m_Width, y+TILE_UNIT,
			g_Skin->m_PluginTreeData.m_FocusFrameColor);
	m_Plugin->SetIconTexture();
	TexMap2DRect(x, y, x+TILE_UNIT, y+TILE_UNIT, 0xffffffff);
	if(m_EditBox){
		m_EditBox->SetPos(
			x+TILE_UNIT+TREE_ICON_OFS+EB_OFSX, y+FontY(TILE_UNIT));
		m_EditBox->Render();
	}else{
		sd->RenderLeft(x+TILE_UNIT
			+TREE_ICON_OFS+TREE_ICON_MARGIN, y+FontY(TILE_UNIT),
			g_Skin->m_PluginTreeData.m_DefaultFontColor);
	}
	return 1;
}
