//	Copyright (c) 2002 Midikyou

#include "headers.h"
#include "debug.h"
#include "window.h"
#include "sound.h"
#include "wave.h"

/*
 *	RXgN^
 *
 *	vOI܂łFree()܂delete(newŊmۂꍇ)ĉB
 */
CWave::CWave(){
	m_pSB = NULL;
	m_p3D = NULL;
	m_pFX = NULL;
}

/*
 *	fXgN^
 */
CWave::~CWave(){
	Free();
}

/*
 *	f[^̓Ǎ
 *
 *	strFile	: t@C
 */
BOOL CWave::Load(char *strFile){
	//	Ȃ
	if(m_pSB) Free();

	Debug("load(%s) ... ", strFile);
	char full[_MAX_PATH];
	_fullpath(full, strFile, _MAX_PATH);
	m_strName = full;

	HMMIO			hMMI;
	MMCKINFO		parent, child;
	WAVEFORMATEX	wfmtx;
	DWORD			len;
	BOOL			ret = FALSE;

	parent.ckid = (FOURCC)0;
	parent.cksize = 0;
	parent.fccType = (FOURCC)0;
	parent.dwDataOffset = 0;
	parent.dwFlags = 0;
	child = parent;

	//	I[v
	hMMI = mmioOpen(strFile, NULL, MMIO_READ|MMIO_ALLOCBUF);

	if(!hMMI){
		Debug("open error.\n");
		return FALSE;
	}
	//	RIFF`N̓ǂݍ݁`FbN
	parent.fccType = mmioFOURCC('W', 'A', 'V', 'E');

	if(mmioDescend(hMMI, &parent, NULL, MMIO_FINDRIFF)!=0){
		Debug("RIFF is not found.\n"); goto error;
	}
	//	fmt`N̓ǂݍ݁`FbN
	child.ckid = mmioFOURCC('f', 'm', 't', ' ');

	if(mmioDescend(hMMI, &child, &parent, 0)!=0){
		Debug("fmt is not found.\n"); goto error;
	}
	//	tH[}bg̎擾
	mmioRead(hMMI, (char *)&wfmtx, sizeof(wfmtx));
	m_BytesPerSec = wfmtx.nAvgBytesPerSec;

	//	PCMtH[}bgH
	if(wfmtx.wFormatTag!=WAVE_FORMAT_PCM){
		Debug("is not PCM format.\n"); goto error;
	}

	if(mmioAscend(hMMI, &child, 0)!=0){
		Debug("ascend error.\n"); goto error;
	}
	//	data`N̓ǂݍ݁`FbN
	child.ckid = mmioFOURCC('d', 'a', 't', 'a');

	if(mmioDescend(hMMI, &child, &parent, MMIO_FINDCHUNK)!=0){
		Debug("chunk is not found.\n"); goto error;
	}
	//	data`N擾
	len = child.cksize;

	//	obt@쐬A[h
	if(!CreateBuffer(hMMI, &wfmtx, len)) goto error;

	//	N[Y
	mmioClose(hMMI, 0);
	Debug("ok.\n");
	return TRUE;

error:
	mmioClose(hMMI, 0);
	return FALSE;
}

/*
 *	ʂCWaveIuWFNgf[^𕡐
 *
 *	pWav	: Rs[̃IuWFNg
 */
BOOL CWave::Duplicate(CWave *pWav){
	if(!svs.pDS || m_pSB) Free();

	int err;
	//	obt@̕
	if(FAILED(err = svs.pDS->DuplicateSoundBuffer(pWav->m_pSB, &m_pSB))) return FALSE;

	return Query();
}

/*
 *	TEhobt@̍쐬
 *
 *	hMMMI	: t@Cnh
 *	pFmt	: EG[utH[}bg
 *	len	: EG[uTCY
 */
BOOL CWave::CreateBuffer(HMMIO hMMI, LPWAVEFORMATEX pFmt, DWORD len){
	if(!svs.pDS) return FALSE;
	//	obt@̍쐬
	DSBUFFERDESC desc;

	memset(&desc, 0, sizeof(DSBUFFERDESC));
	desc.dwSize = sizeof(DSBUFFERDESC);
	desc.dwFlags = DSBCAPS_CTRLVOLUME;
	desc.dwBufferBytes = len;
	desc.lpwfxFormat = pFmt;

	if(svs.f3D) desc.dwFlags |= DSBCAPS_CTRL3D;
//	if(svs.fFX) desc.dwFlags |= DSBCAPS_CTRLFX;

	HRESULT hr = svs.pDS->CreateSoundBuffer(&desc, &m_pSB, NULL);

	if(FAILED(hr)){
		if(hr==DSERR_BUFFERTOOSMALL){
			//	f[^ZăGtFNggpłȂ
			Debug("data is too small.\n");
			return TRUE;
		}else if(hr = DSERR_OUTOFMEMORY){
			//	siTEhJ[h́Hj
			Debug("out of memory.\n");
			return FALSE;
		}else{
			Debug("can't create buffer.\n");
			return FALSE;
		}
	}
	//	obt@̃bN
	LPVOID write1, write2;
	DWORD length1, length2;

	if(m_pSB->Lock(0, len, &write1, &length1, &write2, &length2, 0)==DSERR_BUFFERLOST){
		m_pSB->Restore(); return FALSE;
	}
	//	data`Nobt@Ƀ[h
	if((DWORD)mmioRead(hMMI, (char *)write1, length1)==length1){
		if(length2!=0) mmioRead(hMMI, (char *)write2, length2);
	}
	//	obt@̃AbN
	if(m_pSB->Unlock(write1, length1, write2, length2)!=DS_OK)
		return FALSE;

	return Query();
}

/*
 *	C^[tFCX̎擾
 */
BOOL CWave::Query(){
	//	FXobt@̎擾
	if(svs.fFX){
		if(FAILED(m_pSB->QueryInterface(IID_IDirectSoundBuffer8, (void **)&m_pFX))){
			Debug("DirectSoundBuffer8\n");
			return FALSE;
		}
	}
	//	3Dobt@̎擾
	if(svs.f3D){
		if(FAILED(m_pSB->QueryInterface(IID_IDirectSound3DBuffer, (void **)&m_p3D))){
			Debug("DirectSound3DBuffer\n");
			return FALSE;
		}
	}
	return TRUE;
}

/*
 *	obt@̉
 */
void CWave::Free(){
	if(m_strName!=""){
		Debug("release(%s)\n", m_strName.c_str());
		m_strName = "";
	}
	Stop();
	RELEASE(m_p3D);
	RELEASE(m_pFX);
	RELEASE(m_pSB);
}

/*
 *	Đ
 *
 *	ms	: ĐJnʒu [ms] (<0 Ń[v)
 */
void CWave::Play(int ms){
	if(!m_pSB) return;

	m_pSB->Stop();
	m_pSB->SetCurrentPosition(ms<0 ? 0 : m_BytesPerSec*ms/1000);
	HRESULT hr = m_pSB->Play(0, 0, ms<0 ? DSBPLAY_LOOPING : 0);
	//	[h
	if(hr==DSERR_BUFFERLOST){
		Debug("DSERR_BUFFERLOST:%s", m_strName.c_str());

		PrimaryBufferVerify();	//	ɃvC}obt@؂
		m_pSB->Restore();	//	ǂ̓Free()邪Ô
		Load((char *)m_strName.c_str());
	}
}

/*
 *	ĐԂ̎擾
 */
BOOL CWave::GetStatus(){
	if(!m_pSB) return FALSE;

	DWORD dw;
	m_pSB->GetStatus(&dw);

	if(dw&DSBSTATUS_PLAYING) return TRUE;
	else return FALSE;
}

/*
 *	GtFNg̐ݒ
 *
 *	fx	: GtFNg^CviFX_`j
 *
 *	16bitȊOWAVEt@C̓GtFNgɂȂꍇB
 */
void CWave::SetFX(int fx){
	if(!svs.fFX || !m_pFX) return;

	//	GtFNg̃Zbg
	if(fx==FX_DRY){
		m_pFX->SetFX(0, NULL, NULL);
		return;
	}

	DSEFFECTDESC desc;
	DWORD rc = 0;

	memset(&desc, 0, sizeof(desc));
	desc.dwSize = sizeof(desc);
	desc.dwFlags = 0;

	switch(fx){
	case FX_REVERB		: desc.guidDSFXClass = GUID_DSFX_WAVES_REVERB;			break;
	case FX_REVERB3D	: desc.guidDSFXClass = GUID_DSFX_STANDARD_I3DL2REVERB;	break;
	case FX_ECHO		: desc.guidDSFXClass = GUID_DSFX_STANDARD_ECHO;			break;
	case FX_CHORUS		: desc.guidDSFXClass = GUID_DSFX_STANDARD_CHORUS;		break;
	case FX_FLANGER		: desc.guidDSFXClass = GUID_DSFX_STANDARD_FLANGER;		break;
	case FX_GARGLE		: desc.guidDSFXClass = GUID_DSFX_STANDARD_GARGLE;		break;
	case FX_COMP		: desc.guidDSFXClass = GUID_DSFX_STANDARD_COMPRESSOR;	break;
	case FX_PARAMEQ		: desc.guidDSFXClass = GUID_DSFX_STANDARD_PARAMEQ;		break;
	case FX_DISTORTION	: desc.guidDSFXClass = GUID_DSFX_STANDARD_DISTORTION;	break;
	default				: SetFX(FX_DRY); return;
	}
	m_pFX->SetFX(1, &desc, &rc);
}
