#ifndef CCUSTOMIZERMOVER_H_INCLUDED
#define CCUSTOMIZERMOVER_H_INCLUDED

#include "CCustomizer.h"

/*
 *	ړq{NX
 */
class CMoverBase: public CCustomizerBase{
private:
	CMoverState **m_State;		//	ԕϐ
	CMoverState m_PreviewState;	//	vr[pԕϐ
public:
	CMoverBase(){ m_State = NULL; }
	virtual CCustomizerBase *Duplicate() = 0;
	virtual void SetOffListCustomizer(CNamedObject *){}
	virtual void ResetOffCustomizer(int){}
	int GetTypeFlagCustomizer(){ return CSTM_MODELMOVER; }
	virtual void SetPostureCustomizer(CObject *) = 0;
	void InitMover(CModelPlugin *);
	CMoverState *GetState(){ return *m_State ? *m_State : &m_PreviewState; }
};

/*
 *	ړq{NX
 */
class CDynamicMoverBase: public CMoverBase{
protected:
	int m_ApplyFlag;	//	KptO
public:
	virtual CCustomizerBase *Duplicate() = 0;
	virtual void SetOffListCustomizer(CNamedObject *);
	void ResetOffCustomizer(int);
	virtual void SetPostureCustomizer(CObject *) = 0;
};

/*
 *	ÓIړq{NX
 */
class CStaticMoverBase: public CDynamicMoverBase{
protected:
	float m_AnimationTime[6];	//	Aj[V
public:
	virtual CCustomizerBase *Duplicate() = 0;
	char *ReadTimingInfo(char *);
	virtual void SetPostureCustomizer(CObject *) = 0;
	float ProcDelay();
};

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	ÓI]q
 */
class CStaticRotator: public CStaticMoverBase{
private:
	float m_RotationAngle;	//	]px
	VEC3 m_RotationAxis;	//	]
public:
	CCustomizerBase *Duplicate(){ return new CStaticRotator(*this); }
	char *Read(char *, CModelPlugin *);
	void SetPostureCustomizer(CObject *);
};

/*
 *	ÓIړq
 */
class CStaticMover: public CStaticMoverBase{
private:
	VEC3 m_Displacement;	//	ψ
public:
	CCustomizerBase *Duplicate(){ return new CStaticMover(*this); }
	char *Read(char *, CModelPlugin *);
	void SetPostureCustomizer(CObject *);
};

/*
 *	I]q
 */
class CDynamicRotator: public CDynamicMoverBase{
private:
	float m_RotationSpeed;	//	]px
	float m_Acceleration;	//	x
	float m_Deceleration;	//	x
	VEC3 m_RotationAxis;	//	]
public:
	CCustomizerBase *Duplicate(){ return new CDynamicRotator(*this); }
	char *Read(char *, CModelPlugin *);
	void SetPostureCustomizer(CObject *);
};

/*
 *	gbJ
 */
class CWindTracker: public CMoverBase{
private:
	float m_TrackSpeed;		//	ǐՑx
	bool m_FixAxisFlag;		//	ŒtO
	VEC3 m_FixAxis;			//	Œ莲
public:
	CCustomizerBase *Duplicate(){ return new CWindTracker(*this); }
	char *Read(char *, CModelPlugin *);
	void SetPostureCustomizer(CObject *);
};

/*
 *	
 */
class CWindmill: public CMoverBase{
private:
	int m_Symmetric;		//	Ώ̃JEg
	float m_RotationSpeed;	//	]x
	float m_MaxRotation;	//	t[]ʍől
	bool m_Directional;		//	
	VEC3 m_RotationAxis;	//	]
public:
	CCustomizerBase *Duplicate(){ return new CWindmill(*this); }
	char *Read(char *, CModelPlugin *);
	void SetPostureCustomizer(CObject *);
};

/*
 *	AiOv
 */
class CAnalogClock: public CCustomizerBase{
private:
	int m_HandType;			//	j^Cv
public:
	CCustomizerBase *Duplicate(){ return new CAnalogClock(*this); }
	char *Read(char *);
	int GetTypeFlagCustomizer(){ return CSTM_MODELMOVER; }
	void SetPostureCustomizer(CObject *);
};

#endif
