#ifndef CRAILDETECTCURVE_H_INCLUDED
#define CRAILDETECTCURVE_H_INCLUDED

#include "CRailWay.h"
#include "CRailTraceCurve.h"

/*
 *	[oJ[u (2D)
 */
class CRailDetectCurve2D: public CRailTraceCurve{
private:
	static float ms_MinDist;		//	ŏo
	static CRailLinkTemp ms_Detect;	//	o
	int m_DetectMode;				//	o[h
	VEC3 m_CursorPos1;				//	J[\W 1
	VEC3 m_CursorPos2;				//	J[\W 2
public:
	static void ResetDetect(){ ms_MinDist = -1.0f; }
	static bool RenderLink();
	static bool IsDetected(){ return ms_MinDist>=0.0f; }
	static CRailLinkTemp &GetDetect(){ return ms_Detect; }
	CRailDetectCurve2D(CRailWay *,
		CRailPlugin *, CTiePlugin *, CGirderPlugin *, int ,VEC3 &, VEC3 &);
	void FinishTrace(
		VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &,
		float, float, CRailSplitter &);
};

/*
 *	[oJ[u (3D)
 */
class CRailDetectCurve3D: public CRailTraceCurve{
private:
	static float ms_MinDist;		//	ŏo
	static CRailLinkTemp ms_Detect;	//	o
	VEC3 m_ArrowPos;				//	W
public:
	static void ResetDetect(){ ms_MinDist = -1.0f; }
	static bool RenderLink();
	static bool IsDetected(){ return ms_MinDist>=0.0f; }
	static CRailLinkTemp &GetDetect(){ return ms_Detect; }
	CRailDetectCurve3D(CRailWay *, CRailPlugin *, CTiePlugin *, CGirderPlugin *, VEC3 &);
	void FinishTrace(
		VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &,
		float, float, CRailSplitter &);
};

#endif
