#ifndef CRAILPLANCURVE_H_INCLUDED
#define CRAILPLANCURVE_H_INCLUDED

#include "CRailLink.h"
#include "CRailCurve.h"

class CRailPlugin;
class CTiePlugin;
class CGirderPlugin;

/*
 *	[vJ[u
 */
class CRailPlanCurve: public CRailCurve{
private:
	static float ms_RadiusDrawPos;	//	a\ʒu
	CLineDumpL *m_Dump;	//	_p
public:
	static void SetRadiusDrawPos(float p){ ms_RadiusDrawPos = p; }
	CRailPlanCurve(CLineDumpL *dump){ m_Dump = dump; }
	void Curve(VEC3 &, VEC3 &, VEC3 &, VEC3 &, bool, bool);
};

/*
 *	[ݒuJ[u
 */
class CRailBuildCurve: public CRailCurve{
private:
	CRailConnectorLink m_BeginLink;	//	JnN
	CRailConnectorLink m_EndLink;	//	IN
	CRailPlugin *m_RailPlugin;		//	[vOC
	CTiePlugin *m_TiePlugin;		//	؃vOC
	CGirderPlugin *m_GirderPlugin;	//	vOC
public:
	CRailBuildCurve(CRailConnectorLink &, CRailConnectorLink &,
		CRailPlugin *, CTiePlugin *, CGirderPlugin *);
	CRailConnectorLink &GetNext(){ return m_BeginLink; }
	void Curve(VEC3 &, VEC3 &, VEC3 &, VEC3 &, bool, bool);
};

#endif
