#ifndef CRAILTRACECURVE_H_INCLUDED
#define CRAILTRACECURVE_H_INCLUDED

#include "CRailCurve.h"
#include "CRailLink.h"

class CRailPlugin;
class CTiePlugin;
class CGirderPlugin;
class CRailWay;

/*
 *	[g[XJ[u
 */
class CRailTraceCurve{
protected:
	static bool ms_Terminate1, ms_Terminate2;	//	I[tO
	static IRailSplitter ms_SpliceItr;			//	splice ʒu
	CRailWay *m_RailWay;			//	ƃ[
	CRailPlugin *m_RailPlugin;		//	[vOC
	CTiePlugin *m_TiePlugin;		//	؃vOC
	CGirderPlugin *m_GirderPlugin;	//	vOC
public:
	static void SetTerminate(bool t1, bool t2){ ms_Terminate1 = t1; ms_Terminate2 = t2; }
	static void SetSplitItr(IRailSplitter sit){ ms_SpliceItr = sit; }
	static void SetSplitItr(list<CRailSplitter>::reverse_iterator){}
	CRailTraceCurve::CRailTraceCurve(
		CRailPlugin *rpi, CTiePlugin *tpi, CGirderPlugin *gpi, CRailWay *way){
		m_RailPlugin = rpi; m_TiePlugin = tpi; m_GirderPlugin = gpi; m_RailWay = way;
	}
	virtual bool Confirm(VEC3 &, VEC3 &){ return true; }
	virtual void FinishTrace(
		VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &, VEC3 &,
		float, float, CRailSplitter &) = 0;
};

#endif
