#ifndef CRAILWAY_H_INCLUDED
#define CRAILWAY_H_INCLUDED

#include "CLine.h"
#include "CTrainSetBuffer.h"
#include "CRailLink.h"

class CRailTraceCurve;
class CRailLinkTemp;
class CPier;
class CPlatformInst;
class CScene;
class CRailPlugin;
class CTiePlugin;
class CGirderPlugin;
class CPierPlugin;
class CLinePlugin;
class CPolePlugin;
class CDetectInfo;
class CRailWayParentLink;

/*
 *	rʒuf[^
 */
class CPierPos{
public:
	float m_Pos;	//	ʒu
	CPier *m_Link;	//	ː
public:
	CPierPos(){ m_Pos = 0.0f; m_Link = NULL; }
	CPierPos(float p, CPier *l){ m_Pos = p; m_Link = l; }
	bool operator<(const CPierPos &rhs){ return m_Pos<rhs.m_Pos; }
	void RestoreAddress();
	char *Read(char *);
	void Save(FILE *);
};

//	q
typedef list<CPierPos>::iterator IPierPos;

/*
 *	ːʒuf[^
 */
class CPolePos{
public:
	float m_Pos;	//	ʒu
	int m_Track;	//	Oԍ
	bool m_Multi;	//	pN
	CPole *m_Link;	//	ː
public:
	CPolePos(){ m_Pos = 0.0f; m_Link = NULL; }
	CPolePos(float p, CPole *l, int t, bool m){
		m_Pos = p; m_Link = l; m_Track = t; m_Multi = m;
	}
	bool operator<(const CPolePos &rhs){ return m_Pos<rhs.m_Pos; }
	void RestoreAddress();
	char *Read(char *);
	void Save(FILE *);
};

//	q
typedef list<CPolePos>::iterator IPolePos;

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	[CX^X
 */
class CRailWay{
	friend class CRailWayLink;
	friend class CGroupEndLocator;
	friend class CRailBuildMode;
private:
	static CRailWay **ms_Root;				//	ڑ[g
	static float ms_MinDist;				//	ŏo
	static CRailWayLink ms_Detect;			//	o
	void *m_OldAdr;							//	AhX
	int m_Selected;							//	ItO
	vector<float> m_RailMapV;				//	[}bsO V W
	vector<float> m_TieMapV;				//	؃}bsO V W
	vector<float> m_GirderMapV;				//	}bsO V W
	vector<float> m_LineMapV;				//	ː}bsO V W
	float m_PierPos;						//	rݒuʒu
	float m_PolePos;						//	ːʒu
	float m_SegLen;							//	ZOg
	bool m_BuildLine;						//	ːݒutO
	bool m_WarpDummy;						//	[vp_~[[
	bool m_MultiTrackDummy;					//	p_~[[
	int m_DummyTrackNum;					//	_~[pO
	float m_DummyTrackInterval;				//	_~[pOԊu	
	std::string m_RailBlock;				//	ǋ
	int m_SpeedLimit;						//	x
	CRailConnectorLink m_Link[2];			//	ڑRlN^
	list<CRailSplitter> m_SplitList;		//	_Xg
	CRailWayParentLink *m_Parent;			//	eIuWFNg
	CPlatformInst *m_Platform;				//	vbgtH[
	CScene *m_Scene;						//	V[
	CRailPlugin *m_RailPlugin;				//	[vOC
	CTiePlugin *m_TiePlugin;				//	؃vOC
	CGirderPlugin *m_GirderPlugin;			//	vOC
	CPierPlugin *m_PierPlugin;				//	rvOC
	CLinePlugin *m_LinePlugin;				//	ːvOC
	CPolePlugin *m_PolePlugin;				//	ːvOC
	list<CPierPos> m_PierList;				//	rXg
	list<CPolePos> m_PoleList;				//	ːXg
	list<CGroupEndLocator *> m_GroupEnd;	//	ҐI[f[^
	CRailWay *m_Next;						//	Xg
public:
	static void SetRoot(CRailWay **r){ ms_Root = r; }
	static void ResetDetect(){ ms_MinDist = -1.0f; }
	static bool IsDetected(){ return ms_MinDist>=0.0f; }
	static float GetMinDist(){ return ms_MinDist; }
	static CRailWayLink GetDetect(){ return ms_Detect; }
	CRailWay();
	CRailWay(CRailConnectorLink &, CRailConnectorLink &,
		CRailPlugin *, CTiePlugin *, CGirderPlugin *,
		CPierPlugin *ipi = NULL, CLinePlugin *lpi = NULL, CPolePlugin *ppi = NULL,
		list<CRailSplitter> *splist = NULL);
	~CRailWay();
	CRailWay *Next(){ return m_Next; }
	CRailWay **NextAdr(){ return &m_Next; }
	void *OldAdr(){ return m_OldAdr; }
	int GetSelectFlag(){ return m_Selected; }
	void AddSelectFlag(int s){ m_Selected |= s; }
	CRailWayLink CreateLink(int s){ return CRailWayLink(s, this); }
	CScene *GetScene(){ return m_Scene; }
	CRailPlugin *GetRailPlugin(){ return m_RailPlugin; }
	CTiePlugin *GetTiePlugin(){ return m_TiePlugin; }
	CGirderPlugin *GetGirderPlugin(){ return m_GirderPlugin; }
	CRailWayParentLink *GetParent(){ return m_Parent; }
	void SetParent(CDetectInfo *);
	CPlatformInst *GetPlatform(){ return m_Platform; }
	void SetPlatform(CPlatformInst *pl){ m_Platform = pl; }
	void SetWarpDummy();
	bool IsMultiTrackDummy(){ return m_MultiTrackDummy; }
	bool IsLinkable(int, VEC3 &);
	float GetSegLen();
	void Stabilize();
	void AddSplitter(const CRailSplitter &spl){ m_SplitList.push_back(spl); }
	CRailConnectorLink SplitLink(CRailLinkTemp *, CRailWay **, IRailSplitter);
	void SplitSelect();
	CRailWay *Delete();
	void ConnectRailWay(int, CRailWay *, int, CScene *);
	void BranchRailWay(int, CRailWay *, int, CScene *);
	void DisconnectRailWay(int, CScene *);
	bool SetRailBlock(char *rb);
	bool IsRailBlock(){ return !m_RailBlock.empty(); }
	std::string& GetRailBlock(){ return m_RailBlock; }
	bool CheckRailBlock(CTrainGroup *);
	bool SetSpeedLimit(int);
	bool IsSpeedLimit(){ return m_SpeedLimit>=0; }
	int GetSpeedLimit(){ return m_SpeedLimit; }
	void SetMapTemp();
	void CopyMapTemp(int);
	void CopyMapTempMulti(int, float *, float *, int *, float *, float *, int *);
	CPoleLink GetPoleLink(int);
	void AddPolePos(float p){ m_PolePos += p; }
	void AddPole(float, CPole *, int, bool);
	void DeletePole(CPole *);
	void AddPierPos(float p){ m_PierPos += p; }
	void AddPier(float, CPier *);
	void DeletePier(CPier *);
	void BuildLine(CPierPlugin *, CLinePlugin *, CPolePlugin *);
	void ShowSegment();
	void ScanInput(int, VEC3 &, VEC3 &);
	void ScanInputWarp(int, VEC3 &, VEC3 &);
	void TraceRail(int, CRailTraceCurve *);
	void TraceRailSplit(int, CRailTraceCurve *);
	VEC3 GetFirstDir(int);
	void RemoveGroup();
	void CheckWarpEndScene(CScene *);
	bool IsInsideGroup(int, float);
	bool SetTrain(int, float, CGroupEndLocator *, bool,
		ITrainSetBuffer *, ITrainSetBuffer *, CTrainGroup *, bool, bool);
	int MarchTrain(float *, CGroupEndLocator *, CTrainGroup *, CTrainGroup *);
	bool CheckPlatformExtend(int, CPlatformInst *);
	int GetPlatformState();
	void UpdateSplitList();
	void Dump();
	void Render();
	void RenderWarp();
	void RestoreAddress();
	char *Read(char *);
	char *ReadWarp(char *);
	void Save(FILE *);
	void SaveWarp(FILE *);
};

//	q
typedef list<CRailWay *>::iterator IPRailWay;
typedef list<list<CRailWay *> >::iterator ILPRailWay;
typedef list<list<list<CRailWay *> > >::iterator ILLPRailWay;

/*
 *	ڑJgʂ߂
 */
inline float CRailWayLink::GetCant(){
	return m_Side ? -m_Link->m_Link[m_Side].m_Cant : m_Link->m_Link[m_Side].m_Cant;
}

/*
 *	ڑW߂
 */
inline VEC3 CRailWayLink::GetPos(){
	return m_Link->m_Link[m_Side].GetPos();
}

/*
 *	ڑ攽΍W߂
 */
inline VEC3 CRailWayLink::GetOppositePos(){
	return m_Link->m_Link[!m_Side].GetPos();
}

/*
 *	ŏ̕_܂ł dir xNg߂
 */
inline VEC3 CRailWayLink::GetFirstDir(){
	return m_Link->GetFirstDir(m_Side);
}

/*
 *	[ڑꎞf[^
 */
class CRailLinkTemp{
public:
	int m_Side;					//	TCh
	float m_SumLen;				//	ώZ
	IRailSplitter m_SpliceItr;	//	Xvbgʒu
	VEC3 m_Pos;					//	W
	VEC3 m_Right;				//	right
	VEC3 m_Up;					//	up
	VEC3 m_Dir;					//	dir
	CRailWay *m_Link;			//	[
public:
	CRailLinkTemp(){ m_Link = NULL; }
	CRailLinkTemp(int, float, VEC3 &, VEC3 &, VEC3 &, VEC3 &, CRailWay *, IRailSplitter);
	CRailConnectorLink SplitLink(CRailWay **wadr){
		return m_Link->SplitLink(this, wadr, m_SpliceItr);
	}
	void CopyMapTemp(){ m_Link->CopyMapTemp(m_Side); }
};

//	OO[o
extern list<list<list<CRailWay *> > > g_MultiTrackRailList;
extern ILLPRailWay g_MultiTrackSegment;
extern ILPRailWay g_SingleTrackSegment;
extern bool g_MultiTrackDummy;
extern int g_DummyTrackNum;
extern float g_DummyTrackInterval;
extern map<std::string, CTrainGroup *> g_RailBlockMap;

//	֐錾
CTrainGroup* GetRailBlockUser(std::string&);
void SetRailBlockUser(std::string&, CTrainGroup *);
void ClearRailBlockUser(CTrainGroup *);

#endif
