#include "stdafx.h"

/*
 *	RXgN^
 */
CSynErr::CSynErr(
	char *pos	//	G[ӏ
){
	m_Message = lang(SyntaxError);
	m_ErrorPos = pos;
}

/*
 *	RXgN^
 */
CSynErr::CSynErr(
	char *pos,			//	G[ӏ
	const char *format,	//	
	...					//	CӃp^
){
	char *buf = FlashIn("");
	va_list	vl;
	va_start(vl, format);
	vsprintf(buf, format, vl);
	va_end(vl);
	m_Message = buf;
	m_ErrorPos = pos;
}

/*
 *	RXgN^
 */
void CSynErr::Handle(
	string head,	//	bZ[Wwb_
	char *buf		//	XNvgobt@
){
	if(!buf || !m_ErrorPos || m_ErrorPos<buf){
		ErrorDialog("%s\n%s", head.c_str(), m_Message.c_str());
		return;
	}
	char *ptr = buf;
	int line = 1;
	bool cr = false;
	while(*ptr && ptr<m_ErrorPos){
		char *next = CharNext(ptr);
		if(next-ptr>1){
			cr = false;
		}else if(*ptr==0x0d){
			line++;
			cr = true;
		}else if(*ptr==0x0a){
			if(!cr) line++;
			cr = false;
		}else{
			cr = false;
		}
		ptr = next;
	}
	if(ptr<m_ErrorPos){
		ErrorDialog("%s\n%s", head.c_str(), m_Message.c_str());
	}else{
		int i = 0;
		char *tmp = ptr;
		for(; *tmp && *tmp!=0x0d && *tmp!=0x0a && i<512; i++, tmp++);
		*tmp = 0;
		ErrorDialog("%s\nLine %d\n--------------------\n%s\n--------------------\n%s",
			head.c_str(), line, ptr, m_Message.c_str());
	}
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

/*
 *	At@xbg + A_[XRA
 */
inline char *Nondigit(
	char *str	//	
){
	if('A'<=*str && *str<='Z' || 'a'<=*str && *str<='z'
 		|| *str=='_') return str+1;
	return NULL;
}

/*
 *	
 */
inline char *Digit(
	char *str	//	
){
	if('0'<=*str && *str<='9') return str+1;
	return NULL;
}

/*
 *	
 */
inline char *Hexadecimal(
	char *str	//	
){
	if('A'<=*str && *str<='F' || 'a'<=*str && *str<='f'
		|| '0'<=*str && *str<='9') return str+1;
	return NULL;
}

/*
 *	󔒂уRg
 */
char *Space(
	char *str	//	Ώە
){
	while(str && *str){
		char *tmp, *eee;
		if(tmp = Character(str, ' ')){
			str = tmp;
		}else if(tmp = Character(str, '\t')){
			str = tmp;
		}else if(tmp = Character(str, '\r')){
			str = tmp;
		}else if(tmp = Character(str, '\n')){
			str = tmp;
		}else if(tmp = String(str, "@")){
			str = tmp;
		}else if(tmp = String(str, "//")){
			str = tmp;
			while(*str){
				if(tmp = Character(str, '\n')){
					str = tmp;
					break;
				}
				str = CharNext(str);
			}
		}else if(tmp = String(eee = str, "/*")){
			char *cmtloc = str;
			str = tmp;
			while(true){
				if(!*str) throw CSynErr(eee, lang(CommentEndNotFound));
				if(tmp = String(str, "*/")){
					str = tmp;
					break;
				}else{
					str = CharNext(str);
				}
			}
		}else{
			break;
		}
	}
	return str;
}

/*
 *	萔l
 */
char *ConstValue(
	char *str,	//	Ώە
	int *reti,	//	Ǎ (int)
	float *retf	//	Ǎ (float)
){
	char *tmp;
	bool minus = false;
	if(tmp = Character(str, '-')){
		str = tmp;
		minus = true;
	}
	if(tmp = Digit(str)){
		while(true){
			char *tmp2;
			if(tmp2 = Digit(tmp)){
				tmp = tmp2;
			}else if(tmp2 = Character(tmp, '.')){
				tmp = tmp2;
				goto UNDERDECIMAL;
			}else{
				char save = *tmp;
				*tmp = 0;
				int val;
				sscanf(str, "%d", &val);
				*reti = minus ? -val : val;
				*retf = (float)*reti;
				*tmp = save;
				return Space(tmp);
			}
		}
	}else if(tmp = Character(str, '.')){
UNDERDECIMAL:
		char *tmp2;
		if(tmp2 = Character(tmp, '#')){
			tmp = tmp2;
			while(true){
				if((tmp2 = Digit(tmp)) || (tmp2 = Nondigit(tmp))){
					tmp = tmp2;
				}else{
					*retf = 0.0f;
					*reti = 0;
					return Space(tmp);
				}
			}
		}
		while(true){
			if(tmp2 = Digit(tmp)){
				tmp = tmp2;
			}else{
				char save = *tmp;
				*tmp = 0;
				float val;
				sscanf(str, "%f", &val);
				*retf = minus ? -val : val;
				*reti = (int)*retf;
				*tmp = save;
				return Space(tmp);
			}
		}
	}
	return NULL;
}

/*
 *	l
 */
char *ConstInteger(
	char *str,	//	Ώە
	int *ret	//	Ǎ
){
	float dummy;
	if(str = ConstValue(str, ret, &dummy)) return str;
	return NULL;
}

/*
 *	l
 */
char *ConstFloat(
	char *str,	//	Ώە
	float *ret	//	Ǎ
){
	int dummy;
	if(str = ConstValue(str, &dummy, ret)) return str;
	return NULL;
}

/*
 *	Fl
 */
char *ColorValue(
	char *str,		//	Ώە
	D3DCOLOR *ret	//	Ǎ
){
	char *tmp;
	if(tmp = Character(str, '#')){
		str = tmp;
		while(true){
			char *tmp2;
			if(tmp2 = Hexadecimal(tmp)){
				tmp = tmp2;
			}else{
				char save = *tmp;
				*tmp = 0;
				D3DCOLOR val;
				sscanf(str, "%x", &val);
				*ret = val;
				*tmp = save;
				return Space(tmp);
			}
		}
	}
	return NULL;
}

/*
 *	|C^
 */
char *HexPointer(
	char *str,	//	Ώە
	void **ret	//	Ǎ
){
	char *tmp;
	if(tmp = Hexadecimal(str)){
		while(true){
			char *tmp2;
			if(tmp2 = Hexadecimal(tmp)){
				tmp = tmp2;
			}else{
				char save = *tmp;
				*tmp = 0;
				void *val;
				sscanf(str, "%p", &val);
				*ret = val;
				*tmp = save;
				return Space(tmp);
			}
		}
	}
	return NULL;
}

/*
 *	2D xNg
 */
char *Vector2D(
	char *str,	//	Ώە
	VEC2 *ret	//	Ǎ
){
	if(!(str = Character2(str, '('))) return NULL;
	if(!(str = ConstFloat(str, &ret->x))) return NULL;
	if(!(str = Character2(str, ','))) return NULL;
	if(!(str = ConstFloat(str, &ret->y))) return NULL;
	if(!(str = Character2(str, ')'))) return NULL;
	return str;
}

/*
 *	3D xNg
 */
char *Vector3D(
	char *str,	//	Ώە
	VEC3 *ret	//	Ǎ
){
	if(!(str = Character2(str, '('))) return NULL;
	if(!(str = ConstFloat(str, &ret->x))) return NULL;
	if(!(str = Character2(str, ','))) return NULL;
	if(!(str = ConstFloat(str, &ret->y))) return NULL;
	if(!(str = Character2(str, ','))) return NULL;
	if(!(str = ConstFloat(str, &ret->z))) return NULL;
	if(!(str = Character2(str, ')'))) return NULL;
	return str;
}

/*
 *	ʎq
 */
char *Identifier(
	char *str,	//	Ώە
	string *ret	//	Ǎ
){
	char *tmp;
	if(!(tmp = Nondigit(str))) return NULL;
	while(true){
		char *tmp2;
		if(tmp2 = Nondigit(tmp)){
			tmp = tmp2;
		}else if(tmp2 = Digit(tmp)){
			tmp = tmp2;
		}else{
			char save = *tmp;
			*tmp = 0;
			*ret = str;
			*tmp = save;
			return Space(tmp);
		}
	}
	return NULL;
}

/*
 *	e
 */
char *StringLiteral(
	char *str,	//	Ώە
	string *ret	//	Ǎ
){
	char *tmp, *eee;
	if(tmp = Character(eee = str, '\"')){
		str = tmp;
		while(*tmp){
			char *tmp2;
			if((tmp2 = Character(tmp, '\r'))
				|| (tmp2 = Character(tmp, '\n'))){
				throw CSynErr(eee, lang(StringLiteralExceedLineBreak));
			}else if(tmp2 = String(tmp, "\\\"")){
				tmp = tmp2;
			}else if(tmp2 = String(tmp, "\\\r\n")){
				tmp = tmp2;
			}else if(tmp2 = Character(tmp, '\"')){
				char save = *tmp;
				*tmp = 0;
				*ret = str;
				*tmp = save;
				return Space(tmp2);
			}else{
				tmp = CharNext(tmp);
			}
		}
	}
	return NULL;
}

/*
 *	yes / no
 */
char *BoolYesNo(
	char *str,	//	Ώە
	bool *ret	//	Ǎ
){
	string yesno;
	if(!(str = Identifier(str, &yesno))) return NULL;
	*ret = yesno=="yes" ? true : false;
	return str;
}

/*
 *	ʎq + r
 */
char *Identifier2(
	char *str,	//	Ώە
	char *read	//	ʎq
){
	string tmp;
	if(!(str = Identifier(str, &tmp))) return NULL;
	return tmp==read ? str : NULL;
}

/*
 *	
 */
char *Assignment(
	char *str,	//	Ώە
	char *read	//	ʎq
){
	if(!(str = Identifier2(str, read))) return NULL;
	return Character2(str, '=');
}

/*
 *	
 */
char *AsgnInteger(
	char *str,	//	Ώە
	char *read,	//	ʎq
	int *ret,	//	Ǎ
	int n,		//	Ǎ
	bool fill	//	s⊮
){
	if(!(str = Assignment(str, read))) return NULL;
	if(!(str = ConstInteger(str, ret++))) return NULL;
	while(--n>0){
		char *tmp;
		if(tmp = Character2(str, ';')){
			if(!fill) return NULL;
			while(n-->0){ *ret = *(ret-1); ret++; }
			return tmp;
		}
		if(!(str = Character2(str, ','))) return NULL;
		if(!(str = ConstInteger(str, ret++))) return NULL;
	}
	return Character2(str, ';');
}

/*
 *	
 */
char *AsgnFloat(
	char *str,	//	Ώە
	char *read,	//	ʎq
	float *ret,	//	Ǎ
	int n,		//	Ǎ
	bool fill	//	s⊮
){
	if(!(str = Assignment(str, read))) return NULL;
	if(!(str = ConstFloat(str, ret++))) return NULL;
	while(--n>0){
		char *tmp;
		if(tmp = Character2(str, ';')){
			if(!fill) return NULL;
			while(n-->0){ *ret = *(ret-1); ret++; }
			return tmp;
		}
		if(!(str = Character2(str, ','))) return NULL;
		if(!(str = ConstFloat(str, ret++))) return NULL;
	}
	return Character2(str, ';');
}

/*
 *	Fl
 */
char *AsgnColor(
	char *str,		//	Ώە
	char *read,		//	ʎq
	D3DCOLOR *ret,	//	Ǎ
	int n,			//	Ǎ
	bool fill		//	s⊮
){
	if(!(str = Assignment(str, read))) return NULL;
	if(!(str = ColorValue(str, ret++))) return NULL;
	while(--n>0){
		char *tmp;
		if(tmp = Character2(str, ';')){
			if(!fill) return NULL;
			while(n-->0){ *ret = *(ret-1); ret++; }
			return tmp;
		}
		if(!(str = Character2(str, ','))) return NULL;
		if(!(str = ColorValue(str, ret++))) return NULL;
	}
	return Character2(str, ';');
}

/*
 *	Fl
 */
char *AsgnPointer(
	char *str,	//	Ώە
	char *read,	//	ʎq
	void **ret,	//	Ǎ
	int n,		//	Ǎ
	bool fill	//	s⊮
){
	if(!(str = Assignment(str, read))) return NULL;
	if(!(str = HexPointer(str, ret++))) return NULL;
	while(--n>0){
		char *tmp;
		if(tmp = Character2(str, ';')){
			if(!fill) return NULL;
			while(n-->0){ *ret = *(ret-1); ret++; }
			return tmp;
		}
		if(!(str = Character2(str, ','))) return NULL;
		if(!(str = HexPointer(str, ret++))) return NULL;
	}
	return Character2(str, ';');
}

/*
 *	2D xNg
 */
char *AsgnVector2D(
	char *str,	//	Ώە
	char *read,	//	ʎq
	VEC2 *ret,	//	Ǎ
	int n,		//	Ǎ
	bool fill	//	s⊮
){
	if(!(str = Assignment(str, read))) return NULL;
	if(!(str = Vector2D(str, ret++))) return NULL;
	while(--n>0){
		char *tmp;
		if(tmp = Character2(str, ';')){
			if(!fill) return NULL;
			while(n-->0){ *ret = *(ret-1); ret++; }
			return tmp;
		}
		if(!(str = Character2(str, ','))) return NULL;
		if(!(str = Vector2D(str, ret++))) return NULL;
	}
	return Character2(str, ';');
}

/*
 *	3D xNg
 */
char *AsgnVector3D(
	char *str,	//	Ώە
	char *read,	//	ʎq
	VEC3 *ret,	//	Ǎ
	int n,		//	Ǎ
	bool fill	//	s⊮
){
	if(!(str = Assignment(str, read))) return NULL;
	if(!(str = Vector3D(str, ret++))) return NULL;
	while(--n>0){
		char *tmp;
		if(tmp = Character2(str, ';')){
			if(!fill) return NULL;
			while(n-->0){ *ret = *(ret-1); ret++; }
			return tmp;
		}
		if(!(str = Character2(str, ','))) return NULL;
		if(!(str = Vector3D(str, ret++))) return NULL;
	}
	return Character2(str, ';');
}

/*
 *	ʎq
 */
char *AsgnIdentifier(
	char *str,		//	Ώە
	char *read,		//	ʎq
	string *ret,	//	Ǎ
	int n,			//	Ǎ
	bool fill		//	s⊮
){
	if(!(str = Assignment(str, read))) return NULL;
	if(!(str = Identifier(str, ret++))) return NULL;
	while(--n>0){
		char *tmp;
		if(tmp = Character2(str, ';')){
			if(!fill) return NULL;
			while(n-->0){ *ret = *(ret-1); ret++; }
			return tmp;
		}
		if(!(str = Character2(str, ','))) return NULL;
		if(!(str = Identifier(str, ret++))) return NULL;
	}
	return Character2(str, ';');
}

/*
 *	
 */
char *AsgnString(
	char *str,		//	Ώە
	char *read,		//	ʎq
	string *ret,	//	Ǎ
	int n,			//	Ǎ
	bool fill		//	s⊮
){
	if(!(str = Assignment(str, read))) return NULL;
	if(!(str = StringLiteral(str, ret++))) return NULL;
	while(--n>0){
		char *tmp;
		if(tmp = Character2(str, ';')){
			if(!fill) return NULL;
			while(n-->0){ *ret = *(ret-1); ret++; }
			return tmp;
		}
		if(!(str = Character2(str, ','))) return NULL;
		if(!(str = StringLiteral(str, ret++))) return NULL;
	}
	return Character2(str, ';');
}

/*
 *	yes / no  (yes: 1, no: 0)
 */
char *AsgnYesNo(
	char *str,	//	Ώە
	char *read,	//	ʎq
	bool *ret,	//	Ǎ
	int n,		//	Ǎ
	bool fill	//	s⊮
){
	string yesno;
	if(!(str = Assignment(str, read))) return NULL;
	if(!(str = Identifier(str, &yesno))) return NULL;
	*ret = yesno=="yes" ? true : false; ret++;
	while(--n>0){
		char *tmp;
		if(tmp = Character2(str, ';')){
			if(!fill) return NULL;
			while(n-->0){ *ret = *(ret-1); ret++; }
			return tmp;
		}
		if(!(str = Character2(str, ','))) return NULL;
		if(!(str = Identifier(str, &yesno))) return NULL;
		*ret = yesno=="yes" ? true : false; ret++;
	}
	return Character2(str, ';');
}

/*
 *	ubNJn
 */
char *BeginBlock(
	char *str,	//	Ώە
	char *read	//	ʎq
){
	if(!(str = Identifier2(str, read))) return NULL;
	return Character2(str, '{');
}

/*
 *	OtubNJn
 */
char *BeginNamedBlock(
	char *str,		//	Ώە
	char *read,		//	ʎq
	string *name	//	O
){
	if(!(str = Identifier2(str, read))) return NULL;
	if(!(str = StringLiteral(str, name))) return NULL;
	return Character2(str, '{');
}

/*
 *	ubNI
 */
char *EndBlock(
	char *str	//	Ώە
){
	return Character2(str, '}');
}
