﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Net.Sockets;
using System.Data;
using System.IO;

namespace 文書追跡管理ＲＣＭ {
    class mainprocess {
        readonly int 受信ポート = global::文書追跡管理ＲＣＭ.Properties.Settings.Default.受信ポート;
        readonly int 送信先ポート = global::文書追跡管理ＲＣＭ.Properties.Settings.Default.送信先ポート;
        readonly string 送信先サーバ = global::文書追跡管理ＲＣＭ.Properties.Settings.Default.送信先サーバ;

        Queue<string> que = new Queue<string>();
        IPEndPoint remoteEndPoint;// = new IPEndPoint(IPAddress.Any, 0);
        string version;
        string pcname = Environment.MachineName;
        string rectext;
        System.Threading.Thread consolethread;
        System.Threading.Thread messagethread;
        bool done;
        UdpClient udp;
        FileStream stm;
        StreamWriter w;
        System.Threading.Mutex objMutex;
        //Dictionary<string, string> logined = new Dictionary<string, string>();
        //開始
        public void main_p() {

            objMutex = new System.Threading.Mutex(false, "doccmd");
            if(objMutex.WaitOne(0, false) == false) {
                Console.WriteLine("すでにマネージャが起動しています。起動出来ません。");
                System.Threading.Thread.Sleep(1000);
                return;
            }
            stm = new FileStream(System.AppDomain.CurrentDomain.BaseDirectory + "commandLog000000.TXT", FileMode.Append);
            w = new StreamWriter(stm, Encoding.GetEncoding("Shift-Jis"));
            System.Reflection.AssemblyName AssemblyName = System.Reflection.Assembly.GetExecutingAssembly().GetName();
            version = AssemblyName.Version.ToString();
            log("{0}電子文書追跡管理サーバーコマンドマネージャ version {1} {2}", Environment.NewLine, version, DateTime.Now);
            log("port number {0} Using.", 受信ポート);
            consolethread = new System.Threading.Thread(new System.Threading.ThreadStart(this.consoleProcess));
            consolethread.Start();
            udp = new UdpClient(受信ポート);
            送信先 = 送信先サーバ + "+" + 送信先ポート.ToString();
            messagethread = new System.Threading.Thread(new System.Threading.ThreadStart(this.messagereceive));
            messagethread.Priority = System.Threading.ThreadPriority.AboveNormal;
            messagethread.Start();
            log("manager main thread finished.");
            udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "connect");
            command_on = true;
        }

        //電文受信
        public void messagereceive() {
            log("manager receiving thread started.");
            done = false;
            udp.EnableBroadcast = true;
            while(!done) {
                try {
                    remoteEndPoint = null;
                    byte[] bytes = udp.Receive(ref remoteEndPoint);               //受信待ち
                    rectext = Encoding.UTF8.GetString(bytes, 0, bytes.Length);
                    log(">" + rectext);
                }
                catch(Exception ex) {
                    log(ex.Message);
                }
            }
            log("command manager receiving thread finished.");
        }

        //コマンド入力
        string 送信先;
        bool 終わる = false;
        void consoleProcess() {
            Console.BackgroundColor = System.ConsoleColor.White;
            Console.ForegroundColor = System.ConsoleColor.DarkBlue;
            Console.WindowWidth = Console.LargestWindowWidth - 20 ;
            log("command manager console thread started. Keyin HELP to list name of commands.");
            string ccc;
            while(true) {
                String card = Console.ReadLine();
                ccc = card.Split(' ')[0];
                w.WriteLine(ccc);
                コマンド処理(ccc, card);
                if(終わる) {
                    done = true;
                    break;
                }
            }
            udp.Close();
            messagethread.Join();
            log("command manager console thread will finish.");
            w.Close();
            stm.Close();
            objMutex.Close(); //ミューテックスを解放する
            System.Threading.Thread.Sleep(300);
        }

        private void コマンド処理(string ccc, String card) {
            if(command_on) {
                switch(ccc) {
                    case "terminate":
                        log("常駐の文書追跡管理サービスプログラムを終了させます。良ければパスワードを入れてください。");
                        if(Console.ReadLine() == "kanri") {
                            udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "terminate");
                            command_on = false;
                        }
                        break;
                    case "list":
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "list");
                        break;
                    case "listkey":
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "listkey");
                        break;
                    case "deldocumentinfo":
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "deldocumentinfo" + "|" + card.Substring(card.IndexOf(' ') + 1));
                        break;
                    case "count":
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "count");
                        break;
                    case "save":
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "save");
                        break;
                    case "loginname":
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "loginname");
                        break;
                    case "logincount":
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "logincount");
                        break;
                    case "flush":
                        w.Flush();
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "flush");
                        break;
                    case "version":
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "version");
                        break;
                    case "purge":
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "purge");
                        break;
                    case "help":
                        log("local command are　 connect,　disconnect,　exit");
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "help");
                        break;
                    case "abort":
                        log("常駐の文書追跡管理サービスプログラムを異常終了させます。良ければパスワードを入れてください。");
                        if(Console.ReadLine() == "kanri") {
                            udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "abort");
                            command_on = false;
                        }
                        break;
                    case "exit":
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "disconnect");
                        command_on = false;
                        終わる = true;
                        break;
                    case "disconnect":
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "disconnect");
                        command_on = false;
                        break;
                    case "connect":
                        log("オンライン中です。");
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "connect");
                        command_on = true;
                        break;
                    case "stat":
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "stat");
                        command_on = true;
                        break;
                    default:
                        log("コマンドエラー");
                        break;
                }
            }
            else {
                //未接続
                switch(ccc) {
                    case "help":
                        log("help, connect, exit (OFFLINE)");
                        break;
                    case "exit":
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "disconnect");
                        終わる = true;
                        break;
                    case "connect":
                        udpsend(送信先, DateTime.Now.ToString("MM/dd HH:mm:ss") + "|" + pcname + "|COMND|" + version + "|" + "connect");
                        command_on = true;
                        break;
                    default:
                        log("オフライン中です。connect が必要です。 ）");
                        break;
                }
            }
        }
        bool command_on;


        //電文送信
        void udpsend(string IPaddressAndPort, params string[] text)  //送信
        {
            byte[] bytes = Encoding.UTF8.GetBytes(string.Join("|", text));
            udp.Send(bytes, bytes.Length, IPaddressAndPort.Split('+')[0], Int32.Parse(IPaddressAndPort.Split('+')[1]));
        }

        //コンソール出力＆ロギング
        void log(string editstring, params object[] editvalue) {
            Console.WriteLine(editstring, editvalue);
            if(stm.Name.Substring(stm.Name.Length - 10, 6) == DateTime.Today.Year.ToString() + DateTime.Today.Month.ToString("00")) {
                w.WriteLine(editstring, editvalue);
            }
            else {
                //スイッチ
                w.WriteLine("command log file switched");
                w.Dispose();
                stm.Dispose();
                stm = new FileStream(System.AppDomain.CurrentDomain.BaseDirectory + "commandLog" + DateTime.Today.Year.ToString() + DateTime.Today.Month.ToString("00") + ".TXT", FileMode.Append);
                w = new StreamWriter(stm, Encoding.GetEncoding("Shift-Jis"));
                w.WriteLine(editstring, editvalue);
                //削除
                File.Delete(System.AppDomain.CurrentDomain.BaseDirectory + "commandLog" + DateTime.Today.AddMonths(-1 * 1).Year.ToString() + DateTime.Today.AddMonths(-1 * 1).Month.ToString("00") + ".TXT");
                File.Delete(System.AppDomain.CurrentDomain.BaseDirectory + "commandLog" + "000000" + ".TXT");
            }
        }
    }
}
