/*
 * Decompiled with CFR 0.152.
 */
package com.rapide_act;

import com.rapide_act.CmnProperty;
import com.rapide_act.CmnUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;

public class DataAccessObjects {
    private String driver = null;
    private String user = null;
    private String pass = null;
    private String url = null;
    private Connection conn = null;
    private PreparedStatement stmt = null;
    private ResultSet rst = null;
    private ResultSetMetaData rsmd = null;
    private int ColumnCount = 0;
    private ArrayList<String> alColName = null;
    private ArrayList<String> alColTypeName = null;
    private ArrayList<Integer> alIsNullable = null;
    private ArrayList<Boolean> alColMask = null;
    private ArrayList<Boolean> alColIncl = null;
    private ArrayList<String> alData = null;
    private static String sql = "select sysdate from dual";
    private String[] colTypeName = null;
    private String[] colName = null;
    private Integer[] isNullable = null;
    private Boolean[] colMask = null;
    private Boolean[] colIncl = null;
    private String colString = null;
    private BigDecimal colBigDecimal = null;
    private Integer colInt = null;
    private Short colShort = null;
    private Float colFloat = null;
    private Double colDouble = null;
    private Timestamp colTimestamp = null;
    private Time colTime = null;
    private Date colDate = null;
    private byte[] colBytes = null;
    private Blob colBlob = null;
    private Clob colClob = null;
    private String tbName = null;
    private int recCount = 0;
    private CmnProperty cp = null;

    DataAccessObjects(String string, String string2, String string3, String string4) {
        this.user = string;
        this.pass = string2;
        this.url = string3;
        this.driver = string4;
    }

    DataAccessObjects(CmnProperty cmnProperty) {
        this.cp = cmnProperty;
        this.user = this.cp.user;
        this.pass = this.cp.pass;
        this.url = this.cp.url;
        this.driver = this.cp.driver;
    }

    public Connection connect() throws Exception {
        try {
            CmnUtils.debugPrint("Start Driver class loading");
            Class.forName(this.driver);
            CmnUtils.debugPrint("End Driver class loading");
            CmnUtils.debugPrint("Start Connect Database>" + this.url + "," + this.user);
            this.conn = DriverManager.getConnection(this.url, this.user, this.pass);
            CmnUtils.debugPrint("End Connect Database");
            return this.conn;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    public PreparedStatement prepareSql(String string) throws Exception {
        try {
            CmnUtils.debugPrint("Start prepared Statement");
            CmnUtils.debugPrint(string);
            this.stmt = this.conn.prepareStatement(string);
            CmnUtils.debugPrint("End prepared Statement");
            return this.stmt;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    public void executeSql() throws Exception {
        try {
            this.executeSql(this.stmt);
            CmnUtils.debugPrint("Start get RecordSet");
            while (this.rst.next()) {
                for (int i = 0; i < this.ColumnCount; ++i) {
                    this.colString = this.getColString(this.rst, i + 1, this.colTypeName[i], this.isNullable[i], false);
                    if (this.colString != null) {
                        this.alData.add(this.colString);
                        continue;
                    }
                    this.alData.add("");
                }
            }
            CmnUtils.debugPrint("End get RecordSet");
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (this.rst != null) {
                this.rst.close();
                this.rst = null;
            }
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
        }
    }

    public void executeSql(PreparedStatement preparedStatement) throws Exception {
        try {
            CmnUtils.debugPrint("Start execute Query");
            this.rst = preparedStatement.executeQuery();
            CmnUtils.debugPrint("End execute Query");
            CmnUtils.debugPrint("Start get MetaData");
            this.rsmd = this.rst.getMetaData();
            CmnUtils.debugPrint("End get MetaData");
            CmnUtils.debugPrint("Start get ColumnCount");
            this.ColumnCount = this.rsmd.getColumnCount();
            CmnUtils.debugPrint("End get ColumnCount," + this.ColumnCount);
            this.alColTypeName = new ArrayList();
            this.alColName = new ArrayList();
            this.alIsNullable = new ArrayList();
            this.alData = new ArrayList();
            for (int i = 0; i < this.ColumnCount; ++i) {
                this.alColTypeName.add(this.rsmd.getColumnTypeName(i + 1));
                this.alColName.add(this.rsmd.getColumnName(i + 1));
                this.alIsNullable.add(this.rsmd.isNullable(i + 1));
            }
            this.colTypeName = this.alColTypeName.toArray(new String[0]);
            this.colName = this.alColName.toArray(new String[0]);
            this.isNullable = this.alIsNullable.toArray(new Integer[0]);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    public void commit() throws Exception {
        CmnUtils.debugPrint("Start commit");
        this.conn.commit();
        CmnUtils.debugPrint("End commit");
    }

    public void rollback() throws Exception {
        CmnUtils.debugPrint("Start rollback");
        this.conn.rollback();
        CmnUtils.debugPrint("End rollback");
    }

    public void closeRecordSet() throws Exception {
        if (this.rst != null) {
            this.rst.close();
            this.rst = null;
        }
        if (this.stmt != null) {
            this.stmt.close();
            this.stmt = null;
        }
    }

    public void select(String string) throws Exception {
        PreparedStatement preparedStatement = this.prepareSql(string);
        this.executeSql(preparedStatement);
        this.getRecordToArray();
        this.closeRecordSet();
    }

    public int getColumnCount() throws Exception {
        return this.ColumnCount;
    }

    public int getRecCount() throws Exception {
        return this.recCount;
    }

    public ArrayList<String> getArrayList() throws Exception {
        return this.alData;
    }

    public ArrayList<String> getArrayColumnNameList() throws Exception {
        return this.alColName;
    }

    public ArrayList<String> getArrayColumnTypeNameList() throws Exception {
        return this.alColTypeName;
    }

    public ArrayList<Integer> getArrayIsNullableList() throws Exception {
        return this.alIsNullable;
    }

    public void setArrayColumnMaskList(ArrayList<Boolean> arrayList) throws Exception {
        this.alColMask = arrayList;
        this.colMask = this.alColMask.toArray(new Boolean[0]);
    }

    public void setArrayColumnInclList(ArrayList<Boolean> arrayList) throws Exception {
        this.alColIncl = arrayList;
        this.colIncl = this.alColIncl.toArray(new Boolean[0]);
    }

    public void setTableName(String string) throws Exception {
        this.tbName = string;
    }

    public ResultSet getResultSet() throws Exception {
        return this.rst;
    }

    public void getRecordToArray() throws Exception {
        try {
            CmnUtils.debugPrint("Start get RecordSet to Array");
            while (this.rst.next()) {
                this.colString = null;
                for (int i = 0; i < this.ColumnCount; ++i) {
                    this.colString = this.getColString(this.rst, i + 1, this.colTypeName[i], this.isNullable[i], false);
                    if (this.colString != null) {
                        this.alData.add(this.colString);
                        continue;
                    }
                    this.alData.add("");
                }
            }
            CmnUtils.debugPrint("End get RecordSet to Array");
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    public void getRecordToPrint(PrintWriter printWriter, int n, int n2) throws Exception {
        try {
            CmnUtils.debugPrint("Start get Record to Print");
            this.recCount = 0;
            while (this.rst.next()) {
                this.colString = null;
                for (int i = 0; i < this.ColumnCount; ++i) {
                    if (!this.colIncl[i].booleanValue()) continue;
                    this.colString = this.getColString(this.rst, i + 1, this.colTypeName[i], this.isNullable[i], this.colMask[i]);
                    if (this.colString != null) {
                        if (i == n) {
                            if (this.cp.isQuotation) {
                                if (n == n2) {
                                    printWriter.print("\"" + this.colString + "\"" + this.cp.lineSeparator);
                                    continue;
                                }
                                printWriter.print("\"" + this.colString);
                                continue;
                            }
                            if (n == n2) {
                                printWriter.print(this.colString + this.cp.lineSeparator);
                                continue;
                            }
                            printWriter.print(this.colString);
                            continue;
                        }
                        if (i == n2) {
                            if (this.cp.isQuotation) {
                                printWriter.print("\"" + this.cp.delimiter + "\"" + this.colString + "\"" + this.cp.lineSeparator);
                                continue;
                            }
                            printWriter.print(this.cp.delimiter + this.colString + this.cp.lineSeparator);
                            continue;
                        }
                        if (this.cp.isQuotation) {
                            printWriter.print("\"" + this.cp.delimiter + "\"" + this.colString);
                            continue;
                        }
                        printWriter.print(this.cp.delimiter + this.colString);
                        continue;
                    }
                    if (i == n) {
                        if (this.cp.isQuotation) {
                            if (n == n2) {
                                printWriter.print("\"" + this.cp.nullMark + "\"" + this.cp.lineSeparator);
                                continue;
                            }
                            printWriter.print("\"" + this.cp.nullMark);
                            continue;
                        }
                        if (n == n2) {
                            printWriter.print(this.cp.nullMark + this.cp.lineSeparator);
                            continue;
                        }
                        printWriter.print(this.cp.nullMark);
                        continue;
                    }
                    if (i == n2) {
                        if (this.cp.isQuotation) {
                            printWriter.print("\"" + this.cp.delimiter + "\"" + this.cp.nullMark + "\"" + this.cp.lineSeparator);
                            continue;
                        }
                        printWriter.print(this.cp.delimiter + this.cp.nullMark + this.cp.lineSeparator);
                        continue;
                    }
                    if (this.cp.isQuotation) {
                        printWriter.print("\"" + this.cp.delimiter + "\"" + this.cp.nullMark);
                        continue;
                    }
                    printWriter.print(this.cp.delimiter + this.cp.nullMark);
                }
                ++this.recCount;
            }
            CmnUtils.debugPrint("End get Record to Print");
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    private String getColString(ResultSet resultSet, int n, String string, Integer n2, Boolean bl) throws Exception {
        String string2;
        block43: {
            InputStream inputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            Clob clob;
            Blob blob;
            byte[] byArray;
            Double d;
            Float f;
            Short s;
            Integer n3;
            BigDecimal bigDecimal;
            Date date;
            Time time;
            Timestamp timestamp;
            block42: {
                block44: {
                    string2 = null;
                    timestamp = null;
                    time = null;
                    date = null;
                    bigDecimal = null;
                    n3 = null;
                    s = null;
                    f = null;
                    d = null;
                    byArray = null;
                    blob = null;
                    clob = null;
                    byteArrayOutputStream = null;
                    inputStream = null;
                    if (!CmnUtils.isColString(string)) break block42;
                    string2 = resultSet.getString(n);
                    if (string2 == null) break block43;
                    string2 = this.cp.isQuotation ? string2.trim().replaceAll("\u0000", "").replaceAll("\"", "\"\"") : string2.trim().replaceAll("\u0000", "");
                    if (!this.cp.isMask || !bl.booleanValue()) break block44;
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < string2.length(); ++i) {
                        block46: {
                            block45: {
                                if (this.cp.maskPattern.toUpperCase().equals(CmnProperty.MASK_PTN[1]) && i % 2 == 1) break block45;
                                if (this.cp.maskPattern.toUpperCase().equals(CmnProperty.MASK_PTN[2]) && i != 0 && i != string2.length() - 1) break block45;
                                if (!this.cp.maskPattern.toUpperCase().equals(CmnProperty.MASK_PTN[0])) break block46;
                            }
                            if (CmnUtils.isHankaku(string2.charAt(i))) {
                                stringBuffer.append(this.cp.singleByteMaskChar);
                                continue;
                            }
                            stringBuffer.append(this.cp.doubleByteMaskChar);
                            continue;
                        }
                        stringBuffer.append(string2.charAt(i));
                    }
                    string2 = stringBuffer.toString();
                }
                if (string2.equals("")) {
                    string2 = " ";
                }
                break block43;
            }
            if (CmnUtils.isColDate(string)) {
                date = resultSet.getDate(n);
                if (date != null) {
                    string2 = date.toString();
                }
            } else if (CmnUtils.isColTimestamp(string)) {
                timestamp = resultSet.getTimestamp(n);
                if (timestamp != null) {
                    string2 = timestamp.toString();
                }
            } else if (CmnUtils.isColTime(string)) {
                time = resultSet.getTime(n);
                if (time != null) {
                    string2 = time.toString();
                }
            } else if (CmnUtils.isColBigDecimal(string)) {
                bigDecimal = resultSet.getBigDecimal(n);
                if (bigDecimal != null) {
                    string2 = bigDecimal.toString();
                }
            } else if (CmnUtils.isColShort(string)) {
                s = resultSet.getShort(n);
                if (s != null) {
                    string2 = s.toString();
                }
            } else if (CmnUtils.isColInt(string)) {
                n3 = resultSet.getInt(n);
                if (n3 != null) {
                    string2 = n3.toString();
                }
            } else if (CmnUtils.isColFloat(string)) {
                f = Float.valueOf(resultSet.getFloat(n));
                if (f != null) {
                    string2 = f.toString();
                }
            } else if (CmnUtils.isColDouble(string)) {
                d = resultSet.getDouble(n);
                if (d != null) {
                    string2 = d.toString();
                }
            } else if (CmnUtils.isColBytes(string)) {
                byArray = resultSet.getBytes(n);
                if (byArray != null) {
                    string2 = CmnUtils.bytesToBase64(byArray);
                }
            } else if (CmnUtils.isColBlob(string)) {
                blob = resultSet.getBlob(n);
                if (blob != null) {
                    inputStream = blob.getBinaryStream();
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    int n4 = -1;
                    byArray = new byte[8192];
                    while ((n4 = inputStream.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n4);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                    string2 = CmnUtils.bytesToBase64(byArray);
                    inputStream.close();
                    byteArrayOutputStream.close();
                    inputStream = null;
                    byteArrayOutputStream = null;
                }
            } else if (CmnUtils.isColClob(string)) {
                clob = resultSet.getClob(n);
                if (clob != null) {
                    string2 = CmnUtils.clobToString(clob);
                }
            } else {
                CmnUtils.errorPrint("unmatch column type=" + string);
                throw new Exception("unmatch column type=" + string);
            }
        }
        return string2;
    }

    public void disconnect() throws Exception {
        try {
            CmnUtils.debugPrint("Start disconnect database");
            this.conn.close();
            CmnUtils.debugPrint("End disconnect database");
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
    }
}

