package com.rapide_act;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.math.BigInteger;

public class RapideLoader{
	private String database = null;

	public static void main(String args[]){
		try {
			if (args.length > 0){
				RapideLoader rapideLoader = new RapideLoader(args[0]);
				rapideLoader.load();
			} else {
				RapideLoader rapideLoader = new RapideLoader(null);
				rapideLoader.load();
			}
		} catch (Exception e) {
			try{
				CmnUtils.errorPrint(e.toString());
				e.printStackTrace();
			} catch (Exception ee){
				ee.printStackTrace();
			}
		}
	}


	RapideLoader(String _database) {
		super();
		database = _database;
	}

	private void load(){
		Connection conn 				= null;
		PreparedStatement stmt 			= null;
		PreparedStatement stmt_ins 		= null;
		BufferedReader br 				= null;
		String sql_load 				= null;
		String sql_insert 				= null;
		String strLine 					= null;
		String strMltLine 				= null;
		String tbName 					= null;
		String [] flName 				= null;
		String [] colData 				= null;
		String [] colName 				= null;
		String [] colTypeName 			= null;
		Integer [] isNullable 			= null;
		Boolean [] colIncl 				= null;

		File folder 						= null;
		ArrayList<String> alData 		= null;
		ArrayList<String> alColName 	= null;
		ArrayList<String> alColTypeName = null;
		ArrayList<Integer> alIsNullable = null;
		ArrayList<Boolean> alColMask 	= null;
		ArrayList<Boolean> alColIncl 	= null;

		int [] tb_col_seq 				= null;
		int [] fl_col_seq 				= null;
		int tb_count 					= 0;
		int tb_col_count 				= 0;
		int fl_col_count 				= 0;
		boolean isLob 					= false;
		boolean isContinue 				= true;
		boolean isEqual 				= false;
		CmnProperty cp = null;
		DataAccessObjects dao = null;

		try {
			cp = new CmnProperty();
			cp.setProperty(database);

			if(cp.inFolder != null){
				folder = new File(cp.inFolder);
			} else {
				if (database != null){
					folder = new File(cp.DEFAULT_IN_FOLDER + "/" + database.toUpperCase());
				} else {
					folder = new File(cp.DEFAULT_IN_FOLDER + "/" + cp.DB_TYPE_NAME[cp.dbType].toUpperCase());
				}
			}
			CmnUtils.infoPrint("-->͌tH_='" + folder + "'");
			CmnUtils.infoPrint("f[^[hJn܂B");
			dao = new DataAccessObjects(cp);
			conn = dao.connect();
			conn.setAutoCommit(false);
			dao.select(cp.tSql);
			alData = dao.getArrayList();
			tb_count = dao.getColumnCount();
			int tb_rec_count = 0;
			int fl_rec_count = 0;
			int ins_rec_count = 0;
			int tb_fl_match_count = 0;
			int inline_col_count = 0;
			File [] inFiles = folder.listFiles();
			if(inFiles != null) {
				for(int k=0;k<inFiles.length;k++){
					flName = CmnUtils.splitDot(inFiles[k].getName());
					tbName = flName[0];
					StringBuffer sbColumnName = null;
					TABLE_LOOP:
					for(int i=0;i<alData.size();i++){
						if(tbName.toUpperCase().equals(alData.get(i).toUpperCase())){
							if(cp.isInclTables && !CmnUtils.isMatch(cp.inclTablesArray,tbName.toUpperCase())){
								CmnUtils.debugPrint("cp.inclTables=" + cp.inclTables);
								CmnUtils.debugPrint("table=" + tbName + "," +CmnUtils.isMatch(cp.inclTablesArray,tbName.toUpperCase()));
								continue;
							}
							if(cp.isExclTables && CmnUtils.isMatch(cp.exclTablesArray,tbName.toUpperCase())){
								CmnUtils.debugPrint("cp.exclTables=" + cp.exclTables);
								CmnUtils.debugPrint("table=" + tbName + "," +CmnUtils.isMatch(cp.exclTablesArray,tbName.toUpperCase()));
								continue;
							}
							br = new BufferedReader(new InputStreamReader(new FileInputStream(folder + "/" + alData.get(i) + "." + flName[1]), cp.fileEncoding));
							sql_load = "select * from " + alData.get(i);
							stmt = dao.prepareSql(sql_load);
							dao.executeSql(stmt);
							alColName = dao.getArrayColumnNameList();
							alColTypeName = dao.getArrayColumnTypeNameList();
							alIsNullable = dao.getArrayIsNullableList();
							alColMask = new ArrayList<Boolean>();
							alColIncl = new ArrayList<Boolean>();
							colName = (String[])alColName.toArray(new String[0]);
							colTypeName = (String[])alColTypeName.toArray(new String[0]);
							isNullable = (Integer[])alIsNullable.toArray(new Integer[0]);
							tb_col_count = dao.getColumnCount();
							tb_col_seq = new int[tb_col_count];
							fl_col_seq = null;
							dao.closeRecordSet();
							tb_rec_count = 0;
							fl_rec_count = 0;
							ins_rec_count = 0;
							fl_col_count = 0;
							tb_fl_match_count = 0;
							inline_col_count = 0;
							strMltLine = "";
							isContinue = true;
							isLob = false;
							for(int j=0;j<colTypeName.length;j++)if(CmnUtils.isLob(colTypeName[j]))isLob = true;
							CmnUtils.debugPrint("LOB="+isLob);
							while((strLine=br.readLine()) != null){
								if (fl_rec_count == 0){
									if(cp.isQuotation){
										colData = CmnUtils.split(strLine,"\"" + cp.delimiter + "\"");
									} else {
										colData = CmnUtils.split(strLine,cp.delimiter);
									}
									fl_col_count = colData.length;
									fl_col_seq = new int[colData.length];
									CmnUtils.debugPrint("TableName=" + tbName);
									
									for(int j=0;j<colData.length;j++){
										for(int l=0;l<tb_col_count;l++){
											if(colName[l].equals(colData[j].replaceAll("\"",""))){
												if(cp.isInclCols || cp.isExclCols){
													if(
														(cp.isInclCols && 
														 !cp.isExclCols &&
														 CmnUtils.isMatch(cp.inclColsArray, tbName.toUpperCase(), colName[l].toUpperCase())
														) ||
														(cp.isInclCols && 
														 cp.isExclCols &&
														 CmnUtils.isMatch(cp.inclColsArray, tbName.toUpperCase(), colName[l].toUpperCase()) &&
														 !CmnUtils.isMatch(cp.exclColsArray, tbName.toUpperCase(), colName[l].toUpperCase())
														) ||
														(!cp.isInclCols && 
														 cp.isExclCols &&
														 !CmnUtils.isMatch(cp.exclColsArray, tbName.toUpperCase(), colName[l].toUpperCase())
														)
													){
														CmnUtils.debugPrint("ΏۃJ=" + colName[l].toUpperCase());
														alColIncl.add(true);
													} else {
														alColIncl.add(false);
													}
												} else {
													alColIncl.add(true);
												}
												break;
											}
										}
									}

									colIncl = (Boolean[])alColIncl.toArray(new Boolean[0]);
									sql_insert = "INSERT INTO " + cp.sqlQuoted + tbName + cp.sqlQuoted + "(";
									for(int j=0;j<colData.length;j++){
										for(int l=0;l<tb_col_count;l++){
											if(colName[l].equals(colData[j].replaceAll("\"",""))){
												if (colIncl[tb_fl_match_count]) {
													if (ins_rec_count == 0){
														sql_insert += cp.sqlQuoted + colName[l] + cp.sqlQuoted;
													} else {
														sql_insert += "," + cp.sqlQuoted + colName[l] + cp.sqlQuoted;
													}
													tb_col_seq[ins_rec_count]=l;
													fl_col_seq[ins_rec_count]=j;
													ins_rec_count++;
												}
												tb_fl_match_count++;
												break;
											}
										}
									}
									if (ins_rec_count > 0){
										sql_insert += ") VALUES(";
										for(int j=0;j<ins_rec_count;j++){
											if(j==0){
												sql_insert += "?";
											} else {
												sql_insert += ", ?";
											}
										}
										sql_insert += ")";
										stmt_ins = dao.prepareSql(sql_insert);
										CmnUtils.debugPrint("************Record Start");
										CmnUtils.infoPrinting(String.format("%1$-30s",tbName));
									} else {
										dao.rollback();
										CmnUtils.infoPrint("w肵؂蕶ł̃J0łBXLbv܂B");
										if(br != null){
											br.close();
											br=null;
										}
										if(stmt_ins != null){
											stmt_ins.close();
											stmt_ins=null;
										}
										break TABLE_LOOP;
									}
								} else {
									if(!strMltLine.equals("")){
										if(cp.isQuotation){
											inline_col_count = CmnUtils.split(strMltLine + cp.inColLineSeparator + strLine,"\"" + cp.delimiter + "\"").length;
										} else {
											inline_col_count = CmnUtils.split(strMltLine + cp.inColLineSeparator + strLine,cp.delimiter).length;
										}
										CmnUtils.debugPrint("length=" + inline_col_count);
										if(inline_col_count > fl_col_count){
											if(isEqual){
												isContinue = false;
												if(cp.isQuotation){
													colData = CmnUtils.split(strMltLine.substring(1,strMltLine.length()-1),"\"" + cp.delimiter + "\"");
												} else {
													colData = CmnUtils.split(strMltLine,cp.delimiter);
												}
											} else {
												dao.rollback();
												CmnUtils.errorPrint("YR[h̃JA}b`łB[" + tb_rec_count + "]");
												CmnUtils.debugPrint("************Record End");
												if(br != null){
													br.close();
													br=null;
												}
												if(stmt_ins != null){
													stmt_ins.close();
													stmt_ins=null;
												}
												break TABLE_LOOP;
											}
										} else if(inline_col_count == fl_col_count){
											strMltLine += cp.inColLineSeparator + strLine;
											CmnUtils.debugPrint("strMltLine(eq)=" + strMltLine);
											isEqual = true;
											
										} else {
											strMltLine += cp.inColLineSeparator + strLine;
											CmnUtils.debugPrint("strMltLine(le)=" + strMltLine);
										}
									} else {
										if(cp.isQuotation){
											inline_col_count = CmnUtils.split(strLine,"\"" + cp.delimiter + "\"").length;
										} else {
											inline_col_count = CmnUtils.split(strLine,cp.delimiter).length;
										}
										strMltLine = strLine;
										CmnUtils.debugPrint("strMltLine(1)=" + strMltLine);
										if(inline_col_count == fl_col_count){
											isEqual = true;
										}
									}
									if(isContinue == false){
										CmnUtils.debugPrint("strMltLine(w)=" + strMltLine);
										for(int j=0;j<ins_rec_count;j++){
											CmnUtils.deepPrint("[" + fl_rec_count + "]" + "[" + j + "]" + colName[tb_col_seq[j]].toUpperCase() + "." + colTypeName[tb_col_seq[j]] + "='" + colData[fl_col_seq[j]] + "'");
											dao.setColString(stmt_ins, colData, j, tb_col_seq, fl_col_seq);
										}
										if(isLob){
											stmt_ins.executeUpdate();
										} else {
											stmt_ins.addBatch();
										}
										strMltLine = strLine;
										tb_rec_count++;
										isContinue = true;
										isEqual = false;
										if(cp.isQuotation){
											inline_col_count = CmnUtils.split(strLine,"\"" + cp.delimiter + "\"").length;
										} else {
											inline_col_count = CmnUtils.split(strLine,cp.delimiter).length;
										}
										if(inline_col_count == fl_col_count){
											isEqual = true;
										}
									}
								}
								fl_rec_count++;
								if (fl_rec_count % cp.batchCount == 0){
									if(!isLob)stmt_ins.executeBatch();
									CmnUtils.debugPrint("insert record=" + fl_rec_count);
								}
							}
							
							if(!strMltLine.equals("")){
								if(cp.isQuotation){
									inline_col_count = CmnUtils.split(strMltLine,"\"" + cp.delimiter + "\"").length;
								} else {
									inline_col_count = CmnUtils.split(strMltLine,cp.delimiter).length;
								}
								if(inline_col_count == fl_col_count){
									isContinue = false;
									if(cp.isQuotation){
										colData = CmnUtils.split(strMltLine.substring(1,strMltLine.length()-1),"\"" + cp.delimiter + "\"");
									} else {
										colData = CmnUtils.split(strMltLine,cp.delimiter);
									}
								} else {
									dao.rollback();
									CmnUtils.errorPrint("YR[h̃JA}b`łB[" + tb_rec_count + "]");
									CmnUtils.debugPrint("************Record End");
									if(br != null){
										br.close();
										br=null;
									}
									if(stmt_ins != null){
										stmt_ins.close();
										stmt_ins=null;
									}
									break TABLE_LOOP;
								}
							}
							if(isContinue == false){
								for(int j=0;j<ins_rec_count;j++){
									CmnUtils.deepPrint("[" + fl_rec_count + "]" + "[" + j + "]" + colName[tb_col_seq[j]].toUpperCase() + "." + colTypeName[tb_col_seq[j]] + "='" + colData[fl_col_seq[j]] + "'");
									dao.setColString(stmt_ins, colData, j, tb_col_seq, fl_col_seq);
								}
								if(isLob){
									stmt_ins.executeUpdate();
								} else {
									stmt_ins.addBatch();
								}
								tb_rec_count++;
							}

							if (tb_rec_count % cp.batchCount == 0){
								if(!isLob)stmt_ins.executeBatch();
								CmnUtils.debugPrint("insert record=" + tb_rec_count);
							}
							
							
							CmnUtils.debugPrint("sql_insert=" + sql_insert);
							if(!isLob)stmt_ins.executeBatch();
							dao.commit();
							System.out.println(String.format("%1$10d",tb_rec_count) + " s [h܂B");
							CmnUtils.debugPrint("************Record End");
							if(br != null){
								br.close();
								br=null;
							}
							if(stmt_ins != null){
								stmt_ins.close();
								stmt_ins=null;
							}
							
						}
					}
				}
			} else {
				CmnUtils.errorPrint("͌tH_܂B[" + folder + "]");
			}

			CmnUtils.infoPrint("f[^[hI܂B");

		} catch(SQLException se) {
			try{
				CmnUtils.errorPrint(se.toString());
				se.printStackTrace();
				//while (se != null) {
				//  System.out.println(se.getMessage());
				//  se = se.getNextException();
				//}
				dao.rollback();
			} catch (Exception see) {}
		} catch (Exception e) {
			try{
				CmnUtils.errorPrint(e.toString());
				e.printStackTrace();
				dao.rollback();
			} catch (Exception ee) {}
		} finally{
			try{
				dao.disconnect();
				if(stmt != null){
					stmt.close();
					stmt=null;
				}
				if(stmt_ins != null){
					stmt_ins.close();
					stmt_ins=null;
				}
				if(br!=null){
					br.close();
					br=null;
				}
			} catch (Exception e) {}
		}
	}
}
