package com.rapide_act;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Blob;
import java.sql.Clob;
import java.io.PrintWriter;
import java.util.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.math.BigInteger;
import java.math.BigDecimal;
import java.nio.charset.Charset;

public class CmnAccessObjects{

	private String driver = null;
	private String user = null;
	private String pass = null;
	private String url = null;
	private Connection conn = null;
	private PreparedStatement stmt = null;
	private ResultSet rst = null; 
	private ResultSetMetaData rsmd = null; 
	private int ColumnCount = 0;
	private ArrayList<String> alColName = null;
	private ArrayList<String> alColTypeName = null;
	private ArrayList<Integer> alColPrecision = null;
	private ArrayList<Integer> alIsNullable = null;
	private ArrayList<Boolean> alColMask = null;
	private ArrayList<Boolean> alColIncl = null;
	private ArrayList<String> alData = null;
	private static String sql="select sysdate from dual";
	private String[] colTypeName = null;
	private String[] colName = null;
	private Integer[] colPrecision = null;
	private Integer[] isNullable = null;
	private Boolean [] colMask = null;
	private Boolean [] colIncl = null;

	private String colString = null;
	private BigDecimal colBigDecimal = null;
	private Integer colInt = null;
	private Long colLong = null;
	private Short colShort = null;
	private Float colFloat = null;
	private Double colDouble = null;
	private Boolean colBoolean = null;
	private java.sql.Timestamp colTimestamp = null;
	private java.sql.Time colTime = null;
	private java.sql.Date colDate = null;
	private java.sql.Date colYear = null;
	private byte [] colBytes = null;
	private Blob colBlob = null;
	private Clob colClob = null;
	private String tbName = null;
	private int recCount = 0;
	private CmnProps cp = null;

	CmnAccessObjects(String _user, String _pass, String _url, String _driver){
		user = _user;
		pass = _pass;
		url = _url;
		driver = _driver;
	}

	CmnAccessObjects(CmnProps _cp){
		cp = _cp;
		user = cp.user;
		pass = cp.pass;
		url = cp.url;
		driver = cp.driver;
	}

	protected Connection connect() throws Exception{

		try {
			CmnUtils.debugPrint("Start Driver class loading");
			Class.forName (driver);
			CmnUtils.debugPrint("End Driver class loading");
			CmnUtils.debugPrint("Start Connect Database>" + url + "," + user);
			conn = DriverManager.getConnection(url, user, pass);
			CmnUtils.debugPrint("End Connect Database");
			return conn;

		}
		catch (ClassNotFoundException e) {
			throw e;
		}
		catch (IOException e) {
			throw e;
		}
		catch (Exception e){
			throw e;
		}
	}

	protected PreparedStatement prepareSql(String _sql) throws Exception{
		try {
			CmnUtils.debugPrint("Start prepared Statement");
			CmnUtils.debugPrint(_sql);
			stmt = conn.prepareStatement(_sql);
			CmnUtils.debugPrint("End prepared Statement");
			return stmt;
		}
		catch (SQLException e) {
			throw e;
		}
		catch (Exception e){
			throw e;
		}
	}

	protected void executeSql() throws Exception{

		try {
			executeSql(stmt);
			CmnUtils.debugPrint("Start get RecordSet");
			while (rst.next()) {
				for(int i=0;i<ColumnCount;i++){
					colString = getColString(rst, i + 1, colTypeName[i], isNullable[i], false);
					if (colString != null) {
						alData.add(colString);
					} else {
						alData.add("");
					}
				}
			}
			CmnUtils.debugPrint("End get RecordSet");
		}
		catch (SQLException e) {
			throw e;
		}
		catch (Exception e){
			throw e;
		}
		finally{
			if(rst != null){
				rst.close();
				rst = null;
			}
			if(stmt != null){
				stmt.close();
				stmt = null;
			}
		}
	}

	protected void executeSql(PreparedStatement _stmt) throws Exception{

		try {
			CmnUtils.debugPrint("Start execute Query");
			rst = _stmt.executeQuery();
			CmnUtils.debugPrint("End execute Query");
			
			CmnUtils.debugPrint("Start get MetaData");
			rsmd = rst.getMetaData();
			CmnUtils.debugPrint("End get MetaData");

			CmnUtils.debugPrint("Start get ColumnCount");
			ColumnCount = rsmd.getColumnCount();
			CmnUtils.debugPrint("End get ColumnCount," + ColumnCount);
			alColTypeName = new ArrayList<String>();
			alColName = new ArrayList<String>();
			alColPrecision = new ArrayList<Integer>();
			alIsNullable = new ArrayList<Integer>();
			alData = new ArrayList<String>();
			for(int i=0;i<ColumnCount;i++){
				alColTypeName.add(rsmd.getColumnTypeName(i + 1));
				alColName.add(rsmd.getColumnName(i + 1));
				alColPrecision.add(rsmd.getPrecision(i + 1));
				alIsNullable.add(rsmd.isNullable(i + 1));
			}
			colTypeName = (String[])alColTypeName.toArray(new String[0]);
			colName = (String[])alColName.toArray(new String[0]);
			colPrecision = (Integer[])alColPrecision.toArray(new Integer[0]);
			isNullable = (Integer[])alIsNullable.toArray(new Integer[0]);
			
		}
		catch (SQLException e) {
			throw e;
		}
		catch (Exception e){
			throw e;
		}
	}

	protected void commit() throws Exception{
		CmnUtils.debugPrint("Start commit");
		conn.commit();
		CmnUtils.debugPrint("End commit");
	}

	protected void rollback() throws Exception{
		CmnUtils.debugPrint("Start rollback");
		conn.rollback();
		CmnUtils.debugPrint("End rollback");
	}
	
	protected void closeRecordSet() throws Exception{
		if(rst != null){
			rst.close();
			rst = null;
		}
		if(stmt != null){
			stmt.close();
			stmt = null;
		}
	}

	protected void select(String _sql) throws Exception{
		PreparedStatement stmt;
		stmt = prepareSql(_sql);
		executeSql(stmt);
		getRecordToArray();
		closeRecordSet();
	}

	protected int getColumnCount() throws Exception{
		return ColumnCount;
	}

	protected int getRecCount() throws Exception{
		return recCount;
	}

	protected ArrayList<String> getArrayList() throws Exception{
		return alData;
	}

	protected ArrayList<String> getArrayColumnNameList() throws Exception{
		return alColName;
	}
	
	protected ArrayList<String> getArrayColumnTypeNameList() throws Exception{
		return alColTypeName;
	}

	protected ArrayList<Integer> getArrayIsNullableList() throws Exception{
		return alIsNullable;
	}

	protected ArrayList<Integer> getArrayPrecisionList() throws Exception{
		return alColPrecision;
	}

	protected void setArrayColumnMaskList(ArrayList<Boolean> _alColMask) throws Exception{
		alColMask = _alColMask;
		colMask = (Boolean[])alColMask.toArray(new Boolean[0]);
	}

	protected void setArrayColumnInclList(ArrayList<Boolean> _alColIncl) throws Exception{
		alColIncl = _alColIncl;
		colIncl = (Boolean[])alColIncl.toArray(new Boolean[0]);
	}

	protected void setTableName(String _tbName) throws Exception{
		tbName = _tbName;
	}

	protected ResultSet getResultSet() throws Exception{
		return rst;
	}

	protected void getRecordToArray() throws Exception{
		try {
			CmnUtils.debugPrint("Start get RecordSet to Array");
			while (rst.next()) {
				colString = null;
				for(int i=0;i<ColumnCount;i++){
					colString = getColString(rst, i + 1, colTypeName[i], isNullable[i], false);
					CmnUtils.debugPrint("col=" + colString);
					if (colString != null) {
						alData.add(colString);
					} else {
						alData.add("");
					}
				}
			}
			CmnUtils.debugPrint("End get RecordSet to Array");
		}
		catch (SQLException e) {
			throw e;
		}
		catch (Exception e){
			throw e;
		}
	}
	
	protected void getRecordToPrint(PrintWriter _pw, int _firstCol, int _lastCol) throws Exception{
		try {
			CmnUtils.debugPrint("Start get Record to Print");
			recCount = 0;

			while (rst.next()) {
				colString = null;
				for(int i=0;i<ColumnCount;i++){
					if (colIncl[i]){
						colString = getColString(rst, i + 1, colTypeName[i], isNullable[i], colMask[i]);

						if (colString != null) {
							if(CmnUtils.isFixString(colTypeName[i]) && cp.isSpcPadding)colString = colString + CmnUtils.padSpace(colString, colPrecision[i], Charset.forName(cp.fileEncoding));
							if (i == _firstCol){
								if(cp.isQuotation){
									if (_firstCol == _lastCol){
										_pw.print("\"" + colString + "\"" + cp.lineSeparator);
									} else {
										_pw.print("\"" + colString);
									}
								} else {
									if (_firstCol == _lastCol){
										_pw.print(colString + cp.lineSeparator);
									} else {
										_pw.print(colString);
									}
								}
								
							} else if (i == _lastCol){
								if(cp.isQuotation){
									_pw.print("\"" + cp.delimiter + "\"" + colString + "\"" + cp.lineSeparator);
								} else {
									_pw.print(cp.delimiter + colString + cp.lineSeparator);
								}
							} else {
								if(cp.isQuotation){
									_pw.print("\"" + cp.delimiter + "\"" + colString);
								} else {
									_pw.print(cp.delimiter + colString);
								}
							}
							
							

						} else {
							if (i == _firstCol){
								if(cp.isQuotation){
									if (_firstCol == _lastCol){
										_pw.print("\"" + cp.nullMark + "\"" + cp.lineSeparator);
									} else {
										_pw.print("\"" + cp.nullMark);
									}
								} else {
									if (_firstCol == _lastCol){
										_pw.print(cp.nullMark + cp.lineSeparator);
									} else {
										_pw.print(cp.nullMark);
									}
								}
							} else if (i == _lastCol){
								if(cp.isQuotation){
									_pw.print("\"" + cp.delimiter + "\"" + cp.nullMark + "\"" + cp.lineSeparator);
								} else {
									_pw.print(cp.delimiter + cp.nullMark + cp.lineSeparator);
								}
							} else {
								if(cp.isQuotation){
									_pw.print("\"" + cp.delimiter + "\"" + cp.nullMark);
								} else {
									_pw.print(cp.delimiter + cp.nullMark);
								}
							}
						}
					}
				}
				recCount++;
			}
			CmnUtils.debugPrint("End get Record to Print");
		}
		catch (SQLException e) {
			throw e;
		}
		catch (Exception e){
			throw e;
		}
	}

	private String getColString(ResultSet _rst, int _rec_cnt, String _colTypeName, Integer _isNullable, Boolean _colMask) throws Exception{
		colString = null;
		colTimestamp = null;
		colTime = null;
		colDate = null;
		colYear = null;
		colBigDecimal = null;
		colInt = null;
		colLong = null;
		colShort = null;
		colFloat = null;
		colDouble = null;
		colBytes = null;
		colBlob = null;
		colClob = null;
		colBoolean = null;
		ByteArrayOutputStream baos = null;
		InputStream is = null;

		if (CmnUtils.isColString(_colTypeName)) {
			colString = _rst.getString(_rec_cnt);
			if (colString != null) {
				if(cp.isQuotation){
					colString =colString.trim().replaceAll("\0","").replaceAll("\"","\"\"");
				} else {
					colString =colString.trim().replaceAll("\0","");
				}
				if(cp.isMask){
					if(_colMask==true){
						StringBuffer sb = new StringBuffer();
						for(int j=0;j<colString.length();j++){
							if((cp.maskPattern.toUpperCase().equals(cp.MASK_PTN[cp.MASK_PTN_ALT]) && 
									(j % 2) == 1) || 
							   (cp.maskPattern.toUpperCase().equals(cp.MASK_PTN[cp.MASK_PTN_EDGE]) && 
							   		!(j == 0 || j == colString.length() - 1) ||
							   (cp.maskPattern.toUpperCase().equals(cp.MASK_PTN[cp.MASK_PTN_ALL]))
							   )
							){
									if(CmnUtils.isHankaku(colString.charAt(j))){
										sb.append(cp.singleByteMaskChar);
									} else {
										sb.append(cp.doubleByteMaskChar);
									}
							} else {
								sb.append(colString.charAt(j));
							}
						}
						colString = sb.toString();
					}
				}
				if(colString.equals(""))colString = " ";
			}
		} else if (CmnUtils.isColDate(_colTypeName)) {
			colDate = _rst.getDate(_rec_cnt);
			if (colDate != null) {
				colString = colDate.toString();
			}
		} else if (CmnUtils.isColYear(_colTypeName)) {
			colYear = _rst.getDate(_rec_cnt);
			if (colYear != null) {
				colString = colYear.toString().substring(0, 4);
			}
		} else if (CmnUtils.isColTimestamp(_colTypeName)) {
			colTimestamp = _rst.getTimestamp(_rec_cnt);
			if (colTimestamp != null) {
				colString = colTimestamp.toString();
			}
		} else if (CmnUtils.isColTime(_colTypeName)) {
			colTime = _rst.getTime(_rec_cnt);
			if (colTime != null) {
				colString = colTime.toString();
			}
		} else if (CmnUtils.isColBigDecimal(_colTypeName)) {
			colBigDecimal = _rst.getBigDecimal(_rec_cnt);
			if (colBigDecimal != null) {
				colString = colBigDecimal.toString();
			}
		} else if (CmnUtils.isColBoolean(_colTypeName)) {
			colBoolean = _rst.getBoolean(_rec_cnt);
			if (colBoolean != null) {
				colString = colBoolean.toString();
			}
		} else if (CmnUtils.isColShort(_colTypeName)) {
			colShort = _rst.getShort(_rec_cnt);
			if (colShort != null) {
				colString = colShort.toString();
			}
		} else if (CmnUtils.isColInt(_colTypeName)) {
			colInt = _rst.getInt(_rec_cnt);
			if (colInt != null) {
				colString = colInt.toString();
			}
		} else if (CmnUtils.isColLong(_colTypeName)) {
			colLong = _rst.getLong(_rec_cnt);
			if (colLong != null) {
				colString = colLong.toString();
			}
		} else if (CmnUtils.isColFloat(_colTypeName)) {
			colFloat = _rst.getFloat(_rec_cnt);
			if (colFloat != null) {
				colString = colFloat.toString();
			}
		} else if (CmnUtils.isColDouble(_colTypeName)) {
			colDouble = _rst.getDouble(_rec_cnt);
			if (colDouble != null) {
				colString = colDouble.toString();
			}
		} else if (CmnUtils.isColBytes(_colTypeName)) {
			colBytes = _rst.getBytes(_rec_cnt);
			if (colBytes != null) {
				colString = CmnUtils.bytesToBase64(colBytes);
			}
		} else if (CmnUtils.isColBlob(_colTypeName)) {
			colBlob = _rst.getBlob(_rec_cnt);
			if (colBlob != null) {
				is = colBlob.getBinaryStream();
				baos = new ByteArrayOutputStream();
				int len = -1;
				colBytes = new byte[8192];
				while ((len = is.read(colBytes)) != -1) {
					baos.write(colBytes,0,len);
				}
				colBytes = baos.toByteArray();
				colString = CmnUtils.bytesToBase64(colBytes);
				is.close();
				baos.close();
				is = null;
				baos = null;
			}
		} else if (CmnUtils.isColClob(_colTypeName)) {
			colClob = _rst.getClob(_rec_cnt);
			if (colClob != null) {
				colString = CmnUtils.clobToString(colClob);
			}
		} else {
			throw new Exception("J̃f[^^ΏۊOłB[" + _colTypeName  + "]");
		}
		return colString;
	}

	protected void setColString(PreparedStatement stmt_ins, String [] colData, int ins_col_count, int [] tb_col_seq, int [] fl_col_seq) throws Exception{

		if (CmnUtils.isColString(colTypeName[tb_col_seq[ins_col_count]])){
			if(cp.isMask){
				if(
					(cp.isInclColsMask &&
					 !cp.isExclColsMask && 
					 CmnUtils.isMatch(cp.inclColsMaskArray,tbName.toUpperCase(), colName[tb_col_seq[ins_col_count]].toUpperCase())
					) ||
					(cp.isInclColsMask &&
					 cp.isExclColsMask && 
					 CmnUtils.isMatch(cp.inclColsMaskArray,tbName.toUpperCase(), colName[tb_col_seq[ins_col_count]].toUpperCase()) &&
					 !CmnUtils.isMatch(cp.exclColsMaskArray,tbName.toUpperCase(),colName[tb_col_seq[ins_col_count]].toUpperCase())
					) ||
					(!cp.isInclColsMask &&
					 cp.isExclColsMask && 
					 !CmnUtils.isMatch(cp.exclColsMaskArray,tbName.toUpperCase(),colName[tb_col_seq[ins_col_count]].toUpperCase())
					)
				){
					StringBuffer sb = new StringBuffer();
					for(int l=0;l<colData[fl_col_seq[ins_col_count]].length();l++){
						if((cp.maskPattern.toUpperCase().equals(cp.MASK_PTN[cp.MASK_PTN_ALT]) && 
								(l % 2) == 1) || 
						   (cp.maskPattern.toUpperCase().equals(cp.MASK_PTN[cp.MASK_PTN_EDGE]) && 
						   		!(l == 0 || ins_col_count == colData[fl_col_seq[ins_col_count]].length() - 1) ||
						   (cp.maskPattern.toUpperCase().equals(cp.MASK_PTN[cp.MASK_PTN_ALL]))
						   )
						){
							if(CmnUtils.isHankaku(colData[fl_col_seq[ins_col_count]].charAt(l))){
								sb.append(cp.singleByteMaskChar);
							} else {
								sb.append(cp.doubleByteMaskChar);
							}
						} else {
							sb.append(colData[fl_col_seq[ins_col_count]].charAt(l));
						}
					}
					colData[fl_col_seq[ins_col_count]] = sb.toString();
				}
			}
			if (!colData[fl_col_seq[ins_col_count]].equals("")){
				if(cp.isQuotation){
					stmt_ins.setString(ins_col_count+1,colData[fl_col_seq[ins_col_count]].replaceAll("\"\"","\""));
				} else {
					stmt_ins.setString(ins_col_count+1,colData[fl_col_seq[ins_col_count]]);
				}
			} else {
				stmt_ins.setString(ins_col_count+1,null);
			}
		} else if (CmnUtils.isColDate(colTypeName[tb_col_seq[ins_col_count]])){
			if (!colData[fl_col_seq[ins_col_count]].equals("")){
				stmt_ins.setDate(ins_col_count+1,java.sql.Date.valueOf(colData[fl_col_seq[ins_col_count]]));
			} else {
				stmt_ins.setDate(ins_col_count+1,null);
			}
		} else if (CmnUtils.isColYear(colTypeName[tb_col_seq[ins_col_count]])){
			if (!colData[fl_col_seq[ins_col_count]].equals("")){
				stmt_ins.setString(ins_col_count+1,colData[fl_col_seq[ins_col_count]]);
			} else {
				stmt_ins.setDate(ins_col_count+1,null);
			}
		} else if (CmnUtils.isColTime(colTypeName[tb_col_seq[ins_col_count]])){
			if (!colData[fl_col_seq[ins_col_count]].equals("")){
				stmt_ins.setTime(ins_col_count+1,java.sql.Time.valueOf(colData[fl_col_seq[ins_col_count]]));
			} else {
				stmt_ins.setTime(ins_col_count+1,null);
			}
		} else if (CmnUtils.isColTimestamp(colTypeName[tb_col_seq[ins_col_count]])){
			if (!colData[fl_col_seq[ins_col_count]].equals("")){
				stmt_ins.setTimestamp(ins_col_count+1,java.sql.Timestamp.valueOf(colData[fl_col_seq[ins_col_count]]));
				//CmnUtils.debugPrint("Timestamp=" + colData[fl_col_seq[ins_col_count]]);
			} else {
				stmt_ins.setTimestamp(ins_col_count+1,null);
			}
		} else if (CmnUtils.isColBigDecimal(colTypeName[tb_col_seq[ins_col_count]])){
			if (!colData[fl_col_seq[ins_col_count]].equals("")){
				stmt_ins.setBigDecimal(ins_col_count+1,new BigDecimal(colData[fl_col_seq[ins_col_count]]));
			} else {
				stmt_ins.setNull(ins_col_count+1,java.sql.Types.DECIMAL);
			}
		} else if (CmnUtils.isColShort(colTypeName[tb_col_seq[ins_col_count]])){
			if (!colData[fl_col_seq[ins_col_count]].equals("")){
				stmt_ins.setShort(ins_col_count+1,Short.parseShort(colData[fl_col_seq[ins_col_count]]));
			} else {
				stmt_ins.setNull(ins_col_count+1,java.sql.Types.SMALLINT);
			}
		} else if (CmnUtils.isColBoolean(colTypeName[tb_col_seq[ins_col_count]])){
			if (!colData[fl_col_seq[ins_col_count]].equals("")){
				stmt_ins.setBoolean(ins_col_count+1,Boolean.valueOf(colData[fl_col_seq[ins_col_count]]));
			} else {
				stmt_ins.setNull(ins_col_count+1,java.sql.Types.BOOLEAN);
			}
		} else if (CmnUtils.isColInt(colTypeName[tb_col_seq[ins_col_count]])){
			if (!colData[fl_col_seq[ins_col_count]].equals("")){
				stmt_ins.setInt(ins_col_count+1,Integer.parseInt(colData[fl_col_seq[ins_col_count]]));
			} else {
				stmt_ins.setNull(ins_col_count+1,java.sql.Types.INTEGER);
			}
		} else if (CmnUtils.isColLong(colTypeName[tb_col_seq[ins_col_count]])){
			if (!colData[fl_col_seq[ins_col_count]].equals("")){
				stmt_ins.setLong(ins_col_count+1,Long.parseLong(colData[fl_col_seq[ins_col_count]]));
			} else {
				stmt_ins.setNull(ins_col_count+1,java.sql.Types.BIGINT);
			}
		} else if (CmnUtils.isColFloat(colTypeName[tb_col_seq[ins_col_count]])){
			if (!colData[fl_col_seq[ins_col_count]].equals("")){
				stmt_ins.setFloat(ins_col_count+1,Float.parseFloat(colData[fl_col_seq[ins_col_count]]));
			} else {
				stmt_ins.setNull(ins_col_count+1,java.sql.Types.REAL);
			}
		} else if (CmnUtils.isColDouble(colTypeName[tb_col_seq[ins_col_count]])){
			if (!colData[fl_col_seq[ins_col_count]].equals("")){
				stmt_ins.setDouble(ins_col_count+1,Double.parseDouble(colData[fl_col_seq[ins_col_count]]));
			} else {
				stmt_ins.setNull(ins_col_count+1,java.sql.Types.FLOAT);
			}
		} else if (CmnUtils.isColBytes(colTypeName[tb_col_seq[ins_col_count]])){
			if (!colData[fl_col_seq[ins_col_count]].equals("")){
				stmt_ins.setBytes(ins_col_count+1,CmnUtils.base64ToBytes(colData[fl_col_seq[ins_col_count]]));
			} else {
				stmt_ins.setBytes(ins_col_count+1,null);
			}
		} else if (CmnUtils.isColBlob(colTypeName[tb_col_seq[ins_col_count]])){
			if (!colData[fl_col_seq[ins_col_count]].equals("")){
				stmt_ins.setBytes(ins_col_count+1,CmnUtils.base64ToBytes(colData[fl_col_seq[ins_col_count]]));
			} else {
				stmt_ins.setBlob(ins_col_count+1,null,0);
			}
		} else if (CmnUtils.isColClob(colTypeName[tb_col_seq[ins_col_count]])){
			if (!colData[fl_col_seq[ins_col_count]].equals("")){
				stmt_ins.setString(ins_col_count+1,colData[fl_col_seq[ins_col_count]]);
			} else {
				stmt_ins.setClob(ins_col_count+1,null,0);
			}
		} else {
			throw new Exception("J̃f[^^ΏۊOłB[" + colTypeName[tb_col_seq[ins_col_count]] + "]");
		}
	}

	protected void disconnect() throws Exception{

		try {
			CmnUtils.debugPrint("Start disconnect database");
			conn.close();
			CmnUtils.debugPrint("End disconnect database");
			
		}
		catch (SQLException e) {
			throw e;
		}
		catch (Exception e){
			throw e;
		}
		finally{
			if(conn != null){
				conn.close();
				conn = null;
			}
		}
	}

}

