/*
 * Decompiled with CFR 0.152.
 */
package com.rapide_act;

import com.rapide_act.CmnUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

public class CmnProps {
    protected String database = null;
    protected static final int DB_TYPE_ORACLE = 0;
    protected static final int DB_TYPE_SQLSERVER = 1;
    protected static final int DB_TYPE_MYSQL = 2;
    protected static final int DB_TYPE_DB2 = 3;
    protected static final int DB_TYPE_POSTGRESQL = 4;
    protected static final int DB_TYPE_HIRDB = 5;
    protected static final int DB_TYPE_UNKNOWN = -1;
    protected static final String[] DB_TYPE_NAME = new String[]{"ORACLE", "SQLSERVER", "MYSQL", "DB2", "POSTGRESQL", "HIRDB"};
    protected static final String[] DB_SQL_QUOTEDS = new String[]{"\"", "[", "`", "\"", "\"", "\""};
    protected static final String[] DB_SQL_QUOTEDE = new String[]{"\"", "]", "`", "\"", "\"", "\""};
    protected static final String[] SQL_TERMINATOR = new String[]{";" + System.getProperty("line.separator"), System.getProperty("line.separator") + "GO" + System.getProperty("line.separator"), ";" + System.getProperty("line.separator"), ";" + System.getProperty("line.separator"), ";" + System.getProperty("line.separator"), ";" + System.getProperty("line.separator")};
    protected static final String[] SQL_TERMINATOR2 = new String[]{";", System.getProperty("line.separator") + "GO", ";", ";", ";", ";"};
    protected static final String[] SQL_PREFIX = new String[]{"@", ":r ", "source ", "", "", ""};
    protected static final String[] SQL_COMMENT_MARK = new String[]{"--", "--", "--", "--", "--", "--"};
    protected static final String[] DROP_OPTION = new String[]{" CASCADE CONSTRAINT PURGE", "", "", "", "", ""};
    protected static final int MASK_PTN_ALL = 0;
    protected static final int MASK_PTN_ALT = 1;
    protected static final int MASK_PTN_EDGE = 2;
    protected static final int D_USER = 0;
    protected static final int D_PASS = 1;
    protected static final int D_URL = 2;
    protected static final int D_DRIVER = 3;
    protected static final int D_OUTPUT = 4;
    protected static final int D_INPUT = 5;
    protected static final int D_LINESEP = 6;
    protected static final int D_INLINESEP = 7;
    protected static final int D_FILENCODE = 8;
    protected static final int D_NULLMARK = 9;
    protected static final int D_DELIMITER = 10;
    protected static final int D_TBLSQL = 11;
    protected static final int D_TBLKEYSQL = 12;
    protected static final int D_ORDER = 13;
    protected static final int D_QUOTATION = 14;
    protected static final int D_BATCOUNT = 15;
    protected static final int D_INCLTAB = 16;
    protected static final int D_EXCLTAB = 17;
    protected static final int D_INCLCOL = 18;
    protected static final int D_EXCLCOL = 19;
    protected static final int D_INCLCOLMASK = 20;
    protected static final int D_EXCLCOLMASK = 21;
    protected static final int D_SBYTEMASKCHR = 22;
    protected static final int D_DBYTEMASKCHR = 23;
    protected static final int D_MASKPTN = 24;
    protected static final int D_PROPFILE = 25;
    protected static final int D_SPCPADDING = 26;
    protected static final int D_FILEEXT = 27;
    protected static final int D_SQLQUOTEDS = 28;
    protected static final int D_SQLQUOTEDE = 29;
    protected static final int D_PHYSICAL = 30;
    protected static final int D_DROP = 31;
    protected static final int D_METAFOLDER = 32;
    protected static final int KEYS = 33;
    protected static final String[] PROP_KEY = new String[]{"us", "pw", "url", "dr", "out", "in", "ls", "ils", "fe", "nm", "dm", "ts", "tks", "od", "qt", "bc", "it", "et", "ic", "ec", "icm", "ecm", "smc", "dmc", "mp", "pf", "sp", "ext", "sqs", "sqe", "ph", "dp", "mf"};
    protected String[] prop_val = new String[33];
    protected static final String[] MASK_PTN = new String[]{"ALL", "ALT", "EDGE"};
    protected static final String DEFAULT_IN_FOLDER = "input";
    protected static final String DEFAULT_OUT_FOLDER = "output";
    protected static final String DEFAULT_PROP_FILE = "RapideAct.properties";
    protected static final int CREATE_TABLE = 0;
    protected static final int DROP_TABLE = 1;
    protected static final int TRUNCATE_TABLE = 2;
    protected static final int CREATE_PKEY = 3;
    protected static final int DROP_PKEY = 4;
    protected static final int CREATE_UKEY = 5;
    protected static final int DROP_UKEY = 6;
    protected static final int CREATE_INDEX = 7;
    protected static final int DROP_INDEX = 8;
    protected static final int CREATE_VIEW = 9;
    protected static final int DROP_VIEW = 10;
    protected static final int CREATE_PROCEDURE = 11;
    protected static final int DROP_PROCEDURE = 12;
    protected static final int CREATE_SYNONYM = 13;
    protected static final int DROP_SYNONYM = 14;
    protected static final int CREATE_SEQUENCE = 15;
    protected static final int DROP_SEQUENCE = 16;
    protected static final int CREATE_FK = 17;
    protected static final int DROP_FK = 18;
    protected static final int TYPE_TABLE = 0;
    protected static final int TYPE_INDEX = 1;
    protected static final int TYPE_VIEW = 2;
    protected static final int TYPE_PROCEDURE = 3;
    protected static final int TYPE_SEQ = 4;
    protected static final int TYPE_SYNONYM = 5;
    protected static final int TYPE_OBJ = 6;
    protected static final int TYPE_FK = 7;
    protected static final String[] WK_FILE_NAME = new String[]{"TABLEDEF", "INDEXDEF", "VIEWDEF", "PROCDEF", "SEQDEF", "SYNMDEF", "OBJDEF", "FKDEF"};
    protected static final String[] SQL_FILE_NAME = new String[]{"createTable.sql", "dropTable.sql", "truncateTable.sql", "createPrimaryKey.sql", "dropPrimaryKey.sql", "createUniqueKey.sql", "dropUniqueKey.sql", "createIndex.sql", "dropIndex.sql", "createView.sql", "dropView.sql", "createProcedure.sql", "dropProcedure.sql", "createSynonym.sql", "dropSynonym.sql", "createSequence.sql", "dropSequence.sql", "createFk.sql", "dropFk.sql"};
    protected static final String[] T_SQL_ARRAY = new String[]{"select  table_name  from user_tables  order by table_name", "select  name as table_name  from sys.tables  order by name", "select  table_name  from information_schema.tables  where table_type = 'BASE TABLE' and table_schema = database()  order by table_name", "select  tabname  from syscat.tables  where tabschema = current_schema and ownertype = 'U' and type = 'T'  order by tabname", "select  table_name  from information_schema.tables  where table_type = 'BASE TABLE' and table_schema = current_schema()  order by table_name", "select  table_name  from master.sql_tables  where table_type = 'BASE TABLE' and table_schema=current_user  order by table_name"};
    protected static final String[] TK_SQL_ARRAY = new String[]{"select a.table_name,d.column_name  from user_tables a, (select b.table_name,    c.column_name,    c.position   from user_constraints b,        user_cons_columns c   where b.constraint_type = 'P' and         b.table_name = c.table_name and         b.constraint_name = c.constraint_name   ) d where a.table_name = d.table_name(+) order by a.table_name, d.position", "select  a.name as table_name,  d.name as col_name from sys.tables as a left outer join sys.key_constraints as b on a.object_id = b.parent_object_id  and b.type = 'PK' left outer join sys.index_columns as c on b.parent_object_id = c.object_id  and b.unique_index_id = c.index_id left outer join sys.columns as d on c.object_id = d.object_id  and c.column_id = d.column_id order by a.name,c.key_ordinal", "select  a.table_name,  b.column_name  from  (  select  table_schema,  table_name  from  information_schema.tables  where table_type = 'BASE TABLE' and table_schema = database() ) a  left outer join information_schema.key_column_usage b  on a.table_schema = b.table_schema   and a.table_name = b.table_name   and b.constraint_name = 'PRIMARY'  order by   a.table_name,b.ordinal_position", "select a.tabname, b.colname from (  select    tabschema,    tabname   from    syscat.tables  where    tabschema = current_schema    and ownertype = 'U'    and type = 'T'  ) a  left outer join   (  select    c.tabschema,    c.tabname,    c.colname,    c.colseq  from    syscat.keycoluse c,    syscat.tabconst d  where    c.tabschema = current_schema    and c.tabschema = d.tabschema    and c.constname = d.constname    and d.type = 'P'  group by c.tabschema,c.tabname,c.colname,c.colseq  ) b  on a.tabschema = b.tabschema and a.tabname = b.tabname order by a.tabname,b.colseq", "select  a.table_name,  b.column_name  from  (  select  table_schema,  table_name  from  information_schema.tables a where table_type = 'BASE TABLE' and table_schema = current_schema() ) a  left outer join  (\tselect\t\tb1.table_schema,\t\tb1.table_name,\t\tb2.column_name,\t\tb2.ordinal_position\tfrom\t\tinformation_schema.table_constraints b1,\t\tinformation_schema.key_column_usage b2\twhere\t    b1.table_schema = current_schema() and\t\tb1.table_catalog = current_database() and\t\tb1.constraint_type = 'PRIMARY KEY' and\t\tb1.table_catalog = b2.table_catalog and\t\tb1.table_schema = b2.table_schema and\t\tb1.table_name = b2.table_name and\t\tb1.constraint_name = b2.constraint_name ) b on a.table_schema = b.table_schema   and a.table_name = b.table_name  order by   a.table_name,b.ordinal_position", "select a.table_name,  b.column_name from ( select  a1.table_name from  master.sql_tables a1 where  a1.table_schema=current_user and  a1.table_type='BASE TABLE' ) a left outer join ( select  c.table_name,  d.column_name,  d.column_id from  master.sql_tables c,  master.sql_columns d where  c.table_schema=current_user and  c.table_type='BASE TABLE' and  c.table_schema=d.table_schema and  c.table_name=d.table_name and  d.cluster_key = 'Y' group by  c.table_name,  d.column_name,  d.column_id ) b on  a.table_name=b.table_name order by  a.table_name,  b.column_id"};
    protected static final String[][] meta_sql = new String[][]{{"select a.table_name as table_name,replace(replace(b.comments, chr(13), ''), chr(10), '') as table_comments,c.column_name as column_name, replace(replace(d.comments, chr(13), ''), chr(10), '') as column_comments, decode(c.data_type, 'TIMESTAMP(6)', 'TIMESTAMP',c.data_type) as data_type, c.data_length as data_length,c.data_precision as data_precision,c.data_scale as data_scale,decode(c.nullable, 'N', '\u25cb', null) as nullable,c.data_default as data_default from user_tables a inner join user_tab_comments b on a.table_name = b.table_name inner join user_tab_columns c on a.table_name = c.table_name inner join user_col_comments d on c.table_name = d.table_name  and c.column_name = d.column_name order by a.table_name,c.column_id", "select  a.table_name, a.index_name, a.index_type, c.constraint_type, b.column_name, b.column_position  from user_indexes a, user_ind_columns b, user_constraints c  where  a.table_name = b.table_name and  a.index_name = b.index_name and  a.table_name = c.table_name(+) and  a.index_name = c.constraint_name(+)  order by a.table_name, a.index_name, b.column_position", "select  a.view_name,  replace(replace(c.comments, chr(13), ''), chr(10), '') as comments  from user_views a,  user_tab_comments c  where  a.view_name = c.table_name(+)  order by a.view_name", "select  object_name,  object_type from user_objects where object_type in('PACKAGE BODY','PROCEDURE','FUNCTION','TRIGGER','TYPE') group by object_name,object_type order by object_name,object_type", "select   sequence_name,  to_char(min_value) as min_value,  to_char(max_value) as max_value,  to_char(increment_by) as increment_by,  cycle_flag,  order_flag,  to_char(cache_size) as cache_size,  to_char(last_number) as last_number  from user_sequences  order by sequence_name", "select   synonym_name,  table_owner,  table_name,  db_link from user_synonyms order by synonym_name,table_owner,table_name", "select  a.table_name, a.object_name, a.object_type, a.pct_free, a.pct_used, a.ini_trans, a.freelists, a.freelist_groups, a.buffer_pool, a.tablespace_name,  a.logging,  b.bytes from (select  table_name, table_name as object_name, 'TABLE' as object_type, pct_free, pct_used, ini_trans, freelists, freelist_groups, buffer_pool, tablespace_name,  logging from  user_tables  union select  table_name, index_name as object_name, 'INDEX' as object_type, pct_free, null as pct_used, ini_trans, freelists, freelist_groups, buffer_pool, tablespace_name,  logging  from  user_indexes ) a, (select  segment_name, segment_type, bytes  from  user_segments ) b  where a.object_name = b.segment_name  and a.object_type = b.segment_type  order by a.table_name, a.object_name", "select distinct  a.table_name as table_name,  a.constraint_name as constraint_name,  b.column_name as column_name,  b.position as position, c.table_name as r_table_name,  d.column_name as r_column_name,  d.position as r_position  from    user_constraints a,    user_cons_columns b,   user_constraints c,    user_cons_columns d  where    a.constraint_type = 'R'   and a.owner = b.owner   and a.table_name = b.table_name   and a.constraint_name = b.constraint_name   and c.constraint_type in('P','U')   and c.owner = b.owner   and c.table_name = d.table_name   and c.constraint_name = d.constraint_name   and a.r_owner = c.owner   and a.r_constraint_name = c.constraint_name order by   a.table_name,a.constraint_name,b.position,d.position"}, {"select a.name    as table_name, replace(replace(cast(b.value as varchar(4000)), char(13), ''), char(10), '') as table_comments, c.name    as column_name, replace(replace(cast(d.value as varchar(4000)), char(13), ''), char(10), '') as column_comments, e.name as data_type, c.max_length as data_length, c.precision as data_precision, c.scale as data_scale, case c.is_nullable  when '0' then '\u3007'  else null end as nullable,g.definition as data_default from sys.tables as a left outer join sys.extended_properties as b on a.object_id = b.major_id and b.minor_id = 0 inner join sys.columns as c on a.object_id = c.object_id left outer join sys.extended_properties as d on a.object_id = d.major_id and c.column_id = d.minor_id inner join sys.types as e on c.system_type_id = e.system_type_id and c.user_type_id = e.user_type_id left outer join sys.sysconstraints f on c.object_id = f.id and c.column_id = f.colid and (f.status & 2069) = 2069 left outer join sys.default_constraints g on f.constid = g.object_id and a.schema_id = g.schema_id order by a.name,c.column_id ", "select d.name as table_name, a.name as index_name, a.type as index_type, case a.is_unique   when 1 then     case a.is_primary_key       when 1 then 'P'         else             case a.is_unique_constraint                 when 1 then 'U'                 else ''             end     end   else '' end as constraint_type, c.name as column_name, b.key_ordinal as column_position from   sys.indexes as a   inner join sys.index_columns as b       on a.object_id = b.object_id and a.index_id = b.index_id   inner join sys.columns as c       on c.column_id = b.column_id          and c.object_id = b.object_id   inner join sys.objects as d       on a.object_id = d.object_id and d.type = 'U' order by d.name, a.name,b.key_ordinal", "select  a.name as view_name,  replace(replace(cast(b.value as varchar(4000)), char(13), ''), char(10), '') as comments from  sys.views a  left outer join sys.extended_properties as b  on a.object_id = b.major_id and b.minor_id = 0 order by  a.name", "select  name as object_name, 'PROCEDURE' as object_type from sys.procedures union select  name as object_name, 'FUNCTION' as object_type from sys.objects where type in('FN', 'FS', 'FT', 'IF', 'TF')  union select  name as object_name, 'TRIGGER' as object_type from sys.triggers  order by object_name,object_type ", "select   name as sequence_name,  cast(minimum_value as varchar(20)) as min_value,  cast(maximum_value as varchar(20)) as max_value,  cast(increment as varchar(20)) as increment_by,  is_cycling as cycle_flag,  is_cached as order_flag,  cast(cache_size as varchar(20)) as cache_size,  cast(start_value as varchar(20)) as last_number  from sys.sequences  order by name", "select  a.name as synonym_name, b.name as table_owner, base_object_name as table_name, '' as db_link from sys.synonyms a  inner join sys.schemas as b  on a.schema_id = b.schema_id order by synonym_name,table_owner,table_name", "", "select distinct  c.name as table_name,  a.name as constraint_name,  d.name as column_name,  b.constraint_column_id as position,  e.name as r_table_name,  f.name as r_column_name , f.column_id as r_position from sys.foreign_keys as a  inner join sys.foreign_key_columns as b      on a.object_id = b.constraint_object_id  inner join sys.tables as c      on b.parent_object_id = c.object_id  inner join sys.columns as d      on b.parent_object_id = d.object_id and          b.parent_column_id = d.column_id  inner join sys.tables as e      on b.referenced_object_id = e.object_id  inner join sys.columns as f      on b.referenced_object_id = f.object_id and          b.referenced_column_id = f.column_id  inner join sys.key_constraints as g      on a.referenced_object_id = g.parent_object_id order by table_name,constraint_name, position"}, {"select  a.table_name, replace(replace(a.table_comment, char(13), ''), char(10), '') as table_comments,  b.column_name, replace(replace(b.column_comment, char(13), ''), char(10), '') as column_comment,  b.column_type, b.character_maximum_length as data_precision, b.numeric_precision as data_precision, b.numeric_scale as data_scale, case b.is_nullable  when 'NO' then '\u3007'  else null  end as nullable, column_default as data_default from  information_schema.tables a, information_schema.columns b where  a.table_schema = database() and a.table_type = 'BASE TABLE' and a.table_schema = b.table_schema  and a.table_name = b.table_name order by a.table_name,b.ordinal_position", "select   a.table_name,   b.constraint_name as index_name,  '' as index_type,   case b.constraint_type     when 'PRIMARY KEY' then 'P'     when 'UNIQUE' then 'U'   end as constraint_type,  c.column_name,  c.ordinal_position as column_position  from   information_schema.tables a,   information_schema.table_constraints b,   information_schema.key_column_usage c  where   a.table_schema = database()   and a.table_type = 'BASE TABLE'   and a.table_schema = b.table_schema   and a.table_name = b.table_name   and b.table_schema = c.table_schema   and b.table_name = c.table_name   and b.constraint_name = c.constraint_name   and b.constraint_type in('PRIMARY KEY','UNIQUE')  union select  a.table_name,  a.index_name,  b.index_type as index_type,   '' as constraint_type,  a.column_name,  a.seq_in_index as column_position  from  information_schema.statistics a,    information_schema.statistics b  where  a.table_schema = database()  and a.table_schema = b.table_schema  and a.table_name = b.table_name  and a.index_name = b.index_name  and a.non_unique = 1  order by table_name,index_name,column_position", "select  a.table_name as view_name,  '' as comments from  information_schema.views a  where table_schema = database() order by  a.table_name", "select  routine_name as object_name,  routine_type as object_type,  '' as action_timing,  '' as event_action,  '' as event_object  from  information_schema.routines  where routine_schema = database() and (routine_type = 'PROCEDURE' or routine_type = 'FUNCTION')  union select  trigger_name as object_name,  'TRIGGER' as object_type,  action_timing as action_timing,  event_manipulation as event_action,  event_object_table as event_object  from  information_schema.triggers  where trigger_schema = database() order by object_name,object_type ", "", "", "", "select distinct   b.table_name,   b.constraint_name,   b.column_name,   b.ordinal_position as position,   b.referenced_table_name as r_table_name,   b.referenced_column_name as r_column_name,   c.ordinal_position  as r_position  from   information_schema.referential_constraints a,   information_schema.key_column_usage b,   information_schema.columns c  where    a.constraint_schema = database()   and a.constraint_schema = b.constraint_schema   and a.constraint_name = b.constraint_name   and b.referenced_table_name = c.table_name   and b.referenced_column_name = c.column_name "}};
    protected static String[] sql_view_text = new String[]{"select text from user_views where view_name = ?", "select c.definition from sys.views a inner join sys.objects b on  b.object_id = a.object_id inner join sys.sql_modules c on  c.object_id = b.object_id where a.name = ?", "select view_definition from information_schema.views where table_name = ?"};
    protected static String[] sql_view_column_and_comment = new String[]{"select  b.column_name, replace(replace(d.comments, chr(13), ''), chr(10), '') as comments  from user_tab_columns b, user_col_comments d  where  b.table_name = ? and  b.table_name = d.table_name(+) and  b.column_name = d.column_name(+)  order by b.column_id", " select  b.name as column_name,  '' as comments  from  sys.objects a  inner join sys.columns b on a.object_id = b.object_id and a.name = ?  inner join sys.types c on b.system_type_id = c.system_type_id  where a.type = 'V'  and c.user_type_id <> 256  order by b.column_id", " select  column_name, replace(replace(column_comment, char(13), ''), char(10), '') as column_comment  from information_schema.columns  where  table_name = ?  order by ordinal_position"};
    protected static String[] sql_proc = new String[]{"select text from user_source where type = ? and name = ? order by line", "select d.definition from  (select a.name,'PROCEDURE' as type,c.definition from sys.procedures a inner join sys.objects b on b.object_id = a.object_id inner join sys.sql_modules c on  c.object_id = b.object_id union select  a.name,'FUNCTION' as type,c.definition from sys.objects a inner join sys.objects b on  b.object_id = a.object_id inner join sys.sql_modules c on  c.object_id = b.object_id and a.type in('FN', 'FS', 'FT', 'IF', 'TF') union select a.name,'TRIGGER' as type,c.definition from sys.triggers a inner join sys.objects b on  b.object_id = a.object_id inner join sys.sql_modules c on  c.object_id = b.object_id) d where d.type = ? and d.name = ?", "select a.definition from ( select  routine_name as object_name,  routine_type as object_type,  routine_definition as definition from  information_schema.routines where  routine_schema = database() union select  trigger_name as object_name,  'TRIGGER' as object_type,  action_statement as definition from  information_schema.triggers where  trigger_schema = database() ) a where  a.object_type = ?  and a.object_name = ? "};
    protected String user = null;
    protected String pass = null;
    protected String url = null;
    protected String driver = null;
    protected String outFolder = null;
    protected String inFolder = null;
    protected String lineSeparator = System.getProperty("line.separator");
    protected String inColLineSeparator = System.getProperty("line.separator");
    protected String fileEncoding = System.getProperty("file.encoding");
    protected String nullMark = "";
    protected String delimiter = "\t";
    protected String fileExtension = "tsv";
    protected boolean isSpcPadding = false;
    protected String sqlQuotedS = null;
    protected String sqlQuotedE = null;
    protected String tSql = null;
    protected String tkSql = null;
    protected boolean isOrder = false;
    protected boolean isQuotation = true;
    protected boolean isPhysical = false;
    protected boolean isDrop = false;
    protected int batchCount = 1000;
    protected String inclTables = null;
    protected String exclTables = null;
    protected String inclCols = null;
    protected String exclCols = null;
    protected String inclColsMask = null;
    protected String exclColsMask = null;
    protected char singleByteMaskChar = (char)42;
    protected char doubleByteMaskChar = (char)9632;
    protected String maskPattern = "ALT";
    protected String metaFolder = "DDL";
    protected String[] inclTablesArray = null;
    protected String[] exclTablesArray = null;
    protected String[] inclColsArray = null;
    protected String[] exclColsArray = null;
    protected String[] inclColsMaskArray = null;
    protected String[] exclColsMaskArray = null;
    protected boolean isInclTables = false;
    protected boolean isExclTables = false;
    protected boolean isInclCols = false;
    protected boolean isExclCols = false;
    protected boolean isMask = false;
    protected boolean isInclColsMask = false;
    protected boolean isExclColsMask = false;
    protected int dbType = -1;

    protected void getProperties(String string) throws Exception {
        BufferedReader bufferedReader = null;
        Properties properties = null;
        try {
            properties = new Properties();
            bufferedReader = new BufferedReader(new InputStreamReader(CmnProps.class.getClassLoader().getResourceAsStream(string), "UTF-8"));
            properties.load(bufferedReader);
            for (int i = 0; i < 33; ++i) {
                this.prop_val[i] = properties.getProperty(this.database + "." + PROP_KEY[i]);
            }
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (NullPointerException nullPointerException) {
            throw new Exception("\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002[" + string + "]");
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
                bufferedReader = null;
            }
        }
    }

    CmnProps() {
    }

    protected void setProperty(String string) throws Exception {
        int n;
        this.database = string;
        if (this.database != null) {
            if (!CmnUtils.isEmpty(this.prop_val[25])) {
                this.getProperties(System.getProperty(this.prop_val[25]));
            } else {
                this.getProperties(DEFAULT_PROP_FILE);
            }
        }
        for (n = 0; n < 33; ++n) {
            if (System.getProperty(PROP_KEY[n]) != null) {
                this.prop_val[n] = System.getProperty(PROP_KEY[n]);
            }
            CmnUtils.debugPrint(PROP_KEY[n] + "=" + this.prop_val[n]);
        }
        if (!CmnUtils.isEmpty(this.prop_val[0])) {
            this.user = this.prop_val[0];
        }
        if (!CmnUtils.isEmpty(this.prop_val[1])) {
            this.pass = this.prop_val[1];
        }
        if (!CmnUtils.isEmpty(this.prop_val[2])) {
            this.url = this.prop_val[2];
        }
        if (!CmnUtils.isEmpty(this.prop_val[3])) {
            this.driver = this.prop_val[3];
        }
        if (!CmnUtils.isEmpty(this.prop_val[4])) {
            this.outFolder = this.prop_val[4];
        }
        if (!CmnUtils.isEmpty(this.prop_val[5])) {
            this.inFolder = this.prop_val[5];
        }
        if (!CmnUtils.isEmpty(this.prop_val[6])) {
            this.lineSeparator = CmnUtils.getLineSeparator(this.prop_val[6]);
        }
        if (!CmnUtils.isEmpty(this.prop_val[7])) {
            this.inColLineSeparator = CmnUtils.getLineSeparator(this.prop_val[7]);
        }
        if (!CmnUtils.isEmpty(this.prop_val[8])) {
            this.fileEncoding = this.prop_val[8];
        }
        if (!CmnUtils.isEmpty(this.prop_val[9])) {
            this.nullMark = this.prop_val[9];
        }
        if (!CmnUtils.isEmpty(this.prop_val[10])) {
            this.delimiter = CmnUtils.getDelimiter(this.prop_val[10]);
        }
        if (!CmnUtils.isEmpty(this.prop_val[11])) {
            this.tSql = this.prop_val[11];
        }
        if (!CmnUtils.isEmpty(this.prop_val[12])) {
            this.tkSql = this.prop_val[12];
        }
        if (!CmnUtils.isEmpty(this.prop_val[13]) && this.prop_val[13].toUpperCase().equals("Y")) {
            this.isOrder = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[14]) && this.prop_val[14].toUpperCase().equals("N")) {
            this.isQuotation = false;
        }
        if (!CmnUtils.isEmpty(this.prop_val[30]) && this.prop_val[30].toUpperCase().equals("Y")) {
            this.isPhysical = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[31]) && this.prop_val[31].toUpperCase().equals("Y")) {
            this.isDrop = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[15]) && CmnUtils.isNumeric(this.prop_val[15])) {
            this.batchCount = Integer.parseInt(this.prop_val[15]);
        }
        if (!CmnUtils.isEmpty(this.prop_val[16])) {
            this.isInclTables = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[17])) {
            this.isExclTables = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[18])) {
            this.isInclCols = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[19])) {
            this.isExclCols = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[20])) {
            this.isInclColsMask = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[21])) {
            this.isExclColsMask = true;
        }
        if (this.isInclColsMask || this.isExclColsMask) {
            this.isMask = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[16])) {
            this.inclTables = this.prop_val[16].toUpperCase();
        }
        if (!CmnUtils.isEmpty(this.prop_val[17])) {
            this.exclTables = this.prop_val[17].toUpperCase();
        }
        if (!CmnUtils.isEmpty(this.prop_val[18])) {
            this.inclCols = this.prop_val[18].toUpperCase();
        }
        if (!CmnUtils.isEmpty(this.prop_val[19])) {
            this.exclCols = this.prop_val[19].toUpperCase();
        }
        if (!CmnUtils.isEmpty(this.prop_val[20])) {
            this.inclColsMask = this.prop_val[20].toUpperCase();
        }
        if (!CmnUtils.isEmpty(this.prop_val[21])) {
            this.exclColsMask = this.prop_val[21].toUpperCase();
        }
        if (!CmnUtils.isEmpty(this.prop_val[16])) {
            this.inclTablesArray = CmnUtils.splitCsv(this.prop_val[16].toUpperCase());
        }
        if (!CmnUtils.isEmpty(this.prop_val[17])) {
            this.exclTablesArray = CmnUtils.splitCsv(this.prop_val[17].toUpperCase());
        }
        if (!CmnUtils.isEmpty(this.prop_val[18])) {
            this.inclColsArray = CmnUtils.splitCsv(this.prop_val[18].toUpperCase());
        }
        if (!CmnUtils.isEmpty(this.prop_val[19])) {
            this.exclColsArray = CmnUtils.splitCsv(this.prop_val[19].toUpperCase());
        }
        if (!CmnUtils.isEmpty(this.prop_val[20])) {
            this.inclColsMaskArray = CmnUtils.splitCsv(this.prop_val[20].toUpperCase());
        }
        if (!CmnUtils.isEmpty(this.prop_val[21])) {
            this.exclColsMaskArray = CmnUtils.splitCsv(this.prop_val[21].toUpperCase());
        }
        if (!CmnUtils.isEmpty(this.prop_val[22])) {
            this.singleByteMaskChar = this.prop_val[22].charAt(0);
        }
        if (!CmnUtils.isEmpty(this.prop_val[23])) {
            this.doubleByteMaskChar = this.prop_val[23].charAt(0);
        }
        if (!CmnUtils.isEmpty(this.prop_val[24])) {
            this.maskPattern = this.prop_val[24];
        }
        if (!CmnUtils.isEmpty(this.prop_val[32])) {
            this.metaFolder = this.prop_val[32];
        }
        if (!CmnUtils.isEmpty(this.prop_val[26]) && this.prop_val[26].toUpperCase().equals("Y")) {
            this.isSpcPadding = true;
        }
        if (!CmnUtils.isEmpty(this.prop_val[27])) {
            this.fileExtension = this.prop_val[27];
        }
        if (CmnUtils.isEmpty(this.user)) {
            throw new Exception("us(\u30e6\u30fc\u30b6ID)\u304c\u672a\u6307\u5b9a\u3067\u3059\u3002");
        }
        if (CmnUtils.isEmpty(this.pass)) {
            throw new Exception("pw(\u30d1\u30b9\u30ef\u30fc\u30c9)\u304c\u672a\u6307\u5b9a\u3067\u3059\u3002");
        }
        if (CmnUtils.isEmpty(this.url)) {
            throw new Exception("url(\u63a5\u7d9a\u60c5\u5831)\u304c\u672a\u6307\u5b9a\u3067\u3059\u3002");
        }
        if (CmnUtils.isEmpty(this.driver)) {
            throw new Exception("dr(\u30c9\u30e9\u30a4\u30d0)\u304c\u672a\u6307\u5b9a\u3067\u3059\u3002");
        }
        for (n = 0; n < DB_TYPE_NAME.length; ++n) {
            if (!this.url.toUpperCase().contains(DB_TYPE_NAME[n])) continue;
            this.dbType = n;
            break;
        }
        if (this.dbType != -1) {
            this.tSql = !CmnUtils.isEmpty(this.prop_val[11]) ? this.prop_val[11] : T_SQL_ARRAY[this.dbType];
            this.tkSql = !CmnUtils.isEmpty(this.prop_val[12]) ? this.prop_val[12] : TK_SQL_ARRAY[this.dbType];
            this.sqlQuotedS = !CmnUtils.isEmpty(this.prop_val[28]) ? this.prop_val[28] : DB_SQL_QUOTEDS[this.dbType];
            this.sqlQuotedE = !CmnUtils.isEmpty(this.prop_val[29]) ? this.prop_val[29] : DB_SQL_QUOTEDE[this.dbType];
        } else {
            throw new Exception("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u88fd\u54c1\u304c\u8b58\u5225\u3067\u304d\u307e\u305b\u3093\u3002[" + this.url + "]");
        }
        if (this.database != null) {
            CmnUtils.infoPrint("-->\u5bfe\u8c61\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9='" + this.database.toUpperCase() + "'");
        }
        if (!CmnUtils.isEmpty(this.prop_val[27])) {
            CmnUtils.infoPrint("-->\u30d5\u30a1\u30a4\u30eb\u62e1\u5f35\u5b50='" + this.prop_val[27] + "'");
        }
        if (!CmnUtils.isEmpty(this.prop_val[10])) {
            CmnUtils.infoPrint("-->\u533a\u5207\u308a\u6587\u5b57='" + this.prop_val[10] + "'");
        }
        if (!CmnUtils.isEmpty(this.prop_val[6])) {
            CmnUtils.infoPrint("-->\u6539\u884c\u30b3\u30fc\u30c9='" + this.prop_val[6] + "'");
        }
        if (!CmnUtils.isEmpty(this.prop_val[7])) {
            CmnUtils.infoPrint("-->\u30ab\u30e9\u30e0\u5185\u6539\u884c\u30b3\u30fc\u30c9='" + this.prop_val[7] + "'");
        }
        if (!CmnUtils.isEmpty(this.prop_val[8])) {
            CmnUtils.infoPrint("-->\u6587\u5b57\u30b3\u30fc\u30c9='" + this.prop_val[8] + "'");
        }
        if (!CmnUtils.isEmpty(this.prop_val[14])) {
            CmnUtils.infoPrint("-->\u5f15\u7528\u53e5=" + CmnUtils.getYesNo(this.isQuotation));
        }
        if (!CmnUtils.isEmpty(this.prop_val[28]) && !CmnUtils.isEmpty(this.prop_val[29])) {
            CmnUtils.infoPrint("-->SQL\u5f15\u7528\u7b26='" + this.sqlQuotedS + "' '" + this.sqlQuotedE + "'");
        }
        if (!CmnUtils.isEmpty(this.prop_val[13])) {
            CmnUtils.infoPrint("-->\u30bd\u30fc\u30c8=" + CmnUtils.getYesNo(this.isOrder));
        }
        if (!CmnUtils.isEmpty(this.prop_val[15])) {
            CmnUtils.infoPrint("-->\u30d0\u30c3\u30c1\u51e6\u7406\u6570=" + this.batchCount);
        }
        if (this.isSpcPadding) {
            CmnUtils.infoPrint("-->\u7a7a\u767d\u57cb\u3081=" + CmnUtils.getYesNo(this.isSpcPadding));
        }
        if (this.isInclTables) {
            CmnUtils.infoPrint("-->\u5bfe\u8c61\u30c6\u30fc\u30d6\u30eb='" + this.inclTables.toUpperCase() + "'");
        }
        if (this.isExclTables) {
            CmnUtils.infoPrint("-->\u9664\u5916\u30c6\u30fc\u30d6\u30eb='" + this.exclTables.toUpperCase() + "'");
        }
        if (this.isInclCols) {
            CmnUtils.infoPrint("-->\u5bfe\u8c61\u30ab\u30e9\u30e0='" + this.inclCols.toUpperCase() + "'");
        }
        if (this.isExclCols) {
            CmnUtils.infoPrint("-->\u9664\u5916\u30ab\u30e9\u30e0='" + this.exclCols.toUpperCase() + "'");
        }
        if (this.isMask) {
            CmnUtils.infoPrint("-->\u30de\u30b9\u30ad\u30f3\u30b0=" + CmnUtils.getYesNo(this.isMask));
            CmnUtils.infoPrint("-->\u30de\u30b9\u30af\u30ad\u30f3\u30b0\u30d1\u30bf\u30fc\u30f3=" + this.maskPattern.toUpperCase());
            CmnUtils.infoPrint("-->\u534a\u89d2\u30de\u30b9\u30af\u6587\u5b57='" + this.singleByteMaskChar + "'");
            CmnUtils.infoPrint("-->\u5168\u89d2\u30de\u30b9\u30af\u6587\u5b57='" + this.doubleByteMaskChar + "'");
            if (this.isInclColsMask) {
                CmnUtils.infoPrint("-->\u30de\u30b9\u30af\u5bfe\u8c61\u30ab\u30e9\u30e0='" + this.inclColsMask.toUpperCase() + "'");
            }
            if (this.isExclColsMask) {
                CmnUtils.infoPrint("-->\u30de\u30b9\u30af\u9664\u5916\u30ab\u30e9\u30e0='" + this.exclColsMask.toUpperCase() + "'");
            }
        }
    }
}

