/*
 * Decompiled with CFR 0.152.
 */
package razgriz.eclipse2jdee.popup.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import razgriz.common.util.StringUtil;

public class GenerateJDEEProjectFileAction
implements IObjectActionDelegate {
    private static final String FILENAME_PRJ_EL = "prj.el";
    IWorkbenchSite site;
    ISelection selection;
    static /* synthetic */ Class class$0;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.site = targetPart.getSite();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        action.setEnabled(!selection.isEmpty());
    }

    public void run(IAction action) {
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)this.selection;
        Iterator ite = sel.iterator();
        while (ite.hasNext()) {
            Object obj = ite.next();
            if (!(obj instanceof IAdaptable)) continue;
            IAdaptable adaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.jdt.core.IJavaProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IJavaProject javaproj = (IJavaProject)adaptable.getAdapter((Class)clazz);
            try {
                String[] cpath = this.getClasspathStrings(javaproj, true);
                String prjelstr = this.getPrjElString(cpath);
                IProject proj = javaproj.getProject();
                IFile prjelfile = proj.getFile(FILENAME_PRJ_EL);
                if (prjelfile.exists()) {
                    prjelfile.setContents((InputStream)new ByteArrayInputStream(prjelstr.getBytes()), true, false, null);
                    continue;
                }
                prjelfile.create((InputStream)new ByteArrayInputStream(prjelstr.getBytes()), true, null);
            }
            catch (CoreException e) {
                MessageDialog.openInformation((Shell)this.site.getShell(), (String)"prj.el\u751f\u6210\u30a8\u30e9\u30fc", (String)e.getMessage());
            }
        }
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        return ws.getRoot();
    }

    private String getPrjElString(String[] classpathStrs) {
        StringBuffer ret = new StringBuffer();
        ret.append("(jde-project-file-version \"1.0\")\n");
        ret.append("(jde-set-variables\n");
        ret.append(" '(jde-global-classpath (quote (");
        ret.append(StringUtils.join((Object[])StringUtil.surroundEachElement((String[])classpathStrs, (char)'\"'), (char)' '));
        ret.append(")))\n");
        ret.append(" )\n");
        return ret.toString();
    }

    private String[] getClasspathStrings(IJavaProject javaProj, boolean includeUnexportedLib) throws JavaModelException {
        ArrayList<String> ret = new ArrayList<String>();
        IClasspathEntry[] entries = javaProj.getResolvedClasspath(true);
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            switch (entry.getEntryKind()) {
                case 2: {
                    IPath cp = entry.getPath();
                    IProject pj = this.getWorkspaceRoot().getProject(cp.toString());
                    IJavaProject jp = JavaCore.create((IProject)pj);
                    ret.addAll(Arrays.asList(this.getClasspathStrings(jp, false)));
                    break;
                }
                case 3: {
                    IPath op = entry.getOutputLocation() == null ? javaProj.getOutputLocation() : entry.getOutputLocation();
                    ret.add(this.getWorkspaceRoot().findMember(op).getLocation().toString());
                    break;
                }
                case 1: {
                    if (!entry.isExported() && !includeUnexportedLib) break;
                    IPath cp = entry.getPath();
                    if (this.getWorkspaceRoot().findMember(cp) == null) {
                        ret.add(cp.toString());
                        break;
                    }
                    ret.add(this.getWorkspaceRoot().findMember(cp).getLocation().toString());
                }
            }
            ++i;
        }
        return ret.toArray(new String[ret.size()]);
    }
}

