/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Arrays;
import org.eclipse.core.runtime.Platform;

public abstract class OS {
    private static final String INSTALLED_PLATFORM;
    public static final char[] INVALID_RESOURCE_CHARACTERS;
    public static final String[] INVALID_RESOURCE_NAMES;

    static {
        char[] chars = null;
        String[] names = null;
        INSTALLED_PLATFORM = Platform.getOS();
        if (INSTALLED_PLATFORM.equals("win32")) {
            chars = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
            names = new String[]{"aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"};
        } else {
            char[] cArray = new char[4];
            cArray[0] = 92;
            cArray[1] = 47;
            cArray[2] = 58;
            chars = cArray;
        }
        INVALID_RESOURCE_CHARACTERS = chars == null ? new char[]{} : chars;
        INVALID_RESOURCE_NAMES = names == null ? new String[]{} : names;
    }

    public static boolean isNameValid(String name) {
        if (INSTALLED_PLATFORM.equals("win32")) {
            int dot = name.indexOf(46);
            String string = name = dot == -1 ? name : name.substring(0, dot);
            return Arrays.binarySearch(INVALID_RESOURCE_NAMES, name.toLowerCase()) < 0;
        }
        return true;
    }
}

