/*
 * Created on 2005/02/07
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.visitor;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import razgriz.news.NewsException;
import razgriz.news.NewsPlugin;
import razgriz.news.clipper.NewsClipperService;
import razgriz.news.model.Article;
import razgriz.news.model.ModelElement;
import razgriz.news.model.News;
import razgriz.news.model.util.ModelVisitor;

/**
 * 
 */
public class NewsClippingVisitor extends ModelVisitor {

    public NewsClippingVisitor() {
        super();
    }

    public Object caseNews(final News news) {
        Thread thread = new Thread() {
            public void run() {
                NewsClipperService service =
                    NewsPlugin.getDefault().getNewsClipperService();
                try {
                    URL url = new URL(news.getLink());
                    InputStream in = url.openStream();
                    News clipped = service.clip(in);

                    synchronized(news) {
                        List cartlist = clipped.getArticles();
                        List artlist = news.getArticles();
                        List addedlist = new ArrayList();

                        for (int i = 0; i < cartlist.size(); i++) {
                            Article cart = (Article) cartlist.get(i);

                            boolean found = false;
                            for (int j = 0; j < artlist.size(); j++) {
                                Article art = (Article) artlist.get(j);
                                if (
                                    cart.getTitle().equals(art.getTitle()) &&
                                    cart.getLink().equals(art.getLink())
                                ) {
                                    found = true;
                                    break;
                                }
                            }
                            if (!found) {
                                addedlist.add(cart);
                            }
                        }

                        news.getArticles().addAll(addedlist);
                        in.close();
                    }
                } catch (IOException e) {
                    throw new NewsException(e);  // todo:
                }

            }
        };
        thread.start();
        return news;
    }

    public boolean prune(ModelElement elem) {
        return (elem instanceof News);
    }
}
