/*
 * Created on 2005/03/03
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.visitor;

import java.util.ArrayList;
import java.util.List;

import razgriz.news.model.Article;
import razgriz.news.model.ModelElement;
import razgriz.news.model.News;
import razgriz.news.model.util.ModelVisitor;

/**
 * 
 */
public class RemoveReadArticleVisitor extends ModelVisitor {
    public RemoveReadArticleVisitor() {
        super();
    }

    public Object caseNews(News news) {
        List artlist = news.getArticles();
        List removing = new ArrayList();
        for (int i = 0; i < artlist.size(); i++) {
            Article art = (Article) artlist.get(i);
            if (art.isRead()) {
                removing.add(art);
            }
        }
        artlist.removeAll(removing);

        return news;
    }

    public boolean prune(ModelElement elem) {
        return elem instanceof News;
    }
}
