/*
 * Created on 2005/01/25
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

import razgriz.news.model.FavoriteList;
import razgriz.news.model.Group;
import razgriz.news.model.News;
import razgriz.news.model.NewsFactory;
import razgriz.news.ui.NewsUIPlugin;
import razgriz.news.ui.SharedImages;
import razgriz.news.ui.dialogs.NewsDialog;

/**
 * 
 */
public class AddNewsAction extends Action {
    public static final String ID = AddNewsAction.class.getName();

    IWorkbenchSite site;
    TreeViewer viewer;

    public AddNewsAction(
        IWorkbenchSite site, TreeViewer viewer
    ) {
        super();

        this.site = site;
        this.viewer = viewer;

        setId(ID);
        setText("j[X̒ǉ");
        setToolTipText("j[Xǉ܂");
        setImageDescriptor(
            PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(
                SharedImages.IMG_ACT_ADDNEWS
            )
        );
    }

    public void run() {
        IStructuredSelection sel = (IStructuredSelection) viewer.getSelection();

        NewsDialog input = new NewsDialog(site.getShell());
        if (input.open() == InputDialog.OK) {
            News added = NewsFactory.eINSTANCE.createNews();
            added.setTitle(input.getTitle());
            added.setLink(input.getLink());
            added.setDescription(input.getDescription());

            if (sel.size() == 0) {
                FavoriteList favlist = NewsUIPlugin.getFavoriteList();
                favlist.getFavorites().add(added);
                viewer.add(favlist, added);
            } else {
                Object obj = sel.getFirstElement();
                if (obj instanceof Group) {
                    Group parent = (Group) obj;
                    parent.getMembers().add(added);
                } else if (obj instanceof News) {
                    News news = (News) obj;
                    news.getGroup().getMembers().add(added);
                }
            }
        }
    }
}
