/*
 * Created on 2005/01/25
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.actions;

import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchSite;

import razgriz.news.model.News;
import razgriz.news.ui.dialogs.BeanEditorDialog;
import razgriz.news.ui.dialogs.NewsDialogBean;

/**
 * 
 */
public class EditNewsAction extends Action {
    public static final String ID = EditNewsAction.class.getName();

    IWorkbenchSite site;
    TreeViewer viewer;

    public EditNewsAction(
        IWorkbenchSite site, TreeViewer viewer
    ) {
        super();

        this.site = site;
        this.viewer = viewer;

        setId(ID);
        setText("j[X̕ҏW");
        setToolTipText("j[XҏW܂");
        setImageDescriptor(null);
    }

    public void run() {
        IStructuredSelection sel =
            (IStructuredSelection) viewer.getSelection();

        if (sel.size() != 1) {
            throw new IllegalArgumentException(); // todo:                    
        }

        Object obj = sel.getFirstElement();

        if (obj instanceof News) {
            try {
                News news = (News) obj;

                NewsDialogBean bean = new NewsDialogBean();
                PropertyUtils.copyProperties(bean, news);

                BeanEditorDialog dialog = new BeanEditorDialog(
                    site.getShell(),
                    "j[X̕ҏW",
                    "j[XҏWĂ",
                    bean,
                    bean,
                    bean,
                    bean
                );
                if (dialog.open() == BeanEditorDialog.OK) {
                    PropertyUtils.copyProperties(news, bean);
                }
            } catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage()); // todo:
            }
        }
    }
}
