/*
 * Created on 2005/01/25
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchSite;

import razgriz.news.model.Favorite;
import razgriz.news.model.Group;
import razgriz.news.model.News;
import razgriz.news.model.opml.Body;
import razgriz.news.model.opml.Head;
import razgriz.news.model.opml.OPML;
import razgriz.news.model.opml.OPMLFactory;
import razgriz.news.model.opml.Outline;
import razgriz.news.ui.NewsUIPlugin;

/**
 * 
 */
public class ExportOPMLAction extends Action {
    public static final String ID = ExportOPMLAction.class.getName();

    IWorkbenchSite site;
    TreeViewer viewer;

    public ExportOPMLAction(IWorkbenchSite site, TreeViewer viewer) {
        super();

        this.site = site;
        this.viewer = viewer;

        setId(ID);
        setText("OPMLGNX|[g");
        setToolTipText("OPMLCɓ肩GNX|[g܂");
        setImageDescriptor(null);
    }

    public void run() {
        FileDialog dialog = new FileDialog(
            site.getShell(),
            SWT.SAVE
        );
        String result = dialog.open();
        if (result != null) {
            URI uri = URI.createFileURI(result);
            Resource res = new ResourceSetImpl().createResource(uri);

            OPMLFactory fact = OPMLFactory.eINSTANCE;
            OPML opml = fact.createOPML();
            opml.setVersion("1.0");

            Body body = fact.createBody();
            opml.setBody(body);

            List favlist = NewsUIPlugin.getFavoriteList().getFavorites();
            List ollist = new ArrayList();
            for (int i = 0; i < favlist.size(); i++) {
                ollist.add(convert((Favorite) favlist.get(i)));
            }
            body.getOutline().addAll(ollist);

            Head head = fact.createHead();
            head.setTitle("Razgriz Favorite List");
            head.setDateCreated(new Date().toString());
            opml.setHead(head);
            
            try {
                res.getContents().add(opml);
                res.save(Collections.EMPTY_MAP);
            } catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage()); // todo:
            }
        }
    }

    public Outline convert(Favorite favorite) {
        OPMLFactory fact = OPMLFactory.eINSTANCE;
        Outline ret = fact.createOutline();

        if (favorite instanceof News) {
            News news = (News) favorite;
            ret.setType("rss");
            ret.setText(news.getTitle());
            ret.setTitle(news.getTitle());
            ret.setXmlUrl(news.getLink());
            ret.setDescription(StringUtils.defaultString(news.getDescription()));
        } else if (favorite instanceof Group) {
            Group grp = (Group) favorite;
            ret.setText(grp.getTitle());
            ret.setTitle(grp.getTitle());
            
            List members = grp.getMembers();
            List ollist = new ArrayList();
            for (int i = 0; i < members.size(); i++) {
                ollist.add(convert((Favorite) members.get(i)));
            }
            ret.getOutline().addAll(ollist);
        }

        return ret;
    }
}
