/*
 * Created on 2005/01/25
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchSite;

import razgriz.news.model.Favorite;
import razgriz.news.model.Group;
import razgriz.news.model.News;
import razgriz.news.model.NewsFactory;
import razgriz.news.model.opml.OPML;
import razgriz.news.model.opml.Outline;
import razgriz.news.ui.NewsUIPlugin;

/**
 * 
 */
public class ImportOPMLAction extends Action {
    public static final String ID = ImportOPMLAction.class.getName();

    IWorkbenchSite site;
    TreeViewer viewer;

    public ImportOPMLAction(IWorkbenchSite site, TreeViewer viewer) {
        super();

        this.site = site;
        this.viewer = viewer;

        setId(ID);
        setText("OPMLC|[g");
        setToolTipText("OPMLCɓɃC|[g܂");
        setImageDescriptor(null);
    }

    public void run() {
        FileDialog dialog = new FileDialog(
            site.getShell(),
            SWT.OPEN
        );
        String result = dialog.open();
        if (result != null) {
            URI uri = URI.createFileURI(result);
            Resource res = new ResourceSetImpl().createResource(uri);
            try {
                res.load(Collections.EMPTY_MAP);
            } catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage()); // todo:
            }
            OPML opml = (OPML) res.getContents().get(0);
            List ollist = opml.getBody().getOutline();
            List favlist = new ArrayList();
            for (int i = 0; i < ollist.size(); i++) {
                favlist.add(convert((Outline) ollist.get(i)));
            }
            
            NewsUIPlugin.getFavoriteList().getFavorites().addAll(favlist);
        }
    }

    public Favorite convert(Outline outline) {
        NewsFactory fact = NewsFactory.eINSTANCE;
        Favorite ret = null;

        List children = outline.getOutline();
        if (children.isEmpty()) {
            News news = fact.createNews();

            String title = outline.getText();
            title = StringUtils.isEmpty(title)? outline.getTitle(): title;
            news.setTitle(StringUtils.defaultString(title));

            news.setLink(
                StringUtils.defaultString(outline.getXmlUrl())
            );
            news.setDescription(
                StringUtils.defaultString(outline.getDescription())
            );
            
            ret = news;
        } else {
            Group grp = fact.createGroup();

            String title = outline.getText();
            title = StringUtils.isEmpty(title)? outline.getTitle(): title;
            grp.setTitle(StringUtils.defaultString(title));

            grp.setDescription(
                StringUtils.defaultString(outline.getDescription())
            );

            List members = grp.getMembers();
            for (int i = 0; i < children.size(); i++) {
                Outline child = (Outline) children.get(i);
                members.add(convert(child));
            }
            
            ret = grp;
        }

        return ret;
    }
}
