/*
 * Created on 2004/09/25
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.ui.perspectives;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

import razgriz.news.ui.views.ArticleListView;
import razgriz.news.ui.views.FavoriteListView;

/**
 * 
 */
public class NewsPerspective implements IPerspectiveFactory {
    public static final String ID = NewsPerspective.class.getName();

    /**
     * 
     */
    public NewsPerspective() {
        super();
    }

    public void createInitialLayout(IPageLayout layout) {
        layout.setEditorAreaVisible(true);
        String editorAreaStr = layout.getEditorArea();

        layout.addView(
            FavoriteListView.ID, IPageLayout.LEFT, 0.25f, editorAreaStr
        );

        IFolderLayout top = layout.createFolder(
            "top", IPageLayout.TOP, 0.33f, editorAreaStr
        );
        top.addPlaceholder(ArticleListView.ID);
        top.addPlaceholder(ArticleListView.ID + ":*");

        layout.addPerspectiveShortcut(ID);
        layout.addShowViewShortcut(FavoriteListView.ID);
    }

}
