/**
 * <copyright>
 * </copyright>
 *
 * $Id: RSS10FactoryImpl.java,v 1.1 2005/02/26 07:21:47 mkamo Exp $
 */
package razgriz.news.model.rss10.impl;

import java.util.Date;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import razgriz.common.text.DateFormatUtil;
import razgriz.news.model.rss10.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class RSS10FactoryImpl extends EFactoryImpl implements RSS10Factory {
    /**
     * Creates and instance of the factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public RSS10FactoryImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case RSS10Package.RDF: return createRDF();
            case RSS10Package.CHANNEL: return createChannel();
            case RSS10Package.ITEM: return createItem();
            case RSS10Package.LI: return createLI();
            case RSS10Package.SEQ: return createSeq();
            case RSS10Package.ITEMS: return createItems();
            case RSS10Package.IMAGE: return createImage();
            default:
                throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
        }
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case RSS10Package.RSS10_DATE:
                return createRSS10DateFromString(eDataType, initialValue);
            default:
                throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
        }
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case RSS10Package.RSS10_DATE:
                return convertRSS10DateToString(eDataType, instanceValue);
            default:
                throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
        }
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public RDF createRDF() {
        RDFImpl rdf = new RDFImpl();
        return rdf;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Channel createChannel() {
        ChannelImpl channel = new ChannelImpl();
        return channel;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Item createItem() {
        ItemImpl item = new ItemImpl();
        return item;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public LI createLI() {
        LIImpl li = new LIImpl();
        return li;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Seq createSeq() {
        SeqImpl seq = new SeqImpl();
        return seq;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Items createItems() {
        ItemsImpl items = new ItemsImpl();
        return items;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Image createImage() {
        ImageImpl image = new ImageImpl();
        return image;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     */
    public Date createRSS10DateFromString(EDataType eDataType, String initialValue) {
        return DateFormatUtil.parse(initialValue);
//        return (Date)super.createFromString(eDataType, initialValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String convertRSS10DateToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public RSS10Package getRSS10Package() {
        return (RSS10Package)getEPackage();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @deprecated
     * @generated
     */
    public static RSS10Package getPackage() {
        return RSS10Package.eINSTANCE;
    }

} //RSS10FactoryImpl
