/*
 * Created on 2004/11/24
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.model.rss10.util;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;


public class DefaultRSS10ResourceFactoryImpl extends RSS10ResourceFactoryImpl {
    public Resource createResource(URI uri) {
        XMLResource result = new DefaultRSS10ResourceImpl(uri);

        result.getDefaultSaveOptions().put(
            XMLResource.OPTION_EXTENDED_META_DATA, extendedMetaData
        );
        result.getDefaultSaveOptions().put(
            XMLResource.OPTION_SCHEMA_LOCATION, Boolean.FALSE
        );
        result.getDefaultSaveOptions().put(
            XMLResource.OPTION_ENCODING, "UTF-8"
        );

        result.getDefaultLoadOptions().put(
            XMLResource.OPTION_EXTENDED_META_DATA, extendedMetaData
        );
        result.getDefaultLoadOptions().put(
            XMLResource.OPTION_USE_LEXICAL_HANDLER, Boolean.TRUE
        );
        result.getDefaultLoadOptions().put(
            XMLResource.OPTION_RECORD_UNKNOWN_FEATURE, Boolean.TRUE
        );

        return result;
    }
}
