/*
 * Created on 2005/01/28
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.common.eclipse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

/**
 * 
 */
public class PluginUtil {

    private PluginUtil() {
    }

    public static void storeProperties(
        Plugin plugin, Properties properties, String propertiesName
    ) {
        IPath path = plugin.getStateLocation().append(propertiesName);
        File file = path.toFile();

        try {
            OutputStream out = new FileOutputStream(path.toFile());
            properties = new Properties();
            properties.store(out, null);
        } catch (IOException e) {
            throw new IllegalStateException(
                "vpeB̕ۑɎs܂:" +
                e.getMessage()
            );
        }
    }

    public static Properties loadProperties(
        Plugin plugin, String propertiesName
    ) {
        Properties ret = new Properties();

        IPath path = plugin.getStateLocation().append(propertiesName);
        File file = path.toFile();

        if (file.exists()) {
            try {
                InputStream in = new FileInputStream(path.toFile());
                ret.load(in);
            } catch (IOException e) {
                throw new IllegalStateException(
                    "vpeB̓ǂݏoɎs܂:" +
                    e.getMessage()
                );
            }
        }

        return ret;
    }
}
