/*
 * Created on 2005/02/23
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.model.impl;

import java.util.Collections;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

import razgriz.news.model.ModelElement;
import razgriz.news.model.util.ModelVisitor;

/**
 * 
 */
public class ModelElementImpl extends EObjectImpl implements ModelElement {
    public void accept(ModelVisitor visitor) {
        for (
            TreeIterator ite = EcoreUtil.getAllContents(
                Collections.singleton(this)
            );
            ite.hasNext();
        ) {
            ModelElement elem = (ModelElement) ite.next();
            Object ret = visitor.doSwitch(elem);
            if (visitor.prune(elem)) {
                ite.prune();
            }
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        } else if (!getClass().equals(o.getClass())) {
            return false;
        } else {
            EObject eobj = (EObject) o;

            EClass cls = eClass();
            EAttribute idattr = cls.getEIDAttribute();
            if (idattr != null) {
                return eGet(idattr).equals(eobj.eGet(idattr));
            } else {
                return super.equals(o);
            }
        }
    }

    public int hashCode() {
        EClass cls = eClass();
        EAttribute idattr = cls.getEIDAttribute();
        if (idattr != null) {
            return idattr.hashCode();
        } else {
            return super.hashCode();
        }
    }
}
