/*
 * Created on 2005/02/01
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.model.util;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;

/**
 * 
 */
public class DefaultNewsResourceFactoryImpl extends NewsResourceFactoryImpl {

    public Resource createResource(URI uri) {
        XMLResource result = new NewsResourceImpl(uri);

        result.getDefaultSaveOptions().put(
            XMLResource.OPTION_EXTENDED_META_DATA, extendedMetaData
        );
        result.getDefaultSaveOptions().put(
            XMLResource.OPTION_SCHEMA_LOCATION, Boolean.FALSE
        );
        result.getDefaultSaveOptions().put(
            XMLResource.OPTION_ENCODING, "UTF-8"
        );

        result.getDefaultLoadOptions().put(
            XMLResource.OPTION_EXTENDED_META_DATA, extendedMetaData
        );
        result.getDefaultLoadOptions().put(
            XMLResource.OPTION_USE_LEXICAL_HANDLER, Boolean.TRUE
        );

        return result;
    }

}
