/**
 * <copyright>
 * </copyright>
 *
 * $Id: NewsAdapterFactory.java,v 1.1 2005/02/26 07:18:17 mkamo Exp $
 */
package razgriz.news.model.util;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

import razgriz.news.model.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see razgriz.news.model.NewsPackage
 * @generated
 */
public class NewsAdapterFactory extends AdapterFactoryImpl {
    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public static final String copyright = "KAMO Masahiko";

    /**
     * The cached model package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static NewsPackage modelPackage;

    /**
     * Creates an instance of the adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NewsAdapterFactory() {
        if (modelPackage == null) {
            modelPackage = NewsPackage.eINSTANCE;
        }
    }

    /**
     * Returns whether this factory is applicable for the type of the object.
     * <!-- begin-user-doc -->
     * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
     * <!-- end-user-doc -->
     * @return whether this factory is applicable for the type of the object.
     * @generated
     */
    public boolean isFactoryForType(Object object) {
        if (object == modelPackage) {
            return true;
        }
        if (object instanceof EObject) {
            return ((EObject)object).eClass().getEPackage() == modelPackage;
        }
        return false;
    }

    /**
     * The switch the delegates to the <code>createXXX</code> methods.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected NewsSwitch modelSwitch =
        new NewsSwitch() {
            public Object caseArticle(Article object) {
                return createArticleAdapter();
            }
            public Object caseNews(News object) {
                return createNewsAdapter();
            }
            public Object caseFavoriteList(FavoriteList object) {
                return createFavoriteListAdapter();
            }
            public Object caseFavorite(Favorite object) {
                return createFavoriteAdapter();
            }
            public Object caseGroup(Group object) {
                return createGroupAdapter();
            }
            public Object defaultCase(EObject object) {
                return createEObjectAdapter();
            }
        };

    /**
     * Creates an adapter for the <code>target</code>.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param target the object to adapt.
     * @return the adapter for the <code>target</code>.
     * @generated
     */
    public Adapter createAdapter(Notifier target) {
        return (Adapter)modelSwitch.doSwitch((EObject)target);
    }


    /**
     * Creates a new adapter for an object of class '{@link razgriz.news.model.Article <em>Article</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see razgriz.news.model.Article
     * @generated
     */
    public Adapter createArticleAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link razgriz.news.model.News <em>News</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see razgriz.news.model.News
     * @generated
     */
    public Adapter createNewsAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link razgriz.news.model.FavoriteList <em>Favorite List</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see razgriz.news.model.FavoriteList
     * @generated
     */
    public Adapter createFavoriteListAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link razgriz.news.model.Favorite <em>Favorite</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see razgriz.news.model.Favorite
     * @generated
     */
    public Adapter createFavoriteAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link razgriz.news.model.Group <em>Group</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see razgriz.news.model.Group
     * @generated
     */
    public Adapter createGroupAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for the default case.
     * <!-- begin-user-doc -->
     * This default implementation returns null.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @generated
     */
    public Adapter createEObjectAdapter() {
        return null;
    }

} //NewsAdapterFactory
