/*
 * Created on 2004/11/24
 *
 * @author KAMO Masahiko (mkamo@users.sourceforge.jp)
 */
package razgriz.news.model.rss20.util;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLResource.XMLInfo;
import org.eclipse.emf.ecore.xmi.XMLResource.XMLMap;
import org.eclipse.emf.ecore.xmi.impl.XMLInfoImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;

import razgriz.news.model.rss20.RSS20Package;
import razgriz.news.model.rss20.util.RSS20ResourceFactoryImpl;
import razgriz.news.model.rss20.util.RSS20ResourceImpl;

/**
 * 
 */
public class DefaultRSS20ResourceFactoryImpl extends RSS20ResourceFactoryImpl {

    private static final XMLMap xmlMap;

    static {
        RSS20Package pkg = RSS20Package.eINSTANCE;

        xmlMap = new XMLMapImpl();
        xmlMap.setNoNamespacePackage(pkg);

        XMLInfo info = null;

        {
            info = new XMLInfoImpl();
            info.setName("rss");
            xmlMap.add(pkg.getRSS(), info);
        }
    }

    public Resource createResource(URI uri) {
        XMLResource result = new RSS20ResourceImpl(uri);

        result.getDefaultSaveOptions().put(
            XMLResource.OPTION_EXTENDED_META_DATA, extendedMetaData
        );
        result.getDefaultSaveOptions().put(
            XMLResource.OPTION_XML_MAP, xmlMap
        );
        result.getDefaultSaveOptions().put(
            XMLResource.OPTION_SCHEMA_LOCATION, Boolean.FALSE
        );
        result.getDefaultSaveOptions().put(
            XMLResource.OPTION_ENCODING, "UTF-8"
        );

        result.getDefaultLoadOptions().put(
            XMLResource.OPTION_EXTENDED_META_DATA, extendedMetaData
        );
        result.getDefaultLoadOptions().put(
            XMLResource.OPTION_XML_MAP, xmlMap
        );
        result.getDefaultLoadOptions().put(
            XMLResource.OPTION_USE_LEXICAL_HANDLER, Boolean.TRUE
        );
        result.getDefaultLoadOptions().put(
            XMLResource.OPTION_RECORD_UNKNOWN_FEATURE, Boolean.TRUE
        );

        return result;
    }

}
