/*
 * Decompiled with CFR 0.152.
 */
package razgriz.news.favlist;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import razgriz.news.NewsException;
import razgriz.news.model.FavoriteList;
import razgriz.news.model.NewsFactory;

public class FavoriteListService {
    private static final String SUFFIX = ".news";
    private Map nameToListMap = new HashMap();

    protected IPath getFavoriteListPath(String listname) {
        IPath rootpath = Platform.getLocation();
        IPath filepath = rootpath.append(String.valueOf(listname) + SUFFIX);
        return filepath;
    }

    public FavoriteList create(String listname) {
        IPath filepath = this.getFavoriteListPath(listname);
        File file = filepath.toFile();
        if (!file.exists()) {
            URI uri = URI.createFileURI((String)file.getAbsolutePath());
            Resource res = new ResourceSetImpl().createResource(uri);
            NewsFactory fact = NewsFactory.eINSTANCE;
            FavoriteList flist = fact.createFavoriteList();
            this.nameToListMap.put(listname, flist);
            res.getContents().add((Object)flist);
            return flist;
        }
        throw new NewsException("Failed to create favorite list");
    }

    public FavoriteList load(String listname) {
        return this.load(listname, true);
    }

    public FavoriteList load(String listname, boolean create) {
        IPath filepath = this.getFavoriteListPath(listname);
        File file = filepath.toFile();
        try {
            if (file.exists()) {
                URI uri = URI.createFileURI((String)file.getAbsolutePath());
                Resource res = new ResourceSetImpl().getResource(uri, true);
                res.load(null);
                FavoriteList ret = (FavoriteList)res.getContents().get(0);
                this.nameToListMap.put(listname, ret);
                return ret;
            }
            if (create) {
                return this.create(listname);
            }
            throw new NewsException("Failed to load favorite list");
        }
        catch (IOException e) {
            throw new NewsException(e);
        }
    }

    public void save(String listname) {
        FavoriteList list = (FavoriteList)this.nameToListMap.get(listname);
        if (list == null) {
            throw new NewsException("Favorite list not found(listname=" + listname + ")");
        }
        IPath filepath = this.getFavoriteListPath(listname);
        URI uri = URI.createFileURI((String)filepath.toFile().getAbsolutePath());
        try {
            Resource res = new ResourceSetImpl().createResource(uri);
            res.getContents().clear();
            res.getContents().add((Object)list);
            res.save(null);
        }
        catch (IOException e) {
            throw new NewsException(e);
        }
    }
}

