#include <cstdio>
#include <iostream.h>
#include "player_command.h"

int player_command::init(std::string team, bool goalie)
{
  std::string msg = "(init " + team + " (version 7)";
  if (goalie) {
    msg += "(goalie)";
  }
  msg += ")";

  server.send(msg);
  cerr << msg << endl;
  server.recv(msg);
  cerr << msg << endl;
  cerr.flush();

  {
    char t;
    char pmode[32];
    int unum;
    if (::sscanf(msg.c_str(), "(init %c %d %s)", &t, &unum, pmode) == 0) {
      server.close();
      exit(1);
    }
    this->side = t;
    this->number = unum;

    switch (t) {
    case 'r':
      return -1 * unum;
    case 'l':
      return unum;
    default:
      this->bye();
      exit(1);
    }
  }
}

int player_command::bye()
{
  std::string bye = "bye";
  server.send(bye);
  server.close();

  return 0;
}

int player_command::kick(double pow, double dir)
{
  static char cmd_buf[128];
  ::sprintf(cmd_buf, "(kick %f %f)\n", pow, dir);
  std::string cmd = cmd_buf;
  server.send(cmd);
  return 0;
}

int player_command::dash(double pow)
{
  static char cmd_buf[128];
  ::sprintf(cmd_buf, "(dash %f)\n", pow);
  std::string cmd = cmd_buf;
  server.send(cmd);
  return 0;
}

int player_command::turn(double dir)
{
  static char cmd_buf[128];
  ::sprintf(cmd_buf,  "(turn %f)\n", dir);
  std::string cmd = cmd_buf;
  server.send(cmd);
  return 0;
}
