
#include <fcntl.h>
#include </sys/dev/ppbus/ppi.h>
#include </sys/dev/ppbus/ppbconf.h>
#include <stdio.h>

#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>

#include "dpp-psx-freebsd.h"

/*  =========================				*/
/*  | o o o | o o o | o o o | Controller plug		*/
/*   \_____________________/				*/
/*    1 2 3   4 5 6   7 8 9				*/
/* 							*/
/*    Controller          Parallel			*/
/*    1 - Data              10(pad1),13(pad2)           */
/*    2 - Command           2                           */
/*    3 - 9V(shock)         +9V battery terminal        */
/*    4 - GND               18 , also -9V battery terminal */
/*    5 - V+                6,7,8,9 through diodes      */
/*    6 - ATT               3                           */
/*    7 - Clock             4                           */
/*    9 - ack               12(pad1), 15(pad2)          */

#define MINJOY (-32768)
#define MAXJOY (32767)
#define MIDJOY (0)

u_int8_t p0 = 0xf8+4+2+1;
static int multitap = 0;
static int psxdelay = 3;
static int ppi_fd;

void Clk(int i)
{
  const u_int8_t clk=0x04;            /*  Bit 3 Base+0 (parallel port) */

  if (i)
    p0 |= clk;
  else
    p0 &= ~clk;
  
  /* _outp(base+0, p0); */
  ioctl(ppi_fd, PPISDATA, &p0);
}

void Sel(int i, int id)
{
  const u_int8_t power=0xf8;          /*  Bits 3-7 Base+0 (parallel port) */
  const u_int8_t att=0x02;            /*  Bit 2 Base+0 (parallel port) */
  u_int8_t attary[] = { 0, 0x02, 0x08, 0x10, 0x20, 0x40 };
  u_int8_t attval;

  if (multitap)
    attval = attary[id];
  else
    attval = att;

  p0 |= power;

  if (i)
    p0 |= attval;
  else
    p0 &= ~attval;

  /* _outp(base+0, p0); */
  ioctl(ppi_fd, PPISDATA, &p0);
}

void Cmd(int i)
{
  const u_int8_t cmd=0x01;            /*  Bit 1 Base+0 (parallel port) */
  if (i)
    p0 |= cmd;
  else
    p0 &= ~cmd;

  /* _outp(base+0, p0); */
  ioctl(ppi_fd, PPISDATA, &p0);
}


int Dat(int id)
{
  u_int8_t data;
  u_int8_t status;

  if (multitap)
    data = 0x40;
  else {
    if (id==1) data = 0x40;
    else data = 0x10;
  }

  /*  status = _inp(base+1); */
  ioctl(ppi_fd, PPIGSTATUS, &status);

  if (status & data)
    return 1;
  else
    return 0;
}

int Ack(int id)
{
  u_int8_t ack;
  u_int8_t status;

  if (multitap)
    ack = 0x20;
  else {
    if (id==1) ack = 0x20;
    else ack = 0x08;
  }

  /*  status = _inp(base+1); */
  ioctl(ppi_fd, PPIGSTATUS, &status);

  if (status & ack)
    return 1;
  else
    return 0;
}


void Slow()
{
  int i;
  if (psxdelay==3) {
    for (i=0; i<3; i++)
      /*  _outp(base+0, p0); */
      ioctl(ppi_fd, PPISDATA, &p0);
  } else {
    for (i=0; i<psxdelay; i++)
      /*  _outp(base+0, p0); */
      ioctl(ppi_fd, PPISDATA, &p0);
  }
}

u_int8_t SendByte(u_int8_t byte, int wait, int id)
{
  int i,j; /* ,k; */
  u_int8_t data;

  data=0;
  for (i=0; i<8; i++) {
    Slow();
    Cmd(byte&(1<<i));
    Clk(0);
    Slow();
    data |= (Dat(id)?(1<<i):0);  /*  Moved prior to clock rising edge */
    Clk(1);
  }
  /*  Wait for ACK; */
  for(j=0; wait && j<30 && Ack(id); j++)
    ;
  /* 	for(k=0; wait && k<30 && !Ack(id, base); k++); */
  /* 	if (j==300 || k==300) data=0; */
  return data;
}


void SendPSXString(	int string[], int id )
{
  int i;
	
  Sel(1, id);
  Clk(1);
  Cmd(1);
  Slow();
  Slow();
  Slow();
  Slow();
  Sel(0, id);
  Slow();
  Slow();
  Slow();
  for (i=0; string[i+1]!=-1; i++)
    SendByte((u_int8_t)string[i],1,id);
  SendByte((u_int8_t)string[i],0,id);
  Slow();
  Sel(1, id);
  Cmd(1);
  Clk(1);
  Slow();
  Slow();
}

void Shock(long id, long base, long small, long big)
{
  int i;
  static int ShockString[4][12]= {
    {0x01, 0x43, 0x00, 0x01, 0x00, 0x01, -1},
    {0x01, 0x4d, 0x00, 0x00, 0x01, 0xff, 0xff, 0xff, 0xff, 0x01, -1},
    {0x01, 0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, -1},
    {0x01, 0x42, 0x00, 0xff, 0xff, 0x01, -1 } };

  ShockString[3][3] = (int)small;
  ShockString[3][4] = (int)big;
  for (i=0; i<4; i++) {
    Slow();
    Slow();
    Slow();
    SendPSXString( ShockString[i], id);
  }
}


int ScanPSX( myPSX *psx, int id )
{
  /*   extern void ForceFeedback( DWORD dwDeviceID, int controller, int always, myPSX *psx ); */
  u_int8_t data[10];

  Sel(1, id);
  Clk(1);
  Cmd(1);
  Slow();
  Slow();
  Slow();
  Slow();
  Slow();
  Sel(0, id);
  Slow();
  Slow();
  Slow();
  Slow();
  data[0]=SendByte(0x01,1,id);
  data[1]=SendByte(0x42,1,id);
  if (data[1]==0x41) {
    data[2]=SendByte(0x00,1,id);
    data[3]=SendByte(0x00,1,id);
    data[4]=SendByte(0x00,0,id);
  } else if (data[1]==0x53) {
    data[2]=SendByte(0x00,1,id);
    data[3]=SendByte(0x00,1,id);
    data[4]=SendByte(0x00,1,id);
    data[5]=SendByte(0x00,1,id);
    data[6]=SendByte(0x00,1,id);
    data[7]=SendByte(0x00,1,id);
    data[8]=SendByte(0x00,0,id);
  } else if (data[1]==0x73 || data[1]==0x23) {
    data[2]=SendByte(0x00,1,id);
    data[3]=SendByte(0x00,1,id);
    data[4]=SendByte(0x00,1,id);
    data[5]=SendByte(0x00,1,id);
    data[6]=SendByte(0x00,1,id);
    data[7]=SendByte(0x00,1,id);
    data[8]=SendByte(0x00,1,id);
    data[9]=SendByte(0x00,0,id);
  } else {
    data[1] = 0;
    data[2] = 0;
    data[3] = 255;
    data[4] = 255;
    data[5] = 128;
    data[6] = 128;
    data[7] = 128;
    data[8] = 128;
    data[9] = 0;
  }

  Slow();
  Slow();
  Sel(1, id);
  Cmd(1);
  Clk(1);
  Slow();
	
  psx->lf = data[3]&0x80?0:1;
  psx->dn = data[3]&0x40?0:1;
  psx->rt = data[3]&0x20?0:1;
  psx->up = data[3]&0x10?0:1;
  psx->start = data[3]&0x08?0:1;
  psx->select = data[3]&0x01?0:1;
  psx->cross = data[4]&0x40?0:1;
  psx->circle = data[4]&0x20?0:1;
  psx->l2 = data[4]&0x01?0:1;
  psx->r3 = data[3]&0x04?0:1;
  psx->l3 = data[3]&0x02?0:1;
  if (data[1]!=0x41) {
    psx->rx = data[5];
    psx->ry = data[6];
    psx->lx = data[7];
    psx->ly = data[8];
  } else {
    psx->lx = psx->rx = psx->lf? 0:(psx->rt? 255: 128);
    psx->ly = psx->ry = psx->up? 0:(psx->dn? 255: 128);
  }

  switch (data[1]) {
  case 0x73: /* analog red mode */
  case 0x53: /* analog green mode */
    psx->l1 = data[4]&0x04?0:1;
    psx->r1 = data[4]&0x08?0:1;
    psx->triangle = data[4]&0x10?0:1;
    psx->r2 = data[4]&0x02?0:1;
    psx->box = data[4]&0x80?0:1;
    break;
  default:
    psx->box = data[4]&0x80?0:1;
    psx->triangle = data[4]&0x10?0:1;
    psx->r1 = data[4]&0x08?0:1;
    psx->l1 = data[4]&0x04?0:1;
    psx->r2 = data[4]&0x02?0:1;
    break;
  }

  /*  ForceFeedback( curJoy-1, id, base, 0, psx ); */

  return data[1];
}

int ScanPSX2(char *data, int id )
{
  /*   extern void ForceFeedback( DWORD dwDeviceID, int controller, int always, myPSX *psx ); */
  Sel(1, id);
  Clk(1);
  Cmd(1);
  Slow();
  Slow();
  Slow();
  Slow();
  Slow();
  Sel(0, id);
  Slow();
  Slow();
  Slow();
  Slow();
  data[0]=SendByte(0x01,1,id);
  data[1]=SendByte(0x42,1,id);
  if (data[1]==0x41) {
    data[2]=SendByte(0x00,1,id);
    data[3]=SendByte(0x00,1,id);
    data[4]=SendByte(0x00,0,id);
  } else if (data[1]==0x53) {
    data[2]=SendByte(0x00,1,id);
    data[3]=SendByte(0x00,1,id);
    data[4]=SendByte(0x00,1,id);
    data[5]=SendByte(0x00,1,id);
    data[6]=SendByte(0x00,1,id);
    data[7]=SendByte(0x00,1,id);
    data[8]=SendByte(0x00,0,id);
  } else if (data[1]==0x73 || data[1]==0x23) {
    data[2]=SendByte(0x00,1,id);
    data[3]=SendByte(0x00,1,id);
    data[4]=SendByte(0x00,1,id);
    data[5]=SendByte(0x00,1,id);
    data[6]=SendByte(0x00,1,id);
    data[7]=SendByte(0x00,1,id);
    data[8]=SendByte(0x00,1,id);
    data[9]=SendByte(0x00,0,id);
  } else {
    data[1] = 0;
    data[2] = 0;
    data[3] = 255;
    data[4] = 255;
    data[5] = 128;
    data[6] = 128;
    data[7] = 128;
    data[8] = 128;
    data[9] = 0;
  }

  Slow();
  Slow();
  Sel(1, id);
  Cmd(1);
  Clk(1);
  Slow();

  /*  ForceFeedback( curJoy-1, id, base, 0, psx ); */

  return data[1];
}

void open_psx()
{
  ppi_fd = open("/dev/ppi0", O_RDWR, 0600);
}
void close_psx()
{
  close(ppi_fd);
}

#if 0
int main()
{
  int i;
  myPSX psx;
  fd_set fds;



  for (i = 0; i < 1000000; i++){
    struct timeval timeout;
    timeout.tv_sec = 0;
    timeout.tv_usec = 20000;
    FD_ZERO(&fds);
    FD_SET(ppi_fd, &fds);
    if (select(FD_SETSIZE, &fds, NULL, NULL, &timeout) < 0) {
      continue;
    }
    printf("ID=%x:", ScanPSX( &psx, 1));
    printf("%c %c %c %c:",
	   (psx.dn?'D':'-'), (psx.up?'U':'-'),
	   (psx.lf?'L':'-'), (psx.rt?'R':'-'));
    printf("%s%c %s%s:",
	   (psx.box?"[]":"- "), (psx.cross?'X':'-'),
	   (psx.circle?"()":"- "), (psx.triangle?"/\\":"- "));
    printf("R%c%c%c:%4d:%4d:",
	   (psx.r1? '1': '-'), (psx.r2? '2': '-'), (psx.r3? '3': '-'),
	   psx.rx, psx.ry);
    printf("L%c%c%c:%4d:%4d\n",
	   (psx.l1? '1': '-'), (psx.l2? '2': '-'), (psx.l3? '3': '-'),
    	   psx.lx, psx.ly);
    
  }
  close(ppi_fd);

  return 0;
}
#endif
