
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>


#include "dpp-psx-freebsd.h"
#include "dpp.h"
#include "serv.h"

void open_dev()
{
  open_psx();
}

void close_dev()
{
  close_psx();
}

int loop_scan_dpp()
{
  static unsigned char datas[2][10];
  unsigned char *data;
  static int times = 0;
  int diff = 0;
  int i;

  data = datas[times % 2];
  ScanPSX2(data, 1);
  data[3] = data[3] ^ 0xff;
  data[4] = data[4] ^ 0xff;

  for (i = 0; i < 10; i++) {
    if (datas[0][i] != datas[1][i]) {
      diff++;
      break;
    }
  }

  if (diff) {
    int i;
    unsigned char buf[7];
    printf("#%02d [TYPE:%02x] %02x %02x %02x %02x %02x %02x\n",
	   (data[1] & 0x0f), ((data[1] & 0xf0) >> 4),
	   data[3], data[4], data[5], data[6], data[7], data[8]);
    for (i = 1; i < 7; i++) {
      buf[i] = data[i + 2];
    }
    for (i = 0; i < 12; i++) {
      buf[0] = (i & 0xf) + (data[1] & 0xf0);
      send_data(i, buf, sizeof(buf));
    } 
  }
  times++;
  return 1;
}
int loop_scan_socket()
{
  fd_set fdset;
  int max = set_socket_fdset(&fdset);
  struct timeval timeout;
  timeout.tv_sec = 0;
  timeout.tv_usec = 1;
  if (select(max + 1, &fdset, NULL, NULL, &timeout) > 0) {
    receive_request(&fdset);
  }
  return 1;
}

int loop()
{
  loop_scan_socket();
  loop_scan_dpp();

  return 1;
}
