#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "serv.h"

static int sio;
char buf[10];

void open_dev()
{
  struct termios tio;

  sio = open("/dev/ttyS0", O_RDONLY | O_NOCTTY);
  if (sio < 0) {
    perror("/dev/ttyS0"); exit(1);
  }
  bzero((char *)&tio, sizeof(tio));
  tio.c_cflag = B115200 | CRTSCTS | CS8 | CLOCAL | CREAD;
  tio.c_iflag = IGNPAR | ICRNL;
  tio.c_oflag = 0;
  tio.c_lflag = 0;
  tio.c_cc[VMIN] = 7;
  tcflush(sio, TCIFLUSH);
  tcsetattr(sio, TCSANOW, &tio);
}

void close_dev()
{
  close(sio);
}

int loop_scan_sio()
{
  int num, type;

  read(sio, buf, 7);
  type = (buf[0] & 0xf0) >> 4;
  num  = (buf[0] & 0x0f);
  buf[1] = buf[1] ^ 0xff;
  buf[2] = buf[2] ^ 0xff;
  buf[3] -= 128;
  buf[4] -= 128;
  buf[5] -= 128;
  buf[6] -= 128;
  printf("#%02d [TYPE:%02x] %02x %02x %4d %4d %4d %4d\n",
	 num, type, buf[1], buf[2], buf[3], buf[4], buf[5], buf[6]);
  send_data(num, buf, sizeof(buf));

  return 1;
}

int loop_scan_socket()
{
  struct timeval timeout;
  fd_set fdset;
  int max = set_socket_fdset(&fdset);

  FD_SET(sio, &fdset);
  if (max < sio) {
    max = sio;
  }
  timeout.tv_sec = 0;
  timeout.tv_usec = 1;
  if (select(max + 1, &fdset, NULL, NULL, &timeout) > 0) {
    if (FD_ISSET(sio, &fdset)) {
      loop_scan_sio();
    }
    receive_request(&fdset);
  }
  return 1;
}

int loop()
{
  loop_scan_socket();
  return 1;
}

