# = to_s Builder
#
#--
# Ruby version 1.8
#
# == Authors
# * Yomei Komiya
# 
# == Copyright
# 2008 the original author or authors.
#
# == License
# Apache License 2.0
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#  http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#++
# == Version
# SVN: $Id: to_s_builder.rb 75 2008-10-12 10:35:52Z whitestar $
#
# == Since
# File available since Release 0.8.0

require 'commons/lang/builder/to_s_style'

module Commons
  module Lang
    module Builder
      
      # This class supports the implementation of to_s method.
      #
      # Example:
      #   require 'commons/lang/builder/to_s_builder'
      #     
      #   class Person
      #     def initialize
      #       @name = nil
      #       @age = nil
      #     end
      #     # ...
      #     def to_s
      #       return Commons::Lang::Builder::ToSBuilder.new(self).
      #         append('name', @name).
      #         append('age', @age).
      #         to_s
      #     end
      #   end
      class ToSBuilder
        @@default_style = ToSStyle::DEFAULT_STYLE
        
        attr_reader :buffer, :style, :object
        
        def self.get_default_style
          return @@default_style
        end
        
        
        def self.set_default_style(style)
          if style == nil
            raise ArgumentError, 'The style must not be nil'
          end
          @@default_style = style
        end
        
        
        def initialize(object, style = nil, buffer = nil)
          if style == nil
            style = get_default_style
          end
          if buffer == nil
            buffer = String.new('')
          end
          @buffer = buffer
          @style = style
          @object = object
          
          style.append_start(buffer, object)
        end
        
        
        def append(field_name, value, full_detail = true)
          @style.append(@buffer, field_name, value, full_detail)
          return self
        end
        
        
        def append_super(super_to_s)
          if super_to_s != nil
            @style.append_super(@buffer, super_to_s)
          end
          return self
        end
        
        
        def append_to_s(to_s)
          if to_s != nil
            @style.append_to_s(@buffer, to_s)
          end
          return self
        end
        
        
        def to_s
          if @object == nil
            @buffer.append(@style.get_nil_text)
          else
            @style.append_end(@buffer, @object)
          end
          return @buffer.to_s
        end
      end

    end
  end
end
