# = Properties
# 
#--
# Ruby version 1.8
#
# == Authors
# * Yomei Komiya
# 
# == Copyright
# 2008 the original author or authors.
#
# == License
# Apache License 2.0
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#  http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#++
# == Version
# SVN: $Id: properties_test.rb 76 2008-10-12 11:45:33Z whitestar $
#
# == Since
# File available since Release 0.8.0

require 'commons/ruby/test/unit'

require 'commons/util/properties'

module Commons
  module Util
    
    class PropertiesTest < Test::Unit::TestCase
      
      def setup
        @props = Properties.new
        props_path = File.dirname(__FILE__) + '/sample.properties'
        File.open(props_path, 'r') {|file|
          @props.load(file)
        }
      end
      
      
      def teardown
      end
      
      
      def test_initialize
        props = Properties.new
        assert_true(props.properties.empty?)
        # TODO:
      end
      
      
      def test_load
        expected = Hash[
          'test.key1', 'value1',
          'test.key2', 'value2']
        assert_equal(expected, @props.properties)
      end
      
      
      def test_property_names
        expected = Array['test.key1', 'test.key2']
        assert_equal(expected, @props.property_names)
      end
      
      
      def test_get_property
        default_value = 'default'
        assert_equal(default_value, @props.get_property('no_key', default_value))
        
        assert_nil(@props.get_property('no_key'))
      end
      
      
      def test_set_property
        expected = 'value200'
        @props.set_property('key200', expected)
        assert_equal(expected, @props.get_property('key200'))
      end
    end
    
  end
end
