# = Log
# 
#--
# Ruby version 1.8
#
# == Authors
# * Yomei Komiya
# 
# == Copyright
# 2008 the original author or authors.
#
# == License
# Apache License 2.0
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#  http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#++
# == Version
# SVN: $Id: log.rb 77 2008-10-12 12:07:49Z whitestar $
#
# == Since
# File available since Release 0.8.0

module Commons
  module Logging

    module Log
      TRACE = :TRACE
      DEBUG = :DEBUG
      INFO  = :INFO
      WARN  = :WARN
      ERROR = :ERROR
      FATAL = :FATAL
      
      
      def trace(message, exception = nil)
        log(TRACE, message, exception)
      end
      
      
      def debug(message, exception = nil)
        log(DEBUG, message, exception)
      end
      

      def info(message, exception = nil)
        log(INFO, message, exception)
      end
      
      
      def warn(message, exception = nil)
        log(WARN, message, exception)
      end
      
      
      def error(message, exception = nil)
        log(ERROR, message, exception)
      end
      
      
      def fatal(message, exception = nil)
        log(FATAL, message, exception)
      end
      
      
      def trace?
        return enabled_for?(TRACE)
      end
      
      
      def debug?
        return enabled_for?(DEBUG)
      end
      
      
      def info?
        return enabled_for?(INFO)
      end
      
      
      def warn?
        return enabled_for?(WARN)
      end
      
      
      def error?
        return enabled_for?(ERROR)
      end
      
      
      def fatal?
        return enabled_for?(FATAL)
      end
    end

  end
end
