# = Properties
# 
#--
# Ruby version 1.8
#
# == Authors
# * Yomei Komiya
# 
# == Copyright
# 2008 the original author or authors.
#
# == License
# Apache License 2.0
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#  http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#++
# == Version
# SVN: $Id: properties.rb 77 2008-10-12 12:07:49Z whitestar $
#
# == Since
# File available since Release 0.8.0

module Commons
  module Util
    
    class Properties
      attr_reader :properties
      
        
      def initialize(defaults = nil)
        @properties = Hash.new
        
        if defaults != nil
          @defaults = defaults
        end
      end
      
      
      def load(file)
        file.each_line {|line|
          line.strip!
          if line != '' && line[0].chr != '#'
            pos = line.index('=')
            if pos != nil && pos > 1
              key = line[0 ... pos].strip
              value = line[pos + 1 .. -1].strip
              if value[0].chr == '"' && value[-1].chr == '"'
                value = value[1 ... -1]
              end
              set_property(key, value)
            end
          end
        }
      end
      
      
      def property_names
        return @properties.keys
      end
      
      
      def get_property(key, default_value = nil)
        value = @properties[key]
        return value == nil ? default_value : value
      end
      
      
      def set_property(key, value)
        @properties[key] = value
      end
    end
    
  end
end
