# = to_s Builder Test Case
#
#--
# Ruby version 1.8
#
# == Authors
# * Yomei Komiya
# 
# == Copyright
# 2008 the original author or authors.
#
# == License
# Apache License 2.0
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#  http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#++
# == Version
# SVN: $Id: to_s_builder_test.rb 76 2008-10-12 11:45:33Z whitestar $
#
# == Since
# File available since Release 0.8.0

require 'commons/ruby/test/unit'

require 'commons/lang/builder/to_s_builder'

module Commons
  module Lang
    module Builder
      
      class ToSBuilderTest < Test::Unit::TestCase
        
        def setup
          $KCODE = 'UTF8'
        end
        
        
        def teardown
          $KCODE = 'NONE'
        end

        
        def test_initialize
          # no test.
        end
        
        
        def test_append
          styles = [
            ToSStyle::DEFAULT_STYLE,
            ToSStyle::MULTI_LINE_STYLE,
            ToSStyle::NO_FIELD_NAMES_STYLE,
            ToSStyle::SHORT_PREFIX_STYLE,
            ToSStyle::SIMPLE_STYLE
          ]
          
          styles.each {|style|
            builder = ToSBuilder.new(Object.new, style)
            
            cyclic_object = [1,2]
            cyclic_object.push(cyclic_object)
            cyclic_object.push(cyclic_object)
            
            builder.append('Nil0', nil)
            builder.append('Nil1', nil, false)
            builder.append('True0', true)
            builder.append('False1', false, false)
            builder.append('Integer0', 100)
            builder.append('Integer1', 101, false)
            builder.append('Float0', 1234.5678)
            builder.append('Float1', 3.141592, false)
            builder.append('String0', 'string0')
            builder.append('String1', 'string1', false)
            builder.append('Hash0', Hash['key1','value1', 'key2','value2'])
            builder.append('Hash1', Hash['key1','value1', 'key2','value2'], false)
            builder.append('Array0', [1,2,3])
            builder.append('Array1', [4,5,6], false)
            builder.append('Array2', [1,2,Hash['name','test', 'flag',true]])
            builder.append('Object0', Object.new)
            builder.append('Object1', Object.new, false)
            builder.append('cyclic_object0', cyclic_object)
            builder.append('cyclic_object1', cyclic_object, false)
          
            puts builder.to_s
          }
        end
      end
      
    end
  end
end
