# = Log4r Logger Test Case
#
#--
# Ruby version 1.8
#
# == Authors
# * Yomei Komiya
# 
# == Copyright
# 2008 the original author or authors.
#
# == License
# Apache License 2.0
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#  http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#++
# == Version
# SVN: $Id: logger_test.rb 76 2008-10-12 11:45:33Z whitestar $
#
# == Since
# File available since Release 0.8.0

#require 'log4r'
require 'commons/ruby/log4r'

require 'log4r/configurator'
require 'log4r/yamlconfigurator'

require 'commons/ruby/test/unit'

module Log4r

  class LoggerTest < Test::Unit::TestCase
    LOG = Logger.get_logger(self.name)
      
    def setup
    end
      
      
    def teardown
    end
    
    
    def test_log_by_xml_configurator
      if LOG.debug?
        LOG.debug('This is DEBUG log by LOG.')
      end
      LOG.info('This is INFO log by LOG.')
      LOG.warn('This is WARN log by LOG.')
      LOG.error('This is ERROR log by LOG.')
      LOG.fatal('This is FATAL log by LOG.')
      
      #Configurator.load_xml_file(File.dirname(__FILE__) + '/log4r.xml');
      logger = Logger.get_logger(self.class.name)
      #logger = Logger.new(self.class.name)
      
      if logger.debug?
        logger.debug('This is DEBUG log.')
      end
      logger.info('This is INFO log.')
      logger.warn('This is WARN log.')
      logger.error('This is ERROR log.')
      logger.fatal('This is FATAL log.')
    end
    
    
    def test_log_by_yaml_configurator
      YamlConfigurator.load_yaml_file(File.dirname(__FILE__) + '/log4r.yaml');
      logger = Logger.get_logger(self.class.name)
      #logger = Logger.new(self.class.name)
      
      if logger.debug?
        logger.debug('This is DEBUG log.')
      end
      logger.info('This is INFO log.')
      logger.warn('This is WARN log.')
      logger.error('This is ERROR log.')
      logger.fatal('This is FATAL log.')
    end
  end

end
